function [box zero range eigvec]=make_box(points)

N=size(points,1);
dim=size(points,2);
num_of_points=size(points,2);

meanval=mean(points,2);
[a eigvec]=eig((points-meanval*ones(1,num_of_points))*(points-meanval*ones(1,num_of_points))');

pom=eigvec*(points-meanval*ones(1,num_of_points));

range=(max(pom)-min(pom))';

box=zeros(N,dim);
pointer=-range;
step=2*range/(num_of_points-1);
jump=[1 num_of_points num_of_points^2];
for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
end  

box=(box)*eigvec'+ones(N,1)*meanval;
range=ones(3,1)./(2*range);
zero=box(1,:);

plot3(points(1,:),points(2,:),points(3,:),'r.');
hold on;
plot3(box(:,1),box(:,2),box(:,3),'g.');

end
