function [box zero range eigvec num_of_points]=makebox3(points)

%OK

N=size(points,1);
dim=size(points,2);

num_of_points=round(N^(1/dim));

meanval=mean(points,1);
[eigvec,eigval]=eig((points-ones(N,1)*meanval)'*(points-ones(N,1)*meanval));

pom=abs(eigvec'*(points-ones(N,1)*meanval)');
%plot3(pom(1,:),pom(2,:),pom(3,:),'r.');
range=(max(pom')-min(pom'))';

box=zeros(N,dim);
pointer=-range;
step=2*range/(num_of_points-1);
jump=[1 num_of_points num_of_points^2];

for i=1:N
    for k=1:dim
        box(i,k)=pointer(k)+step(k)*mod(floor((i-1)/jump(k)),num_of_points);
    end
end  

box=(box)*eigvec+ones(N,1)*meanval;

plot3(points(:,1),points(:,2),points(:,3),'r.');
hold on;
plot3(box(:,1),box(:,2),box(:,3),'g.');
end
