function [H_new ny]=update_hyperstate(H_old, ny)
H_new=zeros(size(H_old));
H_new(1,:,:)=H_old(1,:,:);
next_u=zeros(1,size(ny,2));

%generate trajectories
for j=1:size(H_old,2)
    eta=H_old(1,j,1);
    beta=H_old(1,j,2);
    best_control=-ny(1,j);
    
    for i=1:size(H_old,1)-1        
        s=randn;
        pom=sqrt(1+best_control^2);
        eta=abs(eta+beta*best_control+pom*s);
        beta=abs(pom*beta+best_control*s);
        H_new(i+1,j,:)=[eta beta];
        if i+1<size(H_old,1)
            index=find_in_hyperstate5([eta beta],H_old(i+1,:,:));
            best_control=-ny(i,index);
        end
    end
end

%make box
pom=zeros(size(H_new,2),2);
for i=2:size(H_new,1)
    pom(:,:)=H_new(i,:,:);    
    [H_new(i,:,:)]=make_box3(pom); %rovnomerne rozmisti body v zasazenem regionu
   % plot(H_new(i,:,1), H_new(i,:,2),'b.' ); hold on; plot(pom(:,1),pom(:,2), 'g.' ); plot(H_old(i,:,1),H_old(i,:,2), 'r.' ); hold off
end

%kopirovani stareho ny* do H_new  
for i=2:size(H_new,1)
    for j=1:size(H_new,2)
        pom(1,:)=H_new(i,j,:);
        index=find_in_hyperstate5(pom,H_old(i,:,:));
        next_u(j)=ny(i,index);
    end
    ny(i,:)= next_u;
end

        %vypis(:,:)=H_new(:,:,1);
        %save 'eta2.txt' vypis -ASCII;
        %vypis(:,:)=H_new(:,:,2);
        %save 'Beta2.txt' vypis -ASCII;
        %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 save 'ny2.txt' ny -ASCII;   
        
end
