function box=makebox2(points,ng)
N=size(points,2);
dim=size(points,1);

meanval=mean(points,2);
pointsp=points-meanval*ones(1,N);

D=pointsp*pointsp';
[eigvec,eigval]=eig(D);
meanval=mean(points,2);
range=3*sqrt(diag(eigval)/N);

pointsp=eigvec'*pointsp;

box=zeros(dim,ng*ng);
zac=-range;
step=2*range/ng;
for i=1:ng
    for j=1:ng
        box(:,(i-1)*ng+j)=zac+[(i-1);(j-1)].*step;
    end
end  



plot(pointsp(1,:),pointsp(2,:),'.');
axis equal;
hold on;
plot(points(1,:),points(2,:),'r.');
plot([-range(1) range(1) range(1) -range(1) -range(1)],[-range(2) -range(2) range(2) range(2) -range(2)],'g');

end
