clear all
% load data created by the pdfDS_example
load pdfds_results

DS.class   = 'MemDS';
DS.Data    = Data;
DS.drv     = drv;

%%%%%% ARX estimator

A1.class = 'ARX';
A1.rv = y;
A1.rgr = RVtimes([y,u],[-3,-1]) ; % correct structure is {y,y}
A1.log_level ='logbounds,logevidence';

A2=A1;
A2.constant = 0;

A3=A2;
A3.frg = 0.95;


%name them
A1.name='A1';
A2.name='A2';
A2.rv_param = RV({'a2th', 'r'},[2,1],[0,0]);
A3.name='A3';
A3.rv_param = RV({'a3th', 'r'},[2,1],[0,0]);

M=estimator(DS,{A1,A2,A3});

%%%% Process results
lls = [sum(M.A1_evidence_) sum(M.A2_evidence_) sum(M.A3_evidence_)]

ells=exp(lls-max(lls));
Model_probabilities=ells/sum(ells)