// Header for using DDEClient.dll in other C/C++ programs
//
// Author:  Robert Matovinovic
// Version: 0.02
// Date:    04.10.2006
//

// DDE data structure for access data received by DDE transaction
typedef struct {
	// pointer to begin of dde data returned by DdeAccessData
	BYTE* pData;
	// length of dde data returned by DdeAccessData
	DWORD dwLen;
	// string pointer to dde data, if the data should accessed as string
	char* pszData;
	// ID of transaction, used to determine completion of asynchronous transaction
	DWORD dwTransID;
	// ID of transaction, returned by callback function with asynch. transaction
	DWORD dwCbTransID;
	// string for access type of data
	char szAccType[7];
} DCDATAACCESS;

#define DCDllImport extern "C" _declspec( dllimport )

//
// imported variables
//
// boolean used by DCLastError
DCDllImport bool bDCErrorExport;
// pointer to dde data access structure
DCDllImport DCDATAACCESS* *DCDA;

//
// imported functions
//
DCDllImport bool DCRequestString(WORD wC,
								 char szItem[], 
								 int nTimeout);
DCDllImport bool DCRequest(WORD wC,
						   char szItem[], 
				 		   char szFormat[], 
						   int nTimeout );
DCDllImport bool DCTransaction(WORD wC,
							   char szType[], 
							  char szItem[],
							  char szData[],
							  char szFormat[], 
							  int nTimeout,
							  char szAccess[]);
DCDllImport bool DCConnect(WORD* pConvNo,
						   char szService[], 
							char szTopic[]);
DCDllImport bool DCDisconnect(WORD wConvNo);
DCDllImport bool DCInit();
DCDllImport bool DCUninit();
DCDllImport char* DCLastError();
DCDllImport bool DCAsynchTransactionCompleted(WORD wC, DWORD dwTransID, bool bWait);
DCDllImport bool DCFreeDdeMem(WORD wC);
DCDllImport void DCFinalize();
DCDllImport bool DCAbandonTransaction(WORD wC, DWORD dwTransID);
DCDllImport char* DCVersion();


