/*!
  \file
  \brief Utility functions for BDM unit tests.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef TEST_UTIL_H
#define TEST_UTIL_H

#include <string>
#include "itpp_ext.h"

namespace bdm {

class epdf;

/*! \brief Non-general but simple file load.

  Handles only text files smaller than 8KB which do not contain '\0'
  characters, but for testing that should be enough.
*/
std::string load_test_file ( const char *fname );

double normcoef ( const epdf *ep, const itpp::vec &xb, const itpp::vec &yb,
                  int xn = 100, int yn = 100 );

itpp::vec num_mean2 ( const epdf *ep, const itpp::vec &xb, const itpp::vec &yb,
                      int xn = 100, int yn = 100 );

}

#endif
