classdef mexKalman < mexBM
    % Approximate Bayesian 
    properties
	     A
	     B
	     C
	     D
	     Q
	     R
        predX;              % predictive density on x
        predY;              % predictive density on y
    end
    methods
        function obj=validate(obj)                   
		  		% TODO: check sizes of A,B,C,D,Q,R
            obj.apost_pdf = mexGauss;
				obj.predX = mexGauss;
				obj.predY = mexGauss;

				obj.log_evidence = 0;                             % evidence is not computed!
        end

        function dims=dimensions(obj)
            %please fill: dims = [size_of_posterior size_of_data size_of_condition]
            dims = [size(A,1),size(C,1),0]   
        end
        function obj=bayes(obj,yt,ut)                       % approximate bayes rule
            % transform old estimate into new estimate
				
				%% <- in python you can use assignment:
				%% P=obj.apost_pdf.R !
				
            obj.predX.mu = obj.A*obj.apost_pdf.mu + obj.B*ut;
				obj.predX.R  = obj.A*obj.apost_pdf.R*obj.A' + obj.Q;

				%Data update
				obj.predY.R = obj.C*obj.predX.R*obj.C' + obj.R;
				iRy = inv(obj.predY.R);
				K = obj.predX.R*obj.C'*iRy; 
				obj.apost_pdf.R = obj.predX.R- K*obj.C*obj.predX.R; % P = P -KCP;
				obj.predY.mu = obj.C*obj.predX.mu + obj.D*ut;
				obj.apost_pdf.mu = obj.predX.mu + K*(yt-obj.predY.mu);
        end
    end

end