
/*!
\file
\brief Robust
\author Vasek Smidl 

 */

//<<<<<<< .mine
#include "robustlib.h"
#include "trading_models_lib.h"
#include <iostream> 
#include "estim/arx.h"

//=======
#include "trading_models_lib.h"
#include "estim/arx.h"
#include <vector>
#include <string>
#include <sstream>
#include <fstream>


//>>>>>>> .r1284
using namespace bdm;

double sumastlpec(int k,vector<vec> pole,vector<vec> pravd) {  
	double r=0;
	for (int i=0;i < pole.size();i++)
	{
		r+=pole[i][k+5]*pravd[i][k];
	}
	return r;
	}

int main () {
	//toto by bralo rozne subory, ale teraz to je zakomentovane, pouyivam len jeden
	char* outfile_strings[19] = {"prsti_CL_.txt", "prsti_HO_.txt", "prsti_HU_.txt", "prsti_NG_.txt", "prsti_AD_.txt", "prsti_BP_.txt", "prsti_CD_.txt", "prsti_CU_.txt", "prsti_SF_.txt", "prsti_BO_.txt", "prsti_C__.txt", "prsti_CT_.txt", "prsti_MW_.txt", "prsti_W__.txt", "prsti_GC_.txt", "prsti_HG_.txt", "prsti_PA_.txt", "prsti_PL_.txt", "prsti_SI_.txt"};
	char* file_strings[19] = {"c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\CL_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\HO_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\HU_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\NG_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\AD_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\BP_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\CD_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\CU_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\SF_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\BO_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\C__.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\CT_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\MW_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\W__.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\GC_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\HG_.txt", "c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\PA_.txt","c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\PL_.txt","c:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-MATHEMATIKA\\SI_.txt"};
	//for (int a=0;a<20;a++)
	//{
	int a=8; //volbou a menime pouzity subor
	vector<vector<string>> ADdata;     //nacitavanie dat do pola ADdata 
		ifstream myfile(file_strings[a]);				//"C:\\Users\\Peto\\Desktop\\PROG-BAK\\DATA-Mathematika\\CL_.txt");
		if (myfile.is_open())
		{
			while ( myfile.good() )
			{
				string line;
				getline(myfile,line);
				vector<string> parsed_line;				 
				while(line.find(' ') != string::npos) //jeden kanal je jeden riadok, na zaciatku a na konci {,}, data oddelene ciarkou a medzerou.
				{
					line.erase(0,1);   //toto nie je yrovna peknz sposob,ale pri poslednom nacitani cisla v riadku sme uz nemali ziadnu medyeru a cyklus by sa posledny krat nevykonal, tak tu medzeru odstranujeme vzdy tu
					int loc = line.find(',');   //ale pri poslednom cisla to nenajde ziadnu ciaarku, tak potom co prida do parsed_line?
					parsed_line.push_back(line.substr(0,loc));	
					line.erase(0,loc+1);				//odstranujeme ciarku za kazdym cislom
				}				
				ADdata.push_back(parsed_line); //3927 dat v riadku, 6 riadkov
			}
		}
		myfile.close();  //konec nacitavania dat
		
		vector<vec> norm; //do tychto  poli zapisujeme normalizacne faktory
		vector<vec> nfaktor;
		for (int h=1;h<=2;h++) //cyklus ktory ovplyvnuje konstantu h=1- model s konstantou, h=2, bez konstanty
		{ 
			bool b;			//b pouzivame pri set_constant
			if(h==2)
				b=false;   
			else
				b=true;
			int g=2;
			while (g<=4)  //cyklus co meni rozmery matice V
			{
				mat V0 = 0.0001*eye ( g );				
				int p=0;
				while (p<=1)  //tento cyklus prechadza vacsinou len raz, vtedy p=0 a nic to neovplvni, ale pri AR(2) modely to bude vykonavat 2 krat aj pre p=1, ked bude brat do condition aj rozne kanale z toho isteho casu 
				{
					int i=0;
					while(i < ADdata.size()-p) //niekedy sa ten cyklus ma vykonat len raz, preto nepouzivam for cyklus
					{	
						int j=p*(i+1); //j=0 alebo j=i+1
						while(j < ADdata.size())
						{
							ARX Ar;
							RARX Rar(g-1,0,b);
							Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
							Ar.set_constant ( b );
							Ar.validate();	// forgetting is default: 1.0
							vec pomocka1;  //pri kazdej jednej hypoteze zapisujeme normalizacne faktory do pomocky, tu potom ako riadok pridame do norm
							vec pomocka2; 
							for(int k = 0;k<6;k++) //prechadzame "po riadkoch", teda v case
							{
								vec condition;	
								vec predikce;
								predikce.ins(0,ADdata[3][k+2]);			//predpovede nacitavame a zadavame do Bayes zvlast
								condition.ins(0,ADdata[i][k+1]);				
								condition.ins(1,ADdata[j][k+p]);	//teraz su starsie data viac vpravo
								Ar.bayes(predikce,condition.right(g+h-3));	//z condition berem len urcity pocet prvkov, bud 0, 1,alebo 2, lebo nepotrebujem vzdy vsetky (AR(1) model)					
								condition.ins(0,predikce);
								if (g+h!=3) Rar.bayes(condition.left(g+h-2)); // podmienka brani aby sme nepouzivali robust pre AR(o) model len s konstantou
								//cout<< "Normalne rozdel" <<Ar.posterior().lognc();
								//cout << "Lapla normalizacny faktor" <<Rar.posterior->log_nc;
								pomocka1.ins(pomocka1.size(),Ar.posterior().lognc()); //nie je tu exponenciala! -aby to bolo mensie
								if (g+h!=3) pomocka2.ins(pomocka2.size(),exp(Rar.posterior->log_nc));								
							}  
							//pridame na zaciatok cisla, ktore urcuje y akeho modelu budu pravdepodobnosti
							pomocka1.ins(0,j+1);
							pomocka1.ins(0,i+1);
							pomocka1.ins(0,g);
							pomocka1.ins(0,h);
							pomocka1.ins(0,1); // jednotka na zaciatku znamena normalne rozdelenie
							pomocka2.ins(0,j+1);
							pomocka2.ins(0,i+1);
							pomocka2.ins(0,g);
							pomocka2.ins(0,h);
							pomocka2.ins(0,2); //2 bude ako Laplacovo
							norm.push_back(pomocka1);  
							if (g+h!=3) nfaktor.push_back(pomocka2);  //sem idu tie s Laplacovzm rozdelenim
							if ((g==3 && h==2) || (g==4))  //tento cyklus sa bude opakovat, len ak mame maticu V0 roymeru 4x4, to je AR(2) model s konst, alebo podobne len g=3, h=2, teda AR(2)bez kons
							{
								j++;
							} else
							{
								j=ADdata.size();	//priradenim tejto hodnoty do j sa cyklus uz viac krat nevykona
							}
						}
						if (b==true && g==2) //pre model AR(0) s konstantou robi tento cyklus len raz, v ostatnych pripadoch viac-krat
						{
							i=ADdata.size();
						} else
						{
							i++;
						}
					}
					if ((g==3 && h==2) || (g==4) )
					{p++;} else {p=2;}
				}
				if (h==2 && g==3) //pripad g=4, a konstanta zaroven nas uz nezaujima, vtedy to ukoncime
				{
					g=5; //ak priradime takuto hodnotu, cyklus while sa uz nevykona
				} else
				{
					g++;
				}
			}
		}
		//pocitanie maxima z kazdeho stlpcu norm
		vector<double> max;
		for (int i=5;i<norm[1].size();i++)  
		{
			double pom=norm[0][i];
			for (int j=1;j<norm.size();j++)
			{
				if (pom<norm[j][i])
				{
					pom=norm[j][i];
				}			
			}
			max.push_back(pom);
		}
		//v poli nfaktor uz mame zapisane normalizacne faktory pre Laplacovo rozdelenie, nie su take velke, preto nerobime odcitanie maxima
		// teraz odcitujeme od tych y normalnym rozdelenim maximum a pridame dalej do pola nfaktor
 			for (int i=0;i<norm.size();i++)
			{
				vec riadok;
				for (int j=0;j<5;j++)
				{
					riadok.ins(riadok.size(),norm[i][j]);	//toto pridava tie cisla na zaciatku, ktore urcuju o aky model sa jedna
				}
				for (int j=0;j<norm[i].size()-5;j++)
				{
					riadok.ins(riadok.size(),exp(norm[i][j+5]-max[j]));			
				}
				nfaktor.push_back(riadok); 
			}
			// nfaktor ma 229 riadkov, to je 229 hypotez
			vector<vec> prsti; 
			int m,n,p;
			for(p=0;p<229;p++) 
			{
				vec k;
				k.ins(0,1/229.);
				prsti.push_back(k);
			}
			// v ramci riadku v poli nfaktor su hodnoty pre jednu hypotezu v roznych casoch, pocitanie pravdepodobnosti z norm. faktorov
			for (m=0;m<nfaktor[2].size()-5;m++) 
			{	double k=sumastlpec(m,nfaktor,prsti);
				for(n=0;n < nfaktor.size();n++)
				{
					prsti[n].ins(prsti[n].size(),nfaktor[n][m+5]*prsti[n][m]/k);
				}
			}		
			ofstream file;	
			file.open(outfile_strings[a]);			//"prsti_hypot.txt",ios::app);
			for(int i=0;i < prsti.size();i++)
			{
				file << nfaktor[i][0] <<" "<<nfaktor[i][1]<<" "<<nfaktor[i][2]<<" "<<nfaktor[i][3]<<" "<<nfaktor[i][4]<<" ";
				for(int j=0;j < prsti[i].size();j++)
				{
					if(j!=prsti[i].size()-1)
					{
						file << prsti[i][j]<<" "; 
					}else
					{
						file<<prsti[i][j]<<endl; 
					}					
				}
			}
			file<<endl;
			file.close();
		//}	
	}


	