%> @file mexEpdf.m
%> @brief File mappring root class of epdf from BDM
% ======================================================================
%> @brief Abstract class of unconditional probability density function (epdf) 
%
%> This class provides a bridge between bdm::epdf and Matlab
% ======================================================================
classdef mexEpdf
    properties
	    %> Description of random variable (see definitiopn of RV)
	    rv=RV; 
    end
    methods
	     %> Function returning mean value of this epdf
        function m=mean(p)
            error('define how to compute mean')
        end
	     %> This function is called before using the object. It should check consistency of the properties and fill default values.
        function validate(p)
            error('check if the density is consistent')
        end
	     %> Tell the world around it dimension of the random variable
        function dim=dimension(p)
            error('return dimension of the density')
        end
	     %> Function returning variance of this epdf
        function v=variance(p)
            error('define how to compute mean')
        end
	     %> Function returning logarithm of likelihood function in point x
        function l=evallog(p,x)
            error('define how to evaluate log of this density at point x')
        end
	     %> Function returning a signle sample from this density
         function l=sample(p)
            error('define how to sample from this density')
        end
        
        %%% default functions -- no need to redefine %%%
        
	     %> Function returning logarithm of NON-normalized likelihood function in point x (speed optimization)
        function l=evallog_nn(p,x)
            % define how to evaluate non-normalized log of this density at point x
            % makes sense if faster than normalized
            l=evallog(p,x);
        end

		  function r=get_rv(p)
		  	r=p.rv;
          end
	     %> Function returning a matrix of n samples from this density, 
          function m = samplemat(obj, n)
              m = zeros(obj.dimension, n);
              for i=1:n
                  m(:,i) = obj.sample;
              end
          end
    end
end