#include "estim/arx.h"
using namespace bdm;

// estimation of AR(0) model
int main() {
    //prior
    mat V0 = 0.00001 * eye ( 3 );
    V0 ( 0, 0 ) = 0.1; //
    ARX Ar;
    Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
    Ar.set_constant ( false );
    Ar.validate();
    // forgetting is default: 1.0
    Ar.bayes_batch ( randn ( 1, 3400 ), randn(2,3400) );

    cout << "Expected value of Theta is: " << Ar.posterior().mean() << endl;
    cout << "NC of posterior: " << Ar.posterior().lognc() << endl;
}
