// Bayesian Filtering for PMSM using Marginalized Particle Filter 

#include "parametry_motoru.h"

#define N 20

#define Lsd Ls*1.1
#define Lsq Ls
#define _dt 0.000125
#define _ad Rs*_dt/Lsd
#define _aq Rs*_dt/Lsq
#define _b  Fmag/Lsq*_dt
#define _cd  _dt/Lsd
#define _cq  _dt/Lsq

double randn();
double randu();

void mpf_bayes ( const double &isa, const double &isb , const double &usa, const double &usb );
void mpf_init(double qom0, double qth0, double r0);
void mpf_mean(double Ecosth, double Esinth, double Eome);
void mpf_th(double th1[N]);
