#include "additive_generator.h"
#include "base/user_info.h"

using namespace itpp;
using bdm::UI;

void additive_generator::from_setting ( const Setting &set ) {
    int sz;
    UI::get ( sz, set, "size", UI::compulsory );

    mat a0 = randu ( sz, sz );
    a = a0 * a0.T();
    vec v = randu ( sz );
    v2 = outer_product ( v, v );

    UI::get ( lambda, set, "lambda", UI::optional );
}

mat additive_generator::next() {
    mat b = a;
    a = ( 1 - lambda ) * a + lambda * v2;
    return b;
}
