#include "arx.h"

using namespace itpp;

void ARX::bayes ( const vec &dt ) {
	double lnc;

	V.opupdt ( dt,frg );
	nu+=frg;

	if ( evalll ) {
		lnc = est.lognc();
		ll = lnc - last_lognc;
		last_lognc = lnc;
		tll +=ll;
	}
}

/*! \brief Return the best structure
@param Eg a copy of GiW density that is being examined
@param Eg0 a copy of prior GiW density before estimation
@param Egll likelihood of the current Eg
@param indeces current indeces
\return best likelihood in the structure below the given one
*/
double egiw_bestbelow ( egiw Eg, egiw Eg0, double Egll, ivec &indeces ) { //parameter Eg is a copy!
	ldmat Vo = Eg._V(); //copy
	ldmat Vo0 = Eg._V(); //copy
	ldmat& Vp = Eg._V(); // pointer into Eg
	ldmat& Vp0 = Eg._V(); // pointer into Eg
	int end = Vp.rows()-1;
	int i;
	mat Li;
	mat Li0;
	double maxll=Egll;
	double tmpll=Egll;
	double belll=Egll;

	ivec tmpindeces;
	ivec maxindeces=indeces;


cout << "bb:(" << indeces <<") ll=" << Egll <<endl;

	//try to remove only one rv
	for ( i=0;i<end;i++ ) {
		//copy original
		Li = Vo._L();
		Li0 = Vo0._L();
		//remove stuff
		Li.del_col ( i+1 );
		Li0.del_col ( i+1 );
		Vp.ldform ( Li,Vo._D() );
		Vp0.ldform ( Li0,Vo0._D() );
		tmpll = Eg.lognc()-Eg0.lognc(); // likelihood is difference of norm. coefs.

cout << "i=(" << i <<") ll=" << tmpll <<endl;
		
		//
		if ( tmpll > Egll ) { //increase of the likelihood
			tmpindeces = indeces;
			tmpindeces.del ( i );
			//search for a better match in this substructure
			belll=egiw_bestbelow ( Eg, Eg0, tmpll, tmpindeces );
			if ( belll>maxll ) { //better match found
				maxll = belll;
				maxindeces = tmpindeces;
			}
		}
	}
	indeces = maxindeces;
	return maxll;
}

ivec ARX::structure_est ( egiw est0 ) {
	ivec ind=linspace ( 1,rv.count()-1 );
	egiw_bestbelow ( est, est0, est.lognc()- est0.lognc(), ind );
	return ind;
}
