#pragma once

#include <cstdlib>
#include <itpp/itbase.h>
#include <iostream>
#include "SO.h"

using namespace std;
using namespace itpp;

class QueueData {
public:
	int var_len;
	string sep;
	string id;
	string idInput;
	bool dummy; // prijezdy jen z okolni site
	double queue;
	double input;
	double green;	
	Array<string> outputs;
	vec alphas;

	QueueData() {
		sep  = "##";
		id = "";
		idInput = "";		
		queue = 0;
		input = 0;	
		dummy = true;
	}

	double ss() {
		return 0.5;
	}

	string getMessageCode() {
		stringstream str;
		str << "QueueData" << sep << id << sep << idInput;
		for ( int i = 0; i < outputs.length(); i++ ) {
			str << sep << outputs(i);
		}
 		return str.str();
	}

	void fromMessageCode( string str ) {
		Array <string> data = SO::explode(str, sep);		
		id = data(1);
		idInput = data(2);
		outputs.set_length( data.length() - 3 );
		for ( int i = 3; i < data.length(); i ++ ) {
			outputs(i-3) = data(i);
		}
	}

	vec getVec() {
		vec out = zeros( 3 + alphas.length() );
		out(0) = queue;
		out(1) = input;
		out(2) = green;
		for ( int i = 0; i < alphas.length(); i++ ) {
			out(3+i) = alphas(i);
		}
		return out;
	}

	void fromVec( const vec & data ) {
		queue = data(0);
		input = data(1);
		green = data(2);
		if ( data.length() > 3 ) {
			alphas = zeros( data.length() - 3 );
			for ( int i = 3; i < data.length(); i ++ ) {
				alphas(i-3) = data(i);
			}
		}
		
	}
	
	string str() {
		stringstream str;
		str << "QueueData {" << endl;
		str << "\tid: " << id << endl;
		str << "\tidInput: " << idInput << endl;
		str << "\tqueue: " << queue << endl;
		str << "\tinput: " << input << endl;
		str << "\tgreen: " << green << endl;
		str << "\tdummy: " << dummy << endl;
		str << "\toutputs: " << outputs << endl;
		str << "\talphas: " << alphas << endl;
		str << "}" << endl;
		return str.str();
	}
};

