%> @file mexEpdf.m
%> @brief File mapping root class of BM from BDM
% ======================================================================
%> @brief Abstract class of Bayesian Model (estimator), bdm::BM
%
%> This class provides a bridge between bdm::BM and Matlab
% ======================================================================
classdef mexBM
    properties
        %> description of internal variables of parameters
        rv=RV
        %> description of internal variables of data in condition
        rvc=RV
        %> description of internal variables of observed data
        rvy=RV
        %> log of evidence (marginal likelihood) potentially computed by the
        % bayes rule for one step
        log_evidence
        %> posterior density - offspring of mexEpdf!
        apost_pdf
        %
    end

    methods
        %> check consistency of the object and fill defaults
        function p=validate(p)
            % checks if all paramateres match
        end
        %> dimensionality of the class: dims = [size_of_posterior size_of_data size_of_condition]
        function dims=dimensions(p)
            %please fill
            %dims = [size_of_posterior size_of_data size_of_condition]
            dims = [0,0,0] %
        end
        %> Performs Bayesian update of the internal posterior using data \a dt and condition \a cond.
        function obj=bayes(obj,dt,cond)
            % transform old estimate into new estimate
        end
        %> Computes predictor of the observed data in the next step
        function p=epredictor(obj,cond)
            % return posterior density
        end

        %%%%%%%% default functions %%%%%%%%%%%%%%
        function r = get_rv(obj)
            r=obj.rv;
        end
        function r = get_rvc(obj)
            r=obj.rvc;
        end
        function r = get_rvy(obj)
            r=obj.rvy;
        end
        %> Evidence of the last data, \f[f(y_t|y_0\ldots y_t-1, cond_0\ldots cond_t\f]
        function ev = logevidence(obj)
            ev = obj.log_evidence;
        end
        %> Posterior pdf
        function post=posterior(obj);
            post = obj.apost_pdf;
        end
    end
end