//
// C++ Implementation: itpp_ext
//
// Description:
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "userinfo.h"

XercesConnector::XercesConnector()
{
	// initialize the XML library
	XMLPlatformUtils::Initialize();

	// get a serializer, an instance of DOMWriter (the "LS" stands for load-save).
	pImplementation = DOMImplementationRegistry::getDOMImplementation( XMLString::transcode( "LS" ));

	pSerializer = ( (DOMImplementationLS*)pImplementation )->createDOMWriter();
	// set user specified end of line sequence and output encoding
	pSerializer->setNewLine( XMLString::transcode( "\n" ) );
	// optionally, set the format-pretty-print feature
	if (pSerializer->canSetFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true))
		pSerializer->setFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true);
}

XercesConnector::~XercesConnector()
{
	delete pSerializer;

	// terminate the XML library
	XMLPlatformUtils::Terminate();
}

string XercesConnector::XMLCh2str( const XMLCh* const  XMLCh_str )
{
	char *local = XMLString::transcode( XMLCh_str );
	string res = local;		
	XMLString::release( &local );
	return res;
}

bool XercesConnector::Comparator::operator()( const XMLCh* const a , const XMLCh* const b) const
{
	return ( XMLString::compareString(a,b) > 0);
}	

