#ifndef UI_H
#define UI_H

#include <sstream>
#include <iostream>
#include <stdio.h>
#include <string>
#include <typeinfo>
#include <map>
#include <utility>
#include <vector>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <iostream>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/framework/LocalFileInputSource.hpp>
#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>

#ifdef XERCES_CPP_NAMESPACE_USE
XERCES_CPP_NAMESPACE_USE
#endif

using std::string;
using namespace std;

/*!
@brief Xerces interface class

This class is used to interact with the Xerces library.
*/
class XercesConnector
{
public:
	//! DOMImplementation is a base class for the all DOM oparations
	DOMImplementation *pImplementation;
	//! This DOMWriter is used to export internal data into xml files
	DOMWriter *pSerializer;

private:
	//!default constructor
	XercesConnector();
	//!destructor
	~XercesConnector();
	//!forbidden copy constructor
	XercesConnector( XercesConnector& ref );
public:

	DOMDocument* Parse( const LocalFileInputSource & inputSource )
	{
		//! This DOMWriter is used to import external data from xml files
		XercesDOMParser parser;

		parser.setValidationScheme(XercesDOMParser::Val_Auto);
		parser.setDoNamespaces(false);
		parser.setDoSchema(false);

		parser.parse( inputSource );
		if( parser.getErrorCount() )
			return NULL;
		
		return parser.adoptDocument();	
	}


	//! function transcodes Xerces' XMLCh-based strings into C++ strings
	string XMLCh2str( const XMLCh* const  XMLCh_str );

	class Comparator
	{
	public:
		//! operator compares two XMLCh strings and wheather the first is alphabethically higher
		bool operator()( const XMLCh* const a , const XMLCh* const b) const;
	};

	//! The only global instance of the XercesConnector class
	// potrebujeme inicializaci hned v okamziku zavolani!!
	static XercesConnector& instance()
	{
		static XercesConnector gxc;
		return gxc;
	};
};

class BindingFrame
{
public:
	// nacpe na prislusne pointery, kdyztak da NULL
	virtual void AssemblyBindedData( DOMElement &element ) = 0;

	// uvolneni pameti po slozeni objektu, tj. lze jedine po AssemblyBD
	virtual void ReleaseUsedMemory() = 0;

	// vrati bool, pokud se povedlo rozebrat a naplnit element
	// nebude tu nahodou jeste ten help - string??
	virtual bool DisassemblyBindedData( DOMElement &element ) = 0;		
};


/*!
@brief UserInfo class is for internal purposes only. Use CompoundUserInfo<T> instead.

The raison d'etre of this class is to allow pointers to (the main part of) 
CompoundUserInfo<T> objects even for different generic types.
*/

class UserInfo : public BindingFrame
{
private:
	//! Type definition of mapping which transforms type names to the related user infors
	typedef map< const string, UserInfo*> MappedName2UI;
	
	//! Mapped 
	static MappedName2UI& mappedName2UI()
	{
		static MappedName2UI var;
		return var;
	}

	const string underlyingTypeName;

public:

	//! The only constructor which fills both the transcodedTypeName and the help attribute
	UserInfo( const string& underlyingTypeName )
		: underlyingTypeName ( underlyingTypeName )
	{	
		// trik, chci jen to, aby se inicializoval!!
		XercesConnector::instance();

		cout << underlyingTypeName;

		mappedName2UI().insert( make_pair( underlyingTypeName, this ) );
	}

	~UserInfo()
	{		
	}

public:
	
	virtual void BuildInternal(void* &pInstance) = 0;

	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	// NULL if error..
	template<class T>
	static void Assembly( const string tagName, DOMElement &element, T* &pInstance  )
	{	
		pInstance = NULL;

		XMLCh* transcodedTagName = XMLString::transcode( tagName.c_str() );		
		XMLString::upperCase( transcodedTagName );

/*/////////////////////////
		DOMNodeList* nodeListe = element.getChildNodes();
		if( nodeListe )
			for( int i = 0; i < nodeListe->getLength(); i++ )
			{
				DOMNode* node = nodeListe->item(i);
				if( node->getNodeType() == DOMNode::ELEMENT_NODE )
				{
					DOMElement* childElement = (DOMElement*) node;
					cout << XercesConnector::instance().XMLCh2str( childElement->getTagName() );
				}
			}
		getchar();

*/////////////////////////////


		DOMNodeList* const nodeList = element.getElementsByTagName( transcodedTagName );
		XMLString::release( (XMLCh**)&transcodedTagName );

		if( nodeList != NULL && nodeList->getLength() != 1 )
			return;

		// TAKZE MAME V RUCE ELEMENT SE JMENEM "tagName"
		DOMElement* childElement = (DOMElement*) nodeList->item(0);

		// COZ O TO, UDELAL BYCH TO STATICKOU KONSTANTOU, ALE JAK JI PAK SMAZU??
		XMLCh* transcodedTypeAttributeName = XMLString::transcode("type");
		const XMLCh* const transcodedType = childElement->getAttribute( transcodedTypeAttributeName );
		XMLString::release( (XMLCh**)&transcodedTypeAttributeName );

		if( !XMLString::stringLen( transcodedType ) )
			return;

		// TED MAME V RUCE JMENO TYPU Z ATRIBUTU TYPE
		string type = XercesConnector::instance().XMLCh2str( transcodedType );

		MappedName2UI::const_iterator iter = mappedName2UI().find( type  );
		if( iter == mappedName2UI().end())
			return;

		// A TED PRISLUSNE UI
		UserInfo *relatedUI = iter->second;
		relatedUI->AssemblyBindedData( *childElement );		
		relatedUI->BuildInternal( (void*&)pInstance );
		relatedUI->ReleaseUsedMemory();

		if( pInstance == NULL )
			return;

		try
		{
			// takhle to zkontroluju? name musi byt shodne s name nahore!!
			// takze mame typ T, ale name bud od jeho potomka.. oki??
			string resultingType = typeid( *pInstance ).name();
			if( resultingType != type )
			{
				cout << "FATAL ERROR!!" << endl;
				pInstance = NULL;
			}			
		}
		catch(...)
		{
			// delete? ale jak na to? asi tezko
			pInstance = NULL;
		}		
		return;
	}	

	// ? pri destrukci si za ne naopak zodpovida ten, kdo je vytvoril.. protoze 
	// budou zit v tom objektu!! tak jakapak destrkuce..
};


template<typename T> class TypedUserInfo : public UserInfo
{
protected:

	//! The only constructor which fills 
	TypedUserInfo<T>( ) 
		: UserInfo( typeid(T).name() ) 
	{	
	};

	//! Destructor
	~TypedUserInfo<T>()
	{
	}

public:
	// FRIEND radeji
	void BuildInternal(void* &pInstance)
	{
		T* &pTypedInstance = (T*&) pInstance;
		Build( pTypedInstance );
	}

	virtual void Build(T* &pTypedInstance) = 0;

	static const TypedUserInfo<T> &instance;
};



/*!
@brief The main user info template class

You should derive this class whenever you need new CompoundUserInfo.
*/
template<typename T> class CompoundUserInfo : public TypedUserInfo<T>
{
private:
	//! Mapped elements, i.e., descendant html tags
	vector<BindingFrame* const> bindedElements;

protected:
	template<typename U> class BindedType: public BindingFrame
	{
	private:
		const TypedUserInfo<U> &factory;
		string name;
		string help;

	public:
		U* pInstance;

		BindedType<U>( CompoundUserInfo<T> *parent, string name, string help ) 
			: name( name), help(help)
			factory( TypedUserInfo<U>::instance )		
		{
			parent->bindedElements.push_back( this );
			pInstance = NULL;
		}

		BindedType<U>( CompoundUserInfo<T> *parent, string name ) 
			: name( name), help(""),
			factory( TypedUserInfo<U>::instance )		
		{
			parent->bindedElements.push_back( this );
			pInstance = NULL;
		}

		void AssemblyBindedData( DOMElement &element )
		{
			factory.Assembly( pInstance, element, name );
		}

		void ReleaseUsedMemory()
		{
			if( pInstance != NULL )
				delete pInstance;
		}

		bool DisassemblyBindedData( DOMElement &element )
		{
	//		return factory.Disassembly( (void*&) pInstance, element, name, help );
			return true;
		}
	};


public:

	void AssemblyBindedData( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->AssemblyBindedData( element );
	}

	void ReleaseUsedMemory()
	{			
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->ReleaseUsedMemory();
	}

	bool DisassemblyBindedData( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			if( !bindedElements[ind]->DisassemblyBindedData( element ) )
				return false;
		return true;
	}
};


	/*	
	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	bool Disassembly(void * &pInstance, DOMElement &element, string name, char * help = "" )
	{
		T* &pTypedInstance = (T*&) pInstance;
		// do elementu prida vetev se jmenem name a vyplni obsahujici data z instance
		// zde nemuze vzniknout zadna chyba, ponevadz XML vytvarime 

/*
		for( MappedElements::const_iterator iter = elements.begin(); iter != elements.end(); iter++)
		{
			iter->second->AppendElement( *pHead );
				{
		DOMDocument* pDoc = element.getOwnerDocument();

		DOMElement* pHead = pDoc->createElement( transcodedTypeName );		
		element.appendChild( pHead );

		FillElement( pHead );
}
			}

		for( MappedAttributes::iterator iter = attributes.begin(); iter != attributes.end(); iter++)
		{
			// we do not create attributes, which are empty
			if( !strcmp( iter->second->c_str(), "") )
				continue;

			DOMDocument* pDoc = pHead->getOwnerDocument();
			DOMAttr* pAttribute = pDoc->createAttribute( iter->first );

			XMLCh* transcodedValue = XMLString::transcode( iter->second->c_str() ); 
			pAttribute->setValue( transcodedValue );
			XMLString::release( &transcodedValue );

			pHead->setAttributeNode(pAttribute);			
		}
		return true;
	}
*/


template<typename T> class ValuedUserInfo : public TypedUserInfo<T>
{

private:
	const XMLCh* const transcodedValueName;

public:
	// Value nemusi byt pointer, na rozdil od ostatnich binding framu..
	string value;

	ValuedUserInfo<T>()
		: transcodedValueName( XMLString::transcode( "value" ))
	{
	}

	~ValuedUserInfo<T>()
	{
		XMLString::release( (XMLCh**)&transcodedValueName );
	}

	void AssemblyBindedData( DOMElement &element )
	{		
		const XMLCh* const transcodedValue = element.getAttribute( transcodedValueName );
		value = XercesConnector::instance().XMLCh2str( transcodedValue );
	}

	void ReleaseUsedMemory()
	{			
	}

	bool DisassemblyBindedData( DOMElement &element )
	{
//		if( value.length()==0 )
//			return false;
		return true;
	}
};


class RootElement 
{
// umi se pretypovat na DOMElement &element	
// a to vzdy, save a load se muze udelat az pak!!

private:
	DOMElement * pRoot;
	DOMDocument* pDoc;

	const XMLCh* const transcodedFileName ;

public:

	RootElement( char* fileName )
		: transcodedFileName( XMLString::transcode( fileName ) )
	{		
		pDoc = XercesConnector::instance().pImplementation->createDocument( 
			XMLString::transcode( "M3K USER INFO" ), 
			XMLString::transcode( "ROOT" ), NULL );
		pRoot = pDoc->getDocumentElement();
	}

	~RootElement()
	{
		XMLString::release( (XMLCh**)&transcodedFileName );
		if( pDoc ) 
			delete pDoc;		
	}

	//! loads root element from a file
	bool Load( void ) 
	{
		const LocalFileInputSource inputSource( transcodedFileName );		
		DOMDocument * newDoc = XercesConnector::instance().Parse( inputSource );
		if( newDoc == NULL )					
			return false;

		if( pDoc ) 
			delete pDoc;		

		pDoc = newDoc;			
		pRoot = pDoc->getDocumentElement();
		return true;		
	}


	//! Save UserInfo to the file (typically with an XML extension)
	void Save ( void )
	{
		LocalFileFormatTarget outputTarget( transcodedFileName );	
		XercesConnector::instance().pSerializer->writeNode( &outputTarget, *pDoc);
	}	

	operator DOMElement&()
	{
		return *pRoot;
	}
};


#endif // #ifndef UI_H