%simulator PMSM for PCRB, choice: Ls/Ldq & correct/incorrect expectation
clear all;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%   settings
    % ON/OFF  MODEL    IS CORR. E   INDUCT. L
model1 = 1; % alpha-beta    nE      Ls
model2 = 1; % d-q           nE      Ls
model3 = 1; % 5sc           nE      Ls

model4 = 1; % alpha-beta    E       Ls
model5 = 1; % d-q           E       Ls
model6 = 1; % 5sc           E       Ls

model7 = 1; % alpha-beta    nE      Ldq
model8 = 1; % d-q           nE      Ldq
model9 = 1; % 5sc           nE      Ldq

model10 = 1; % alpha-beta   E       Ldq
model11 = 1; % d-q          E       Ldq
model12 = 1; % 5sc          E       Ldq

    % CONTROL
    % 1 -   ome = ref_ome, the = integral(ome), ial = ibe = 0
    % 2 -   PI control    
    % 3 -   PI + injection (sin -> dq)
    % 4 -   PI + injection (rect. -> dq)
    % 5 -   PI + injection (const. -> ud) *J4 ~ 3e-6 for all exc. dq
    % 6 -   PI + rnd error (ref_ome) *J4: dq bad; ab,5sc Ls ~ 4e-4; ab,5sc Ldq ~5e-6  
    % 7 -   PI + injection (sin -> al-be)
    % 8 -   PI + injection (rect. -> al-be)
    % 9 -   PI + bicrit. (sign) *J4 ~ 1e-3 for all exc. dq
    % 10 -  PI + rnd bicrit. selection (5)    
control = 9;
    % param. amp*phi(injom*dt*t) //phi = sin,cos,sign(sin),sing(cos)
amp = 10.0;
injom = 500;

    %cov Q, R matrices
%         %noise
% Q = diag([0.0013 0.0013 5.0e-6 1.0e-10]);
% R = diag([0.0006 0.0006]);
%         %EKF
% Q = diag([0.1 0.1 0.1 0.001]);
% R = diag([0.05 0.05]);
        %test
Q = diag([0.1 0.1 0.1 1]);
R = diag([0.05 0.05]);

    % plot system variables
plotsys = 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%constants

%   machine parameters
Rs = 0.28;
Ls = 0.003465;
psipm = 0.1989;
B = 0;
TL = 0;
kp = 1.5;
pp = 4.0;
J = 0.04;

dt = 0.000125;

Lq = 1.0*Ls;
Ld = 0.9*Ls;

%aliases
kpp = kp*pp*pp;
kppj = kpp/J;
psi = psipm;

a = 0.9898;
b = 0.0072;
c = 0.0361;
d = 1.0;
e = 0.0149;

%horizont
T = 120000; 

%reference signal
ref_ome = zeros(1, T); 
% ref_profile = [1, 10, 50, 200, 200, 30, 0, 0, -1, -10, -50, -200, -200, -30, 0];
ref_profile = [0, -1, 3, 6, 9, 6, 3, 0, 0, 0, 0, 0,0,-3, -6, -3];
% ref_profile = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
% ref_profile = ones(1,16);

for k = 1:T,
       index = floor(k*dt);
       if(index>0)
           lower = ref_profile(index);
       else
           lower = 0;
       end
       if(index<T*dt)
           upper = ref_profile(index+1);
       else
           upper = 0;
       end
       ref_ome(k) = lower + (upper-lower)*dt*(k-index/dt);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   system variables

%system state and control
x_sys = zeros(4, T); 
u_ab = zeros(2, T); 
u_dq = zeros(2, T);

%covariance alternatives
Q4 = Q;
Q5 = zeros(5);
Q5(1:4,1:4) = Q;
Q5(5,5) = Q(4,4);
q1 = Q4(1,1);
q2 = Q4(2,2);
q3 = Q4(3,3);
q4 = Q4(4,4);
q5 = Q5(5,5);
iQ4 = inv(Q4);
iQ5 = inv(Q5);
iR = inv(R);
e05q4 = exp(-1/2*q4);
e2q4 = exp(-2*q4);
e92q4 = exp(-9/2*q4);
e4q4 = exp(4*q4);
e8q4 = exp(-8*q4);
e6q4 = exp(6*q4);

%PCRB J matrices
iJn1 = zeros(4,4,T);
iJn2 = zeros(4,4,T);
iJn3 = zeros(5,5,T);
iJn4 = zeros(4,4,T);
iJn5 = zeros(4,4,T);
iJn6 = zeros(5,5,T);
iJn7 = zeros(4,4,T);
iJn8 = zeros(4,4,T);
iJn9 = zeros(5,5,T);
iJn10 = zeros(4,4,T);
iJn11 = zeros(4,4,T);
iJn12 = zeros(5,5,T);
Jj1 = inv(Q4);
Jj2 = inv(Q4);
Jj3 = inv(Q5);
Jj4 = inv(Q4);
Jj5 = inv(Q4);
Jj6 = inv(Q5);
Jj7 = inv(Q4);
Jj8 = inv(Q4);
Jj9 = inv(Q5);
Jj10 = inv(Q4);
Jj11 = inv(Q4);
Jj12 = inv(Q5);

%PI control
sum_iq = 0;
sum_ud = 0;
sum_uq = 0;
kon_pi = 30.0;
kon_ii = 0.0;
kon_pu = 20.0;
kon_iu = 0.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   init

% measurement function derivatives
C4 = zeros(2,4);
C4(1,1) = 1.0;
C4(2,2) = 1.0;

C5 = zeros(2,5);
C5(1,1) = 1.0;
C5(2,2) = 1.0;

% system function derivatives
    %alpha-beta, equal Ls
A14 = zeros(4);
A14(1,1) = a;
A14(2,2) = a;
A14(3,3) = d;
A14(4,3) = dt;
A14(4,4) = 1.0;
A4 = zeros(4);
    %d-q, equal Ls
A25 = zeros(4);
A25(1,1) = a;
A25(2,2) = a;
A25(2,3) = -b;
A25(3,2) = e;
A25(3,3) = d;
A25(4,3) = dt;
A25(4,4) = 1.0;
    %5sc, equal Ls
A36 = zeros(5);
A36(1,1) = a;
A36(2,2) = a;
A36(3,3) = d;
A36(4,4) = 1.0;
A36(5,5) = 1.0;
    %alpha-beta, Ldq
A70 = zeros(4);
% A70(4,4) = 1.0;
% A70(5,5) = 1.0;
    %d-q, Ldq
A81 = zeros(4);
A81(1,1) = 1.0 - Rs*dt/Ld;
A81(2,2) = 1.0 - Rs*dt/Lq;
A81(3,3) = 1-B*dt/J;
A81(4,3) = dt;
A81(4,4) = 1.0;
    %5sc, Ldq
A92 = zeros(5);
A92(4,4) = 1.0;
A92(5,5) = 1.0;


%expectation corrections
    %cor. 2 -> 5
D11_cor5 = diag([dt^2*q3/q2, dt^2*q3/q1, dt^2*q1/q2 + dt^2*q2/q1, 0.0]);
    %cor. 3 -> 6
D11_cor6 = diag([e^2*q4/q3,...
                e^2*q5/q3,...
                b^2*q5/q2 + dt^2*q5/q4 + b^2*q4/q1 + dt^2*q4/q5,...
                e^2*q1/q3 + b^2*q3/q1 + dt^2*q3/q5,...
                e^2*q2/q3 + b^2*q3/q2 + dt^2*q3/q4]);
    %cor. 8 -> 11
D11_cor11 = diag([Ld^2/Lq^2*dt^2*q3/q2 + dt^2*kp^2*pp^4*(Ld-Lq)^2*q2/J^2/q3,...
                  Lq^2/Ld^2*dt^2*q3/q1 + dt^2*kp^2*pp^4*(Ld-Lq)^2*q1/J^2/q3,...
                  Lq^2/Ld^2*dt^2*q2/q1 + Ld^2/Lq^2*dt^2*q1/q2, 0.0]);

% new figure              
figure;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   main loop

for t = 1:T-1,
    %aliases
    ial = x_sys(1, t);
    ibe = x_sys(2, t);
    ome = x_sys(3, t);
    the = x_sys(4, t); 
    
    ia = ial;
    ib = ibe;
    
    st = sin(the);
    ct = cos(the);
    
    id = ial*cos(the) + ibe*sin(the);
    iq = ibe*cos(the) - ial*sin(the);
    
    hia	= ial;
    hib	= ibe;
    hom	= ome;
    sht	= sin(the);
    cht	= cos(the);
    sh2t = sin(2*the);
    ch2t = cos(2*the);
    sh3t = sin(3*the);
    ch3t = cos(3*the);
    ch4t = cos(4*the);    
    
    %PCRB models
    if(model1 == 1) %al-be/nE/Ls
        A14(1,3) = b*sin(the);
        A14(1,4) = b*ome*cos(the);
        A14(2,3) = -b*cos(the);
        A14(2,4) = b*ome*sin(the);
        A14(3,1) = -e*sin(the);
        A14(3,2) = e*cos(the);
        A14(3,4) = -e*(ial*cos(the)+ibe*sin(the));

        D11 = A14'*iQ4*A14;
        D12 = -A14'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;

        Jj1 = D22 - D21/(Jj1 + D11)*D12;
        iJn1(:,:,t) = inv(Jj1);        
    end
    if(model2 == 1) %d-q/nE/Ls
        A25(1,2) = dt*ome;
        A25(1,3) = dt*iq;
        A25(2,1) = -dt*ome;
        A25(2,3) = -dt*id-b;
       
        D11 = A25'*iQ4*A25;
        D12 = -A25'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;    

        Jj2 = D22 - D21/(Jj2 + D11)*D12;
        iJn2(:,:,t) = inv(Jj2);
    end
    if(model3 == 1) %5sc/nE/Ls
        A36(1,3) = b*sin(the);
        A36(1,4) = b*ome;
        A36(2,3) = -b*cos(the);
        A36(2,5) = -b*ome;
        A36(3,1) = -e*sin(the);
        A36(3,2) = e*cos(the);
        A36(3,4) = -e*ial;
        A36(3,5) = e*ibe;
        A36(4,3) = dt*cos(the);
        A36(4,5) = dt*ome;
        A36(5,3) = -dt*sin(the);
        A36(5,4) = -dt*ome;

        D11 = A36'*iQ5*A36;    
        D12 = -A36'*iQ5;
        D21 = D12';
        D22 = iQ5 + C5'*iR*C5;

        Jj3 = D22 - D21/(Jj3 + D11)*D12;
        iJn3(:,:,t) = inv(Jj3);
    end
    if(model4 == 1) %al-be/E/Ls
        D11 = zeros(4);
        D11(1, 1) = a^2/q1 + e^2/q3*(1/2 - 1/2*exp(-2*q4)*cos(2*the));
        D11(1, 2) = -e^2/q3*sin(the)*cos(the)*exp(-2*q4);
        D11(1, 3) = (a*b/q1 - d*e/q3)*sin(the)*exp(-1/2*q4);
        D11(1, 4) = e^2/q3*(ial*sin(the)*cos(the)*exp(-2*q4) + ibe*(1/2 - 1/2*exp(-2*q4)*cos(2*the)))...
                    + a*b/q1*ome*cos(the)*exp(-1/2*q4);
        D11(2, 1) = D11(1, 2);
        D11(2, 2) = a^2/q2 + e^2/q3*(1/2 + 1/2*exp(-2*q4)*cos(2*the));
        D11(2, 3) = (d*e/q3 - a*b/q2)*cos(the)*exp(-1/2*q4);
        D11(2, 4) = a*b/q2*ome*sin(the)*exp(-1/2*q4)...
                    - e^2/q3*(ial*(1/2 + 1/2*exp(-2*q4)*cos(2*the)) + ibe*sin(the)*cos(the)*exp(-2*q4));
        D11(3, 1) = D11(1, 3);
        D11(3, 2) = D11(2, 3);
        D11(3, 3) = d^2/q3 + dt^2/q4 + b^2/q2*(1/2 + 1/2*exp(-2*q4)*cos(2*the))...
                    + b^2/q1*(1/2 - 1/2*exp(-2*q4)*cos(2*the));
        D11(3, 4) = dt/q4 - d*e/q3*(ial*cos(the)*exp(-1/2*q4) + ibe*sin(the)*exp(-1/2*q4))...
                    + b^2/q1*ome*sin(the)*cos(the)*exp(-2*q4) - b^2/q2*ome*sin(the)*cos(the)*exp(-2*q4);
        D11(4, 1) = D11(1, 4);
        D11(4, 2) = D11(2, 4);
        D11(4, 3) = D11(3, 4);
        D11(4, 4) = 1/q4 + e^2/q3*((q1 + ial^2)*(1/2 + 1/2*exp(-2*q4)*cos(2*the))...
                    + 2*ial*ibe*sin(the)*cos(the)*exp(-2*q4)...
                    + (q2 + ibe^2)*(1/2 - 1/2*exp(-2*q4)*cos(2*the)))...
                    + b^2/q2*(q3 + ome^2)*(1/2 - 1/2*exp(-2*q4)*cos(2*the))...
                    + b^2/q1*(q3 + ome^2)*(1/2 + 1/2*exp(-2*q4)*cos(2*the));

        A4(1,1) = a;
        A4(1,2) = 0.0;
        A4(1,3) = b*sin(the)*exp(-1/2*q4);
        A4(1,4) = b*ome*cos(the)*exp(-1/2*q4);
        A4(2,1) = 0.0;
        A4(2,2) = a;
        A4(2,3) = -b*cos(the)*exp(-1/2*q4);
        A4(2,4) = b*ome*sin(the)*exp(-1/2*q4);
        A4(3,1) = -e*sin(the)*exp(-1/2*q4);
        A4(3,2) = e*cos(the)*exp(-1/2*q4);
        A4(3,3) = d;
        A4(3,4) = -e*(ial*cos(the)*exp(-1/2*q4) + ibe*sin(the)*exp(-1/2*q4));
        A4(4,1) = 0.0;
        A4(4,2) = 0.0;
        A4(4,3) = dt;
        A4(4,4) = 1.0;

        D12 = -A4'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;

        Jj4 = D22 - D21/(Jj4 + D11)*D12;
        iJn4(:,:,t) = inv(Jj4);
    end
    if(model5 == 1) %d-q/E/Ls
        A25(1,2) = dt*ome;
        A25(1,3) = dt*iq;
        A25(2,1) = -dt*ome;
        A25(2,3) = -dt*id-b;
       
        D11 = A25'*iQ4*A25 + D11_cor5;
        D12 = -A25'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;    

        Jj5 = D22 - D21/(Jj5 + D11)*D12;
        iJn5(:,:,t) = inv(Jj5);
    end
    if(model6 == 1) %5sc/E/Ls
        A36(1,3) = b*sin(the);
        A36(1,4) = b*ome;
        A36(2,3) = -b*cos(the);
        A36(2,5) = -b*ome;
        A36(3,1) = -e*sin(the);
        A36(3,2) = e*cos(the);
        A36(3,4) = -e*ial;
        A36(3,5) = e*ibe;
        A36(4,3) = dt*cos(the);
        A36(4,5) = dt*ome;
        A36(5,3) = -dt*sin(the);
        A36(5,4) = -dt*ome;

        D11 = A36'*iQ5*A36 + D11_cor6;    
        D12 = -A36'*iQ5;
        D21 = D12';
        D22 = iQ5 + C5'*iR*C5;

        Jj6 = D22 - D21/(Jj6 + D11)*D12;
        iJn6(:,:,t) = inv(Jj6);
    end
    if(model7 == 1) %al-be/nE/Ldq        
        A70 = [[ (Lq - Rs*dt*sin(the)^2)/Lq - (dt*ome*sin(the)*Lq^2*cos(the) + Rs*dt*Lq*cos(the)^2)/(Ld*Lq) + (Ld*dt*ome*cos(the)*sin(the))/Lq,                                       (dt*(Ld - Lq)*(- Lq*ome*cos(the)^2 + Rs*cos(the)*sin(the) + Ld*ome*sin(the)^2))/(Ld*Lq),    dt*cos(the)*(ia*sin(the) - ib*cos(the) + (Lq*(ib*cos(the) - ia*sin(the)))/Ld) + dt*sin(the)*(psi/Lq - ia*cos(the) - ib*sin(the) + (Ld*(ia*cos(the) + ib*sin(the)))/Lq),                                               (dt*(ome*psi*cos(the) + Rs*ib*cos(2*the) - Rs*ia*sin(2*the)))/Lq + (Ld*dt*(ia*ome*cos(2*the) + ib*ome*sin(2*the)))/Lq - (dt*(Lq^2*ia*ome*cos(2*the) + Lq^2*ib*ome*sin(2*the) + Lq*Rs*ib*cos(2*the) - Lq*Rs*ia*sin(2*the)))/(Ld*Lq)];...
                [                                       (dt*(Ld - Lq)*(- Ld*ome*cos(the)^2 + Rs*cos(the)*sin(the) + Lq*ome*sin(the)^2))/(Ld*Lq), (Lq - Rs*dt*cos(the)^2)/Lq - (Lq*Rs*dt*sin(the)^2 - Lq^2*dt*ome*cos(the)*sin(the))/(Ld*Lq) - (Ld*dt*ome*cos(the)*sin(the))/Lq, (dt*(Lq*ia - psi*cos(the)))/Lq + (dt*((Lq^2*ia*cos(2*the))/2 - (Lq^2*ia)/2 + (Lq^2*ib*sin(2*the))/2))/(Ld*Lq) - (Ld*dt*(ia/2 + (ia*cos(2*the))/2 + (ib*sin(2*the))/2))/Lq, (dt*ome*psi*sin(the) - Rs*dt*ia*(2*sin(the)^2 - 1) + Rs*dt*ib*sin(2*the))/Lq + (Ld*(dt*ib*ome*(2*sin(the)^2 - 1) + dt*ia*ome*sin(2*the)))/Lq - (Lq*Rs*dt*ib*sin(2*the) + Lq^2*dt*ib*ome*(2*sin(the)^2 - 1) + Lq^2*dt*ia*ome*sin(2*the) - Lq*Rs*dt*ia*(2*sin(the)^2 - 1))/(Ld*Lq)];...
                [     -dt*kppj*(psi*sin(the) - cos(the)*(Ld - Lq)*(ib*cos(the) - ia*sin(the)) + sin(the)*(Ld - Lq)*(ia*cos(the) + ib*sin(the))),      dt*kppj*(psi*cos(the) + cos(the)*(Ld - Lq)*(ia*cos(the) + ib*sin(the)) + sin(the)*(Ld - Lq)*(ib*cos(the) - ia*sin(the))),                                                                                                                                                                         1.0,                                                                                                                                                   -dt*kppj*(psi*(ia*cos(the) + ib*sin(the)) + (Ld - Lq)*(ia*cos(the) + ib*sin(the))^2 - (Ld - Lq)*(ib*cos(the) - ia*sin(the))^2)];...
                [                                                                                                                             0.0,                                                                                                                             0.0,                                                                                                                                                                        dt,                                                                                                                                                                                                                                                                                1.0]];
        
        D11 = A70'*iQ4*A70;
        D12 = -A70'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;

        Jj7 = D22 - D21/(Jj7 + D11)*D12;
        iJn7(:,:,t) = inv(Jj7);        
    end
    if(model8 == 1) %d-q/nE/Ldq
        A81(1,2) = Lq*dt/Ld*ome;
        A81(1,3) = Lq*dt/Ld*iq;
        A81(2,1) = -Ld*dt/Lq*ome;
        A81(2,3) = -Ld*dt/Lq*id-psipm*dt/Lq;
        A81(3,1) = kp*pp*pp*dt*(Ld-Lq)/J*iq;
        A81(3,2) = kp*pp*pp*dt/J*((Ld-Lq)*id+psipm);    
        
        D11 = A81'*iQ4*A81;
        D12 = -A81'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;
    
        Jj8 = D22 - D21/(Jj8 + D11)*D12;
        iJn8(:,:,t) = inv(Jj8);
    end
    if(model9 == 1) %5sc/nE/Ldq        
        A92(1, 1) = 1.0 + dt*(-Rs*(st^2/Lq + ct^2/Ld) + ome*st*ct*(Ld/Lq - Lq/Ld));
        A92(1, 2) = dt*(-ome + Rs*st*ct*(1/Lq - 1/Ld) + ome*(Ld*st^2/Lq + Lq*ct^2/Ld));
        A92(1, 3) = dt*psi*st/Lq + dt*ial*st*ct*(Ld/Lq - Lq/Ld) + dt*ibe*(-1 + Ld/Lq*st^2 + Lq/Ld*ct^2);
        A92(1, 4) = dt*psi*ome/Lq + dt*ial*(-Rs*2*st/Lq + ome*ct*(Ld/Lq - Lq/Ld)) + dt*ibe*(Rs*ct*(1/Lq - 1/Ld) + ome*2*Ld*st/Lq);
        A92(1, 5) = dt*ial*(-Rs*2*ct/Ld + ome*st*(Ld/Lq - Lq/Ld)) + dt*ibe*(Rs*st*(1/Lq - 1/Ld) + ome*2*Lq*ct/Ld);

        A92(2, 1) = dt*(ome + Rs*st*ct*(1/Lq - 1/Ld) - ome*(Lq*st^2/Ld + Ld*ct^2/Lq));
        A92(2, 2) = 1 + dt*(-Rs*(st^2/Ld + ct^2/Lq) + ome*st*ct*(Lq/Ld - Ld/Lq));
        A92(2, 3) = -dt*psi*ct/Lq + dt*ial*(1 - Lq*st^2/Ld - Ld*ct^2/Lq) + dt*ibe*st*ct*(Lq/Ld - Ld/Lq);
        A92(2, 4) = dt*ial*(Rs*ct*(1/Lq - 1/Ld) - ome*2*Lq*st/Ld) + dt*ibe*(-Rs*2*st/Ld + ome*ct*(Lq/Ld - Ld/Lq));
        A92(2, 5) = -dt*psi*ome/Lq + dt*ial*(Rs*st*(1/Lq - 1/Ld) -ome*2*Ld*ct/Lq) + dt*ibe*(-Rs*2*ct/Lq + ome*st*(Lq/Ld - Ld/Lq));

        A92(3, 1) = dt*kpp/J*((Ld - Lq)*(-2*ial*st*ct + ibe*ct^2 - ibe*st^2) - psi*st);
        A92(3, 2) = dt*kpp/J*((Ld - Lq)*(ial*ct^2 - ial*st^2 + 2*ibe*st*ct) + psi*ct);
        A92(3, 3) = 1;
        A92(3, 4) = dt*kpp/J*((Ld - Lq)*(-ial^2*ct - ial*ibe*2*st + ibe^2*ct) - psi*ial);
        A92(3, 5) = dt*kpp/J*((Ld - Lq)*(-ial^2*st + ial*ibe*2*ct + ibe^2*st) + psi*ibe);

        A92(4,3) = dt*cos(the);
        A92(4,5) = dt*ome;
        A92(5,3) = -dt*sin(the);
        A92(5,4) = -dt*ome;
    
        D11 = A92'*iQ5*A92;
        D12 = -A92'*iQ5;
        D21 = D12';
        D22 = iQ5 + C5'*iR*C5;

        Jj9 = D22 - D21/(Jj9 + D11)*D12;
        iJn9(:,:,t) = inv(Jj9);
    end
    if(model10 == 1) %al-be/E/Ldq
        A70 = [[ (Lq - Rs*dt*1/2*(1 - e2q4*ch2t))/Lq - (dt*hom*sht*e05q4*Lq^2*cht*e05q4 + Rs*dt*Lq*1/2*(1 + e2q4*ch2t))/(Ld*Lq) + (Ld*dt*hom*sht*cht*e2q4)/Lq,                                       (dt*(Ld - Lq)*(- Lq*hom*1/2*(1 + e2q4*ch2t) + Rs*sht*cht*e2q4 + Ld*hom*1/2*(1 - e2q4*ch2t)))/(Ld*Lq),    dt*cht*e05q4*(hia*sht*e05q4 - hib*cht*e05q4 + (Lq*(hib*cht*e05q4 - hia*sht*e05q4))/Ld) + dt*sht*e05q4*(psi/Lq - hia*cht*e05q4 - hib*sht*e05q4 + (Ld*(hia*cht*e05q4 + hib*sht*e05q4))/Lq),                                               (dt*(hom*psi*cht*e05q4 + Rs*hib*ch2t*e2q4 - Rs*hia*sh2t*e2q4))/Lq + (Ld*dt*(hia*hom*ch2t*e2q4 + hib*hom*sh2t*e2q4))/Lq - (dt*(Lq^2*hia*hom*ch2t*e2q4 + Lq^2*hib*hom*sh2t*e2q4 + Lq*Rs*hib*ch2t*e2q4 - Lq*Rs*hia*sh2t*e2q4))/(Ld*Lq)];...
                [                                       (dt*(Ld - Lq)*(- Ld*hom*1/2*(1 + e2q4*ch2t) + Rs*sht*cht*e2q4 + Lq*hom*1/2*(1 - e2q4*ch2t)))/(Ld*Lq), (Lq - Rs*dt*1/2*(1 + e2q4*ch2t))/Lq - (Lq*Rs*dt*1/2*(1 - e2q4*ch2t) - Lq^2*dt*hom*sht*cht*e2q4)/(Ld*Lq) - (Ld*dt*hom*sht*cht*e2q4)/Lq, (dt*(Lq*hia - psi*cht*e05q4))/Lq + (dt*((Lq^2*hia*ch2t*e2q4)/2 - (Lq^2*hia)/2 + (Lq^2*hib*sh2t*e2q4)/2))/(Ld*Lq) - (Ld*dt*(hia/2 + (hia*ch2t*e2q4)/2 + (hib*sh2t*e2q4)/2))/Lq, (dt*hom*psi*sht*e05q4 - Rs*dt*hia*(2*1/2*(1 - e2q4*ch2t) - 1) + Rs*dt*hib*sh2t*e2q4)/Lq + (Ld*(dt*hib*hom*(2*1/2*(1 - e2q4*ch2t) - 1) + dt*hia*hom*sh2t*e2q4))/Lq - (Lq*Rs*dt*hib*sh2t*e2q4 + Lq^2*dt*hib*hom*(2*1/2*(1 - e2q4*ch2t) - 1) + Lq^2*dt*hia*hom*sh2t*e2q4 - Lq*Rs*dt*hia*(2*1/2*(1 - e2q4*ch2t) - 1))/(Ld*Lq)];...
                [     -dt*kppj*(psi*sht*e05q4 - cht*e05q4*(Ld - Lq)*(hib*cht*e05q4 - hia*sht*e05q4) + sht*e05q4*(Ld - Lq)*(hia*cht*e05q4 + hib*sht*e05q4)),      dt*kppj*(psi*cht*e05q4 + cht*e05q4*(Ld - Lq)*(hia*cht*e05q4 + hib*sht*e05q4) + sht*e05q4*(Ld - Lq)*(hib*cht*e05q4 - hia*sht*e05q4)),                                                                                                                                                                         1.0,                                                                                                                                                   -dt*kppj*(psi*(hia*cht*e05q4 + hib*sht*e05q4) + (Ld - Lq)*(hia*cht*e05q4 + hib*sht*e05q4)^2 - (Ld - Lq)*(hib*cht*e05q4 - hia*sht*e05q4)^2)];...
                [                                                                                                                             0.0,                                                                                                                             0.0,                                                                                                                                                                        dt,                                                                                                                                                                                                                                                                                1.0]];
        
        D11 = zeros(4);
        D11(1,1) = 1/q1 + (dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q2 + (dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q2 - (2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 + (4*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q2 + (Rs^2*dt^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Rs^2*dt^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (2*Rs*dt*1/2*(1 + e2q4*ch2t))/(Ld*q1) + (dt^2*kppj^2*psi^2*1/2*(1 - e2q4*ch2t))/q3 - (2*Rs*dt*1/2*(1 - e2q4*ch2t))/(Lq*q1) - (2*Lq*dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) + (Ld^2*dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) + (Lq^2*dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld*dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) + (2*Ld*dt^2*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (2*Lq*dt^2*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (2*Ld*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (2*Lq*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld*q2) - (2*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) - (2*Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q2) + (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (4*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) - (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) - (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (4*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) + (Lq^2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (4*Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (4*Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (2*Ld*dt*hom*sht*cht*e2q4)/(Lq*q1) - (2*Lq*dt*hom*sht*cht*e2q4)/(Ld*q1) + (4*Ld*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (2*Ld*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (4*Lq*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (2*Lq*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (4*Ld^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (4*Ld^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (4*Lq^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (4*Lq^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (8*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (4*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Ld*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (2*Lq*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (2*Ld*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (2*Lq*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (8*Ld*Lq*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (8*Ld*Lq*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3;
        D11(1,2) = (dt*hom*1/2*(1 + e2q4*ch2t))/q2 - (dt*hom*1/2*(1 + e2q4*ch2t))/q1 - (dt*hom*1/2*(1 - e2q4*ch2t))/q1 + (dt*hom*1/2*(1 - e2q4*ch2t))/q2 - (dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 + (dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 + (Lq*dt*hom*1/2*(1 + e2q4*ch2t))/(Ld*q1) - (Ld*dt*hom*1/2*(1 + e2q4*ch2t))/(Lq*q2) + (Ld*dt*hom*1/2*(1 - e2q4*ch2t))/(Lq*q1) - (Lq*dt*hom*1/2*(1 - e2q4*ch2t))/(Ld*q2) - (dt^2*kppj^2*psi^2*sht*cht*e2q4)/q3 - (Rs*dt*sht*cht*e2q4)/(Ld*q1) - (Rs*dt*sht*cht*e2q4)/(Ld*q2) + (Rs*dt*sht*cht*e2q4)/(Lq*q1) + (Rs*dt*sht*cht*e2q4)/(Lq*q2) + (Rs^2*dt^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Rs^2*dt^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (Rs^2*dt^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (Rs^2*dt^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (Rs*dt^2*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (Rs*dt^2*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (Rs*dt^2*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) + (Rs*dt^2*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Ld*dt^2*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (Lq*dt^2*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (Rs^2*dt^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q1) - (Rs^2*dt^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q1) - (Rs^2*dt^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q2) + (Rs^2*dt^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q2) + (Ld*dt^2*hia*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (Lq*dt^2*hia*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (Lq^2*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Ld^2*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (Lq^2*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (Ld^2*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (2*Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (2*Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (2*Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (2*Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (Ld^2*dt^2*hia*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*hia*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*hia*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*hia*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Ld*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (Ld*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (Lq*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (Lq*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (Ld*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) - (Ld*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) + (Lq*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) + (Lq*dt^2*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) - (Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Ld*q1) + (Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Ld*q2) - (Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Lq*q1) + (Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (Lq*Rs*dt^2*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld*Rs*dt^2*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) - (Ld*Rs*dt^2*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Lq*Rs*dt^2*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) - (3*Ld*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (3*Ld*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (3*Lq*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (3*Lq*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (Ld*Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (Lq*Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (Ld*Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (Lq*Rs*dt^2*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (4*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (4*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (4*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (4*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Ld*Lq*dt^2*hia*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*hia*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (6*Ld^2*dt^2*hia*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (6*Lq^2*dt^2*hia*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (12*Ld*Lq*dt^2*hia*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3;
        D11(1,3) = (3*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(2*q2) - (dt*hib*1/2*(1 - e2q4*ch2t))/q1 - (dt*hib*1/2*(1 + e2q4*ch2t))/q1 - (dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*q2) + (3*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(2*q2) - (dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*q2) - (dt*kppj*psi*sht*e05q4)/q3 + (dt*psi*sht*e05q4)/(Lq*q1) + (Lq*dt*hib*1/2*(1 + e2q4*ch2t))/(Ld*q1) + (Ld*dt*hib*1/2*(1 - e2q4*ch2t))/(Lq*q1) - (2*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/q1 + (dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/q2 + (Rs*dt^2*hib*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (Rs*dt^2*hib*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (Rs*dt^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q1) - (dt^2*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq*q2) - (dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 + (dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 + (Ld*dt*hib*kppj*1/2*(1 + e2q4*ch2t))/q3 - (Lq*dt*hib*kppj*1/2*(1 + e2q4*ch2t))/q3 - (Ld*dt*hib*kppj*1/2*(1 - e2q4*ch2t))/q3 + (Lq*dt*hib*kppj*1/2*(1 - e2q4*ch2t))/q3 + (Ld*dt^2*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq^2*q2) - (Ld*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(2*Lq*q2) - (3*Lq*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(2*Ld*q2) + (Ld*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*Lq*q2) - (Lq*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*Ld*q2) - (3*Rs*dt^2*hia*sht*cht*e2q4)/(2*Ld*q2) + (3*Rs*dt^2*hia*sht*cht*e2q4)/(2*Lq*q2) + (Ld^2*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(2*Lq^2*q2) + (Ld^2*dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*Lq^2*q2) + (Lq^2*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(2*Ld^2*q2) + (Lq^2*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*Ld^2*q2) - (2*Ld*dt*hia*kppj*sht*cht*e2q4)/q3 + (2*Lq*dt*hia*kppj*sht*cht*e2q4)/q3 + (Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Ld*q2) + (Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Ld*q2) - (Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) - (Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Lq*q2) + (Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Lq*q2) - (Rs*dt^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2) - (dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q1) + (dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q2) - (dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq*q2) + (Ld*dt*hia*sht*cht*e2q4)/(Lq*q1) - (Lq*dt*hia*sht*cht*e2q4)/(Ld*q1) + (Rs*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld*q2) + (Rs*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (Lq*Rs*dt^2*hib*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (Ld*Rs*dt^2*hib*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (3*Ld*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(2*Lq*q2) - (Lq*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(2*Ld*q2) - (Ld*dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*Lq*q2) + (Lq*dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*Ld*q2) - (Ld*Rs*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (Lq*Rs*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (Rs*dt^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q1) + (Rs*dt^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q2) - (Lq^2*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Ld^2*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (Lq^2*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (Ld^2*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) - (Ld*Rs*dt^2*hia*sht*cht*e2q4)/(2*Lq^2*q2) + (Lq*Rs*dt^2*hia*sht*cht*e2q4)/(2*Ld^2*q2) + (Lq^2*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (Lq^2*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(2*Ld^2*q2) - (Ld^2*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(2*Lq^2*q2) - (Ld*Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Lq*Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Ld*Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Lq^2*q2) - (Ld*Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Lq^2*q2) + (Lq*Rs*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Ld^2*q2) - (Lq*Rs*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Ld^2*q2) - (Ld*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (Ld*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (Lq*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (Lq*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (Ld*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) - (Ld*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) + (Lq*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) + (Lq*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) + (Ld*dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1);
        D11(1,4) = (dt^2*hib*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/q2 - (dt^2*hib*(hom^2 + q3)*1/2*(1 + e2q4*ch2t))/q2 - (2*dt^2*hib*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q2 + (Rs^2*dt^2*hib*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*q2) + (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq*q2) - (Rs*dt*hib*1/2*(1 + e2q4*ch2t))/(Ld*q1) + (Rs*dt*hib*1/2*(1 + e2q4*ch2t))/(Lq*q1) + (dt^2*hib*kppj^2*psi^2*1/2*(1 - e2q4*ch2t))/q3 + (Rs*dt*hib*1/2*(1 - e2q4*ch2t))/(Ld*q1) - (Rs*dt*hib*1/2*(1 - e2q4*ch2t))/(Lq*q1) + (2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 - (2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 - (2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 + (2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 + (Ld^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (4*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 + (2*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q2 + (Rs^2*dt^2*hib*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (dt*hom*psi*cht*e05q4)/(Lq*q1) - (Rs*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(Ld*q2) - (Rs*dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (2*Rs*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(Lq*q2) - (Rs*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (2*Rs*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(Ld*q2) + (4*Rs*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) + (Rs*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (2*Rs*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (2*Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (2*Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Ld^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Lq^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Lq^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Ld*dt^2*hib*(hom^2 + q3)*1/2*(1 + e2q4*ch2t))/(Lq*q2) + (Lq*dt^2*hib*(hom^2 + q3)*1/2*(1 + e2q4*ch2t))/(Ld*q2) - (2*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Ld*dt^2*hib*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/(Lq*q2) + (Lq*dt^2*hib*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/(Ld*q2) + (2*Ld*dt^2*hib*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (2*Lq*dt^2*hib*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) + (Rs^2*dt^2*hia*sht*cht*e2q4)/(Ld^2*q2) + (Rs^2*dt^2*hia*sht*cht*e2q4)/(Lq^2*q2) - (Ld*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 + (2*Ld*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 + (Lq*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (2*Lq*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 + (Ld*dt*hia*hom*1/2*(1 + e2q4*ch2t))/(Lq*q1) - (Lq*dt*hia*hom*1/2*(1 + e2q4*ch2t))/(Ld*q1) - (Rs^2*dt^2*hib*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q1) - (Ld*dt*hia*hom*1/2*(1 - e2q4*ch2t))/(Lq*q1) + (Lq*dt*hia*hom*1/2*(1 - e2q4*ch2t))/(Ld*q1) - (Rs^2*dt^2*hib*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q1) - (2*Ld^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (dt^2*hia*kppj^2*psi^2*sht*cht*e2q4)/q3 + (Ld^2*dt^2*hib*(hom^2 + q3)*1/2*(1 + e2q4*ch2t))/(Lq^2*q2) + (2*Rs*dt*hia*sht*cht*e2q4)/(Ld*q1) - (2*Rs*dt*hia*sht*cht*e2q4)/(Lq*q1) - (Lq^2*dt^2*hib*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) + (2*Lq^2*dt^2*hib*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Lq^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Lq^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q1) + (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq*q2) + (2*Lq^2*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (2*Ld^2*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (2*Ld^2*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) + (10*Ld^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (10*Lq^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (2*Ld*dt*hib*hom*sht*cht*e2q4)/(Lq*q1) - (2*Lq*dt*hib*hom*sht*cht*e2q4)/(Ld*q1) - (2*Rs^2*dt^2*hia*sht*cht*e2q4)/(Ld*Lq*q2) + (4*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (4*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (2*Ld*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (2*Ld*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) - (2*Lq*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) - (2*Lq*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) + (3*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Ld*q1) + (3*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (6*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Lq*q2) + (Ld*dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) - (Ld*dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2) + (Lq*Rs*dt^2*hia*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (Ld*Rs*dt^2*hia*hom*1/2*(1 + e2q4*ch2t))/(Lq^2*q2) + (Ld*Rs*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Lq*Rs*dt^2*hia*hom*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) - (2*Lq*Rs*dt^2*hia*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (3*Ld*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (2*Ld*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (3*Lq*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (2*Lq*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (Ld*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (Lq*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q1) + (2*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q1) + (4*Rs^2*dt^2*hia*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q2) + (Rs*dt^2*hib*hom*sht*cht*e2q4)/(Ld*q2) + (Rs*dt^2*hib*hom*sht*cht*e2q4)/(Lq*q2) + (4*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (Lq^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (Lq^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (Ld^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Ld^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) + (2*Lq^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (2*Ld^2*dt^2*hia*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (2*Ld*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (2*Lq*dt^2*hib*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld*q2) - (Rs*dt^2*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*Lq*q1) + (6*Ld^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (6*Ld^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (6*Lq^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (6*Lq^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (2*Ld*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*Ld*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) - (4*Rs^2*dt^2*hib*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q2) + (3*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (6*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) - (2*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) + (Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (3*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (4*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) - (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) + (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) - (20*Ld*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (3*Ld*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Ld*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (Lq*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (3*Lq*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (2*Ld*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (4*Lq*Rs*dt^2*hib*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (7*Ld*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (7*Lq*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (3*Ld*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (3*Lq*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (4*Ld*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) + (2*Lq*Rs*dt^2*hia*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q2) - (12*Ld*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (12*Ld*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (Ld*Rs*dt^2*hib*hom*sht*cht*e2q4)/(Lq^2*q2) - (Lq*Rs*dt^2*hib*hom*sht*cht*e2q4)/(Ld^2*q2);

        D11(2,1) = D11(1,2);
        D11(2,2) = 1/q2 + (dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 + (dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 + (4*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 - (2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q2 + (Rs^2*dt^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) + (Rs^2*dt^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (dt^2*kppj^2*psi^2*1/2*(1 + e2q4*ch2t))/q3 - (2*Rs*dt*1/2*(1 + e2q4*ch2t))/(Lq*q2) - (2*Rs*dt*1/2*(1 - e2q4*ch2t))/(Ld*q2) - (2*Ld*dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Lq^2*dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (2*Lq*dt^2*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (2*Ld*dt^2*hia*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (2*Lq*dt^2*hia*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (2*Ld*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (2*Lq*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld*q1) - (2*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) + (2*Rs^2*dt^2*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q2) + (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (4*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) - (4*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (2*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (Lq^2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (Ld^2*dt^2*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (4*Ld^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (4*Lq^2*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Ld*dt*hom*sht*cht*e2q4)/(Lq*q2) + (2*Lq*dt*hom*sht*cht*e2q4)/(Ld*q2) - (2*Ld*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (4*Ld*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (2*Lq*dt^2*hia*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (4*Lq*dt^2*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (4*Ld^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (4*Ld^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (4*Lq^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (4*Lq^2*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (4*Ld*Lq*dt^2*(hia^2 + q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (8*Ld*Lq*dt^2*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (2*Ld*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (2*Lq*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld*Rs*dt^2*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) - (2*Lq*Rs*dt^2*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (8*Ld*Lq*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (8*Ld*Lq*dt^2*hia*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3;
        D11(2,3) = (dt*hia)/q2 + (dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 + (dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 + (dt*kppj*psi*cht*e05q4)/q3 - (dt*psi*cht*e05q4)/(Lq*q2) - (Ld*dt*hia)/(2*Lq*q2) - (Lq*dt*hia)/(2*Ld*q2) - (Ld*dt*hia*1/2*(1 + e2q4*ch2t))/(2*Lq*q2) + (Lq*dt*hia*1/2*(1 + e2q4*ch2t))/(2*Ld*q2) + (Ld*dt*hia*1/2*(1 - e2q4*ch2t))/(2*Lq*q2) - (Lq*dt*hia*1/2*(1 - e2q4*ch2t))/(2*Ld*q2) + (4*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/q1 - (2*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/q2 + (Rs*dt^2*hia*1/2*(1 + e2q4*ch2t))/(2*Ld*q2) - (Rs*dt^2*hia*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*Ld*q2) - (Rs*dt^2*hia*1/2*(1 + e2q4*ch2t))/(Lq*q2) + (Rs*dt^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq^2*q2) - (Rs*dt^2*hia*1/2*(1 - e2q4*ch2t))/(Ld*q2) + (Rs*dt^2*hia*1/2*(1 - e2q4*ch2t))/(2*Lq*q2) - (Rs*dt^2*hia*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*Lq*q2) - (dt^2*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq*q1) - (dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 + (dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 + (Ld*dt*hia*kppj*1/2*(1 + e2q4*ch2t))/q3 - (Lq*dt*hia*kppj*1/2*(1 + e2q4*ch2t))/q3 - (Ld*dt*hia*kppj*1/2*(1 - e2q4*ch2t))/q3 + (Lq*dt*hia*kppj*1/2*(1 - e2q4*ch2t))/q3 - (2*Ld*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Ld*dt^2*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q1) + (Lq^2*dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (2*Ld*dt*hib*kppj*sht*cht*e2q4)/q3 - (2*Lq*dt*hib*kppj*sht*cht*e2q4)/q3 + (Rs*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (2*Rs*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (Rs*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) - (2*Rs*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (Rs*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (Rs*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (Rs*dt^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) + (dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q1) - (dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q2) - (dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq*q1) - (Ld*dt*hib*sht*cht*e2q4)/(Lq*q2) + (Lq*dt*hib*sht*cht*e2q4)/(Ld*q2) - (Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Ld*q1) + (Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(2*Ld*q2) - (Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Lq*q1) + (Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(2*Lq*q2) + (Ld*Rs*dt^2*hia*1/2*(1 + e2q4*ch2t))/(2*Lq^2*q2) + (Ld*Rs*dt^2*hia*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*Lq^2*q2) + (Lq*Rs*dt^2*hia*1/2*(1 - e2q4*ch2t))/(2*Ld^2*q2) + (Lq*Rs*dt^2*hia*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*Ld^2*q2) - (2*Lq*dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (Ld*Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (Lq*Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (Ld*Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(2*Lq^2*q2) - (Lq*Rs*dt^2*hia*1/8*(1 - e8q4*ch4t))/(2*Ld^2*q2) - (Rs*dt^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q1) + (Rs*dt^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q2) - (Lq^2*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Ld^2*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (2*Ld*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (2*Lq*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld*q1) - (Lq^2*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Ld^2*q2) + (Lq^2*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Ld^2*q2) - (Ld^2*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(2*Lq^2*q2) + (Ld^2*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(2*Lq^2*q2) - (Ld*dt^2*hia*hom*sht*cht*e2q4)/(Lq*q2) + (Lq*dt^2*hia*hom*sht*cht*e2q4)/(Ld*q2) + (Lq^2*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (Ld^2*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) + (Ld*Rs*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (Lq*Rs*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (Ld*Rs*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) - (Lq*Rs*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (Ld*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (Ld*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (Lq*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (Lq*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (Lq^2*dt^2*hia*hom*sht*cht*e2q4)/(2*Ld^2*q2) + (Ld^2*dt^2*hia*hom*sht*cht*e2q4)/(2*Lq^2*q2) + (Ld*dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2);
        D11(2,4) = (dt^2*hia*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 + (dt^2*hia*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 - (Rs*dt*hia)/(Ld*q2) + (Rs*dt*hia)/(Lq*q2) + (Rs^2*dt^2*hia*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) - (2*Rs^2*dt^2*hia*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (dt*hom*psi*sht*e05q4)/(Lq*q2) + (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*q1) - (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq*q1) - (dt^2*hia*kppj^2*psi^2*1/2*(1 + e2q4*ch2t))/q3 + (2*Rs*dt*hia*1/2*(1 - e2q4*ch2t))/(Ld*q2) - (2*Rs*dt*hia*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 + (4*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (Ld*dt*hib*hom)/(Lq*q2) + (Lq*dt*hib*hom)/(Ld*q2) - (Ld^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Lq^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Ld^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Lq^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 + (4*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q2 - (2*dt^2*hib*(hom^2 + q3)*sht*cht*e2q4)/q2 - (Rs^2*dt^2*hia*1/2*(1 + e2q4*ch2t))/(Lq^2*q2) + (2*Rs*dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (Rs*dt^2*hib*hom*1/2*(1 + e2q4*ch2t))/(Ld*q2) - (Rs*dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (Rs*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (2*Rs*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Rs*dt^2*hib*hom*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (2*Rs*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (2*Rs^2*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (2*Rs^2*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (2*Rs^2*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Ld^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Lq^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (2*Lq^2*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (2*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Ld*dt^2*hia*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Lq*dt^2*hia*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (2*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld*dt^2*hia*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (Lq*dt^2*hia*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (2*Ld*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (Ld*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (2*Lq*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (Lq*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (Rs^2*dt^2*hia*1/2*(1 + e2q4*ch2t))/(Ld*Lq*q2) + (2*Ld*dt*hib*hom*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (2*Lq*dt*hib*hom*1/2*(1 - e2q4*ch2t))/(Ld*q2) - (Rs^2*dt^2*hia*1/2*(1 - e2q4*ch2t))/(Ld*Lq*q2) + (2*Rs^2*dt^2*hia*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q2) + (2*Ld^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (2*Lq^2*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (dt^2*hib*kppj^2*psi^2*sht*cht*e2q4)/q3 - (Lq^2*dt^2*hia*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (2*Rs*dt*hib*sht*cht*e2q4)/(Ld*q2) + (2*Rs*dt*hib*sht*cht*e2q4)/(Lq*q2) - (Ld^2*dt^2*hia*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Ld^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Rs^2*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (Rs^2*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (Rs^2*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Rs^2*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (Ld^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q2) - (dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq*q1) + (Lq^2*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (2*Lq^2*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (2*Ld^2*dt^2*hia*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (10*Ld^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (10*Lq^2*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (2*Ld*dt*hia*hom*sht*cht*e2q4)/(Lq*q2) - (2*Lq*dt*hia*hom*sht*cht*e2q4)/(Ld*q2) + (4*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (4*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Ld*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (2*Ld*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (2*Lq*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (2*Lq*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) + (Lq^2*dt^2*hib*(hom^2 + q3)*sht*cht*e2q4)/(Ld^2*q2) + (Ld^2*dt^2*hib*(hom^2 + q3)*sht*cht*e2q4)/(Lq^2*q2) - (3*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld*q1) + (4*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld*q2) - (3*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq*q1) + (2*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq*q2) + (Ld*dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) - (Ld*dt^2*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) - (Lq*Rs*dt^2*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld*Rs*dt^2*hib*hom*1/2*(1 + e2q4*ch2t))/(Lq^2*q2) - (Ld*Rs*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (Lq*Rs*dt^2*hib*hom*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) + (2*Lq*Rs*dt^2*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (2*Ld*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (3*Ld*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (2*Lq*dt^2*(hia^2 + q1)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (3*Lq*dt^2*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q1) - (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q1) - (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q2) + (2*Rs^2*dt^2*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q2) + (Rs*dt^2*hia*hom*sht*cht*e2q4)/(Ld*q2) + (Rs*dt^2*hia*hom*sht*cht*e2q4)/(Lq*q2) + (Ld*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (Lq*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (4*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld^2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (2*Lq^2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (2*Ld^2*dt^2*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) + (6*Ld^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (6*Ld^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (6*Lq^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (6*Lq^2*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (2*Ld*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (Rs*dt^2*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*Lq*q2) - (2*Ld*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (4*Rs^2*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) - (2*Rs^2*dt^2*hia*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q2) - (Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (5*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (2*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) + (2*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) + (5*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) + (Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) - (4*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) - (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2) + (20*Ld*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (3*Ld*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Ld*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (Lq*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (3*Lq*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (2*Ld*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (4*Lq*Rs*dt^2*hia*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (7*Ld*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (7*Lq*dt^2*hia*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (3*Ld*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (3*Lq*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (4*Ld*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Lq*Rs*dt^2*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (Rs*dt^2*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q1) - (12*Ld*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (12*Ld*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (Ld*Rs*dt^2*hia*hom*sht*cht*e2q4)/(Lq^2*q2) - (Lq*Rs*dt^2*hia*hom*sht*cht*e2q4)/(Ld^2*q2);

        D11(3,1) = D11(1,3);
        D11(3,2) = D11(2,3);
        D11(3,3) = 1/q3 + dt^2/q4 + (3*dt^2*(hia^2 + q1))/(2*q2) + (dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 - (dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(2*q2) + (dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 - (dt^2*(hia^2 + q1)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(2*q2) + (Lq^2*dt^2*(hia^2 + q1))/(4*Ld^2*q2) + (Ld^2*dt^2*(hia^2 + q1))/(4*Lq^2*q2) - (2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/q1 + (4*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/q1 + (dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/q2 - (2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/q2 + (dt^2*psi^2*1/2*(1 + e2q4*ch2t))/(Lq^2*q2) - (Ld*dt^2*(hia^2 + q1))/(Lq*q2) - (Lq*dt^2*(hia^2 + q1))/(Ld*q2) + (dt^2*psi^2*1/2*(1 - e2q4*ch2t))/(Lq^2*q1) + (Lq^2*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (Lq^2*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Ld^2*q2) + (Ld^2*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Lq^2*q2) + (Lq^2*dt^2*(hia^2 + q1)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(4*Ld^2*q2) + (Ld^2*dt^2*(hia^2 + q1)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(4*Lq^2*q2) + (dt^2*hia*psi*cht*e05q4)/(Ld*q2) - (2*dt^2*hia*psi*cht*e05q4)/(Lq*q2) + (Ld^2*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Lq^2*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Ld^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Lq^2*q2) + (Lq^2*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(4*Ld^2*q2) + (Ld^2*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(4*Lq^2*q2) - (dt^2*hia*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*q2) - (2*dt^2*hib*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq*q1) - (2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 + (2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 - (2*Lq*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (Ld*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(Lq*q2) + (Lq*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(Ld*q2) - (2*Ld*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Ld*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (Lq*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(Ld*q2) + (2*Ld*dt^2*hib*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q1) - (2*Ld*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (2*Lq*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld*q1) + (Lq^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (Lq^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(2*Ld^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(2*Lq^2*q2) + (Lq^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (Ld^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q1) + (2*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q1) + (dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q2) - (2*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q2) - (2*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq*q1) + (Ld*dt^2*hia*psi*cht*e05q4)/(Lq^2*q2) + (Ld*dt^2*hia*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq^2*q2) - (2*Lq^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (Lq^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (Lq^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q2) - (Ld^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) + (Ld^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) - (2*Ld*dt^2*hia*hib*sht*cht*e2q4)/(Lq*q2) + (2*Lq*dt^2*hia*hib*sht*cht*e2q4)/(Ld*q2) - (2*Ld*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (2*Ld*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (2*Lq*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (2*Lq*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (Lq^2*dt^2*hia*hib*sht*cht*e2q4)/(Ld^2*q2) + (Ld^2*dt^2*hia*hib*sht*cht*e2q4)/(Lq^2*q2) + (2*Ld*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) - (Ld*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) + (2*Ld*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2);
        D11(3,4) = dt/q4 - (3*Rs*dt^2*(hia^2 + q1))/(2*Ld*q2) + (3*Rs*dt^2*(hia^2 + q1))/(2*Lq*q2) - (Rs*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (5*Rs*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Ld*q2) + (Rs*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) + (2*Rs*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (7*Rs*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Lq*q2) + (Rs*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (Ld*Rs*dt^2*(hia^2 + q1))/(2*Lq^2*q2) + (Lq*Rs*dt^2*(hia^2 + q1))/(2*Ld^2*q2) + (2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 - (2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 - (2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 + (2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 - (2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 + (2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q2 + (4*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (Ld*dt*(hia^2 + q1)*kppj*1/2*(1 + e2q4*ch2t))/q3 + (Ld*dt*(hib^2 + q2)*kppj*1/2*(1 + e2q4*ch2t))/q3 + (Lq*dt*(hia^2 + q1)*kppj*1/2*(1 + e2q4*ch2t))/q3 - (Lq*dt*(hib^2 + q2)*kppj*1/2*(1 + e2q4*ch2t))/q3 + (Ld*dt*(hia^2 + q1)*kppj*1/2*(1 - e2q4*ch2t))/q3 - (Ld*dt*(hib^2 + q2)*kppj*1/2*(1 - e2q4*ch2t))/q3 - (Lq*dt*(hia^2 + q1)*kppj*1/2*(1 - e2q4*ch2t))/q3 + (Lq*dt*(hib^2 + q2)*kppj*1/2*(1 - e2q4*ch2t))/q3 + (dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 - (dt^2*hia*hib*hom*1/2*(1 + e2q4*ch2t))/q2 + (dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 + (dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/q2 - (2*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q2 - (dt*hia*kppj*psi*cht*e05q4)/q3 - (dt*hib*kppj*psi*sht*e05q4)/q3 - (2*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/q2 + (2*Rs*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (Rs*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Ld*q2) - (Rs*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Rs*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Lq*q2) - (Rs*dt^2*hib*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q1) + (dt^2*hib*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*q1) - (dt^2*hib*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq*q1) - (Ld*dt^2*hia*hib*hom)/(Lq*q2) + (Lq*dt^2*hia*hib*hom)/(Ld*q2) + (dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*q1) - (dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(2*Ld*q2) + (2*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld*q1) - (Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld*q1) - (Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld*q2) + (2*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld*q2) + (2*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq*q2) + (2*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (Lq*Rs*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (Ld*Rs*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Lq^2*q2) - (Lq*Rs*dt^2*(hia^2 + q1)*1/2*(1 + e2q4*ch2t))/(2*Ld^2*q2) - (Ld*Rs*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (3*Ld*Rs*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Lq^2*q2) - (Lq*Rs*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(2*Ld^2*q2) - (Ld*Rs*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) - (Lq*Rs*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) - (Lq^2*dt^2*hia*hib*hom)/(2*Ld^2*q2) + (Ld^2*dt^2*hia*hib*hom)/(2*Lq^2*q2) + (dt^2*hom*psi^2*sht*cht*e2q4)/(Lq^2*q1) - (dt^2*hom*psi^2*sht*cht*e2q4)/(Lq^2*q2) - (Rs*dt^2*hia*psi*cht*e05q4)/(Lq^2*q2) - (6*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/q1 + (6*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/q2 - (dt^2*hib*hom*psi*cht*e05q4)/(Ld*q2) - (dt^2*hia*hom*psi*sht*e05q4)/(2*Ld*q2) + (dt^2*hia*hom*psi*sht*e05q4)/(Lq*q2) - (2*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q1) - (2*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q1) + (5*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(2*Ld*q2) + (3*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q2) - (dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq*q1) + (Ld*dt^2*hib*hom*psi*cht*e05q4)/(Lq^2*q2) - (Ld*dt^2*hia*hom*psi*sht*e05q4)/(2*Lq^2*q2) - (2*Ld*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (2*Ld*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (2*Lq*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (2*Lq*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) + (Lq^2*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Ld^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Lq^2*q2) + (Lq^2*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Ld^2*q2) + (Ld^2*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Lq^2*q2) + (Rs*dt^2*hia*psi*cht*e05q4)/(Ld*Lq*q2) - (Ld*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (Lq*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (Ld*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (Lq*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) + (2*Ld*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Lq*q2) - (2*Lq*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Ld*q2) - (Ld*dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q1) + (Ld*dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(2*Lq^2*q2) - (2*Rs*dt^2*hia*hib*sht*cht*e2q4)/(Ld*q2) + (4*Rs*dt^2*hia*hib*sht*cht*e2q4)/(Lq*q2) - (2*Ld*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (2*Lq*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (Lq*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (Ld*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) + (Lq*Rs*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (2*Ld*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Lq*Rs*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (Lq^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (Lq^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (Ld^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (2*Lq^2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (2*Ld^2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Lq^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (Lq^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q2) + (Ld^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (Ld^2*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) - (2*Lq^2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (2*Ld^2*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) + (Rs*dt^2*hib*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*Lq*q1) - (Lq^2*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Lq^2*dt^2*hia*hib*hom*1/2*(1 + e2q4*ch2t))/(2*Ld^2*q2) + (Ld^2*dt^2*hia*hib*hom*1/2*(1 + e2q4*ch2t))/(2*Lq^2*q2) - (Ld^2*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Lq^2*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(2*Ld^2*q2) - (3*Ld^2*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(2*Lq^2*q2) + (Lq^2*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (Ld^2*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) - (4*Ld*dt*hia*hib*kppj*sht*cht*e2q4)/q3 + (4*Lq*dt*hia*hib*kppj*sht*cht*e2q4)/q3 - (Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (5*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) - (3*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) + (Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q2) + (2*Ld*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Lq*q2) - (2*Lq*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Ld*q2) + (5*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) + (Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) - (3*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) + (Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q2) - (2*Rs*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) + (Rs*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) + (2*Rs*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) - (2*Rs*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q2) + (3*Lq^2*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (3*Ld^2*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (3*Lq^2*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) - (3*Ld^2*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (3*Ld*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (Ld*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (Lq*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (3*Lq*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) + (3*Ld*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (Ld*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q2) + (3*Lq*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (Lq*Rs*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q2) + (2*Ld*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) + (3*Ld*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) - (5*Ld*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(2*Lq^2*q2) - (3*Ld*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) + (2*Rs*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q1) - (Rs*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q1) - (2*Rs*dt^2*hia*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q2) + (2*Rs*dt^2*hib*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q2) - (2*Ld*Rs*dt^2*hia*hib*sht*cht*e2q4)/(Lq^2*q2);

        D11(4,1) = D11(1,4);
        D11(4,2) = D11(2,4);
        D11(4,3) = D11(3,4);
        D11(4,4) = 1/q4 - (2*dt^2*(hib^2 + q2)*(hom^2 + q3))/q2 + (Rs^2*dt^2*(hia^2 + q1))/(Ld^2*q2) + (Rs^2*dt^2*(hia^2 + q1))/(Lq^2*q2) - (2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q1 - (2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q1 + (8*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/q2 - (8*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q2 + (4*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 - (8*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q1 - (8*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/q2 + (Rs^2*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Rs^2*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Rs^2*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) - (4*Rs^2*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) + (4*Rs^2*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (Rs^2*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (4*Rs^2*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(Lq^2*q2) + (4*Rs^2*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) + (Ld^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (dt^2*(hom^2 + q3)*psi^2*1/2*(1 + e2q4*ch2t))/(Lq^2*q1) + (Ld^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Ld^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (Lq^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (dt^2*(hom^2 + q3)*psi^2*1/2*(1 - e2q4*ch2t))/(Lq^2*q2) + (dt^2*(hia^2 + q1)*kppj^2*psi^2*1/2*(1 + e2q4*ch2t))/q3 + (dt^2*(hib^2 + q2)*kppj^2*psi^2*1/2*(1 - e2q4*ch2t))/q3 - (2*Rs^2*dt^2*(hia^2 + q1))/(Ld*Lq*q2) + (Lq^2*dt^2*(hib^2 + q2)*(hom^2 + q3))/(Ld^2*q2) + (Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3))/(Lq^2*q2) - (2*Rs^2*dt^2*(hib^2 + q2)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q1) + (8*Rs^2*dt^2*(hia^2 + q1)*1/2*(1 - e2q4*ch2t))/(Ld*Lq*q2) - (8*Rs^2*dt^2*(hia^2 + q1)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q2) + (Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) - (4*Lq^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) - (4*Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/2*(1 - e2q4*ch2t))/(Lq^2*q2) + (4*Lq^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (4*Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) + (2*dt^2*hib*(hom^2 + q3)*psi*sht*e05q4)/(Ld*q2) - (2*Ld^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*Rs*dt^2*hia*hib*hom)/(Ld*q2) + (2*Rs*dt^2*hia*hib*hom)/(Lq*q2) - (2*Ld^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (8*dt^2*hia*hib*(hom^2 + q3)*sht*cht*e2q4)/q2 - (2*Ld*Lq*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 - (2*Ld*Lq*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*Ld*dt^2*(hia^3 + 3*hia*q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (2*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (2*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*q1) + (2*Ld*dt^2*(hib^3 + 3*hib*q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (2*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (4*dt^2*hib*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*q2) + (4*Rs^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (2*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (4*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (4*Rs^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (2*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (4*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Ld^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Lq^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (8*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q1 - (8*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q1 - (16*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q2 - (2*Rs^2*dt^2*(hib^2 + q2)*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*Lq*q1) + (4*Ld*Lq*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/q3 + (2*dt^2*hia*hib*kppj^2*psi^2*sht*cht*e2q4)/q3 + (2*Rs*dt^2*hia*hom*psi*sht*e05q4)/(Lq^2*q2) + (4*Ld*Lq*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/q3 + (4*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) - (4*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (8*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (4*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (4*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (8*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (8*Rs^2*dt^2*(hia^2 + q1)*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) + (4*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q1) - (8*Rs^2*dt^2*(hib^2 + q2)*1/8*(1 - e8q4*ch4t))/(Ld*Lq*q2) - (4*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) + (4*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) + (4*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q1) - (4*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*q1) + (8*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) - (8*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*q2) - (4*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) + (4*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (4*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q1) - (4*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq*q1) + (8*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) - (8*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq*q2) - (2*Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) - (2*Ld^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (4*Lq^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (4*Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) + (4*Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Ld^2*q2) + (4*Ld^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) - (2*Ld*dt^2*(hia^3 + 3*hia*q1)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (2*Ld*dt^2*(hib^3 + 3*hib*q2)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (2*Lq*dt^2*(hia^3 + 3*hia*q1)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (2*Lq*dt^2*(hib^3 + 3*hib*q2)*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 + (2*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q1) - (4*dt^2*hib*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*q1) - (4*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*q2) - (2*Rs*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (2*Rs*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) + (2*Rs*dt^2*hib*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq^2*q1) + (20*Ld^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (20*Lq^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (2*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q1) - (8*Rs*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Ld*q2) + (8*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld*q2) - (2*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q1) - (8*Rs*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Lq*q2) + (8*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq*q2) - (2*Ld*dt^2*hib*(hom^2 + q3)*psi*sht*e05q4)/(Lq^2*q2) - (2*Ld*Rs*dt^2*hia*hib*hom)/(Lq^2*q2) - (2*Lq*Rs*dt^2*hia*hib*hom)/(Ld^2*q2) - (4*Rs*dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q2) + (4*Ld*Lq*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (4*Ld*Lq*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 + (8*Ld^2*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (8*Ld^2*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (8*Ld^2*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (8*Ld^2*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (8*Lq^2*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (8*Lq^2*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (8*Lq^2*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (8*Lq^2*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (2*Ld*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Lq^2*q1) + (4*Ld*dt^2*hib*(hom^2 + q3)*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Lq^2*q2) + (4*Rs^2*dt^2*hia*hib*sht*cht*e2q4)/(Ld^2*q2) + (4*Rs^2*dt^2*hia*hib*sht*cht*e2q4)/(Lq^2*q2) - (2*Ld*dt^2*hia*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 + (2*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/q3 - (4*Rs*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Ld*q2) + (4*Rs*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Ld*q2) - (4*Rs*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Lq*q2) + (4*Rs*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Lq*q2) - (2*Ld*dt^2*(hia^2 + q1)*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 + (2*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/q3 - (4*Lq^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (4*Lq^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (4*Ld^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (4*Ld^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) + (8*Lq^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (8*Ld^2*dt^2*hia*hib*(hom^2 + q3)*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (2*Rs*dt^2*hib*hom*psi*1/4*e92q4*(3*e4q4*cht + ch3t))/(Ld*Lq*q1) + (4*Rs*dt^2*hia*hom*psi*1/4*e92q4*(3*e4q4*sht - sh3t))/(Ld*Lq*q2) + (4*Ld*Rs*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Lq^2*q2) + (4*Lq*Rs*dt^2*(hia^2 + q1)*hom*sht*cht*e2q4)/(Ld^2*q2) - (4*Ld*Rs*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Lq^2*q2) - (4*Lq*Rs*dt^2*(hib^2 + q2)*hom*sht*cht*e2q4)/(Ld^2*q2) - (4*Rs*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) - (2*Rs*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) + (4*Rs*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) - (40*Ld*Lq*dt^2*(hia^2 + q1)*(hib^2 + q2)*kppj^2*1/8*(1 - e8q4*ch4t))/q3 - (8*Rs^2*dt^2*hia*hib*sht*cht*e2q4)/(Ld*Lq*q2) + (4*Ld*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) - (4*Ld*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) + (4*Lq*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) - (4*Lq*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (4*Ld*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q1) + (4*Ld*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Lq^2*q1) - (4*Lq*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q1) + (4*Lq*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld^2*q1) - (8*Ld*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) - (8*Lq*Rs*dt^2*(hia^2 + q1)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) + (8*Ld*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Lq^2*q2) + (8*Lq*Rs*dt^2*(hib^2 + q2)*hom*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld^2*q2) - (16*Ld*Lq*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 + (16*Ld*Lq*dt^2*hia*(hib^3 + 3*hib*q2)*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 + (16*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 - ch2t)*sh2t)/q3 - (16*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*hib*kppj^2*1/4*e8q4*(e6q4 + ch2t)*sh2t)/q3 - (4*Lq^2*dt^2*hia*hib*(hom^2 + q3)*sht*cht*e2q4)/(Ld^2*q2) - (4*Ld^2*dt^2*hia*hib*(hom^2 + q3)*sht*cht*e2q4)/(Lq^2*q2) + (12*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld*q1) - (8*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld*q2) + (12*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq*q1) - (8*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq*q2) - (2*Ld*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q1) + (4*Ld*dt^2*hib*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Lq^2*q1) + (4*Ld*dt^2*hia*(hom^2 + q3)*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Lq^2*q2) + (2*Ld*Rs*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hia*hib*hom*1/8*(3 + 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (2*Ld*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q1) + (8*Ld*Rs*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Lq^2*q2) + (8*Lq*Rs*dt^2*hia*hib*hom*1/2*(1 - e2q4*ch2t))/(Ld^2*q2) - (8*Ld*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Lq^2*q2) - (8*Lq*Rs*dt^2*hia*hib*hom*1/8*(3 - 4*e2q4*ch2t + e8q4*ch4t))/(Ld^2*q2) + (10*Ld*dt^2*hia*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 + (10*Ld*dt^2*(hia^2 + q1)*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (10*Lq*dt^2*hia*(hib^2 + q2)*kppj^2*psi*1/4*e92q4*(e4q4*cht - ch3t))/q3 - (10*Lq*dt^2*(hia^2 + q1)*hib*kppj^2*psi*1/4*e92q4*(e4q4*sht + sh3t))/q3 - (2*Rs*dt^2*hia*hom*psi*sht*e05q4)/(Ld*Lq*q2) - (8*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q1) + (8*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 + ch2t)*sh2t)/(Ld*Lq*q1) + (16*Rs^2*dt^2*hia*hib*1/4*e8q4*(e6q4 - ch2t)*sh2t)/(Ld*Lq*q2) + (4*Rs*dt^2*hia*hom*psi*1/4*e92q4*(e4q4*sht + sh3t))/(Ld*Lq*q1) + (2*Rs*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q1) - (4*Rs*dt^2*hib*hom*psi*1/4*e92q4*(e4q4*cht - ch3t))/(Ld*Lq*q2) - (12*Ld*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q1) - (12*Lq*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q1) + (8*Ld*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Lq^2*q2) + (8*Lq*Rs*dt^2*hia*hib*hom*1/8*(1 - e8q4*ch4t))/(Ld^2*q2); 
        
        
        D12 = -A70'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;

        Jj10 = D22 - D21/(Jj10 + D11)*D12;
        iJn10(:,:,t) = inv(Jj10);
    end
    if(model11 == 1) %d-q/E/Ldq
        A81(1,2) = Lq*dt/Ld*ome;
        A81(1,3) = Lq*dt/Ld*iq;
        A81(2,1) = -Ld*dt/Lq*ome;
        A81(2,3) = -Ld*dt/Lq*id-psipm*dt/Lq;
        A81(3,1) = kp*pp*pp*dt*(Ld-Lq)/J*iq;
        A81(3,2) = kp*pp*pp*dt/J*((Ld-Lq)*id+psipm);    
        
        D11 = A81'*iQ4*A81 + D11_cor11;
        D12 = -A81'*iQ4;
        D21 = D12';
        D22 = iQ4 + C4'*iR*C4;
    
        Jj11 = D22 - D21/(Jj11 + D11)*D12;
        iJn11(:,:,t) = inv(Jj11);
    end
    if(model12 == 1) %5sc/E/Ldq
        A92(1, 1) = 1.0 + dt*(-Rs*(1/2*(1 - e2q4*ch2t)/Lq + 1/2*(1 + e2q4*ch2t)/Ld) + hom*sht*cht*e2q4*(Ld/Lq - Lq/Ld));
        A92(1, 2) = dt*(-hom + Rs*sht*cht*e2q4*(1/Lq - 1/Ld) + hom*(Ld*1/2*(1 - e2q4*ch2t)/Lq + Lq*1/2*(1 + e2q4*ch2t)/Ld));
        A92(1, 3) = dt*psi*sht*e05q4/Lq + dt*hia*sht*cht*e2q4*(Ld/Lq - Lq/Ld) + dt*hib*(-1 + Ld/Lq*1/2*(1 - e2q4*ch2t) + Lq/Ld*1/2*(1 + e2q4*ch2t));
        A92(1, 4) = dt*psi*hom/Lq + dt*hia*(-Rs*2*sht*e05q4/Lq + hom*cht*e05q4*(Ld/Lq - Lq/Ld)) + dt*hib*(Rs*cht*e05q4*(1/Lq - 1/Ld) + hom*2*Ld*sht*e05q4/Lq);
        A92(1, 5) = dt*hia*(-Rs*2*cht*e05q4/Ld + hom*sht*e05q4*(Ld/Lq - Lq/Ld)) + dt*hib*(Rs*sht*e05q4*(1/Lq - 1/Ld) + hom*2*Lq*cht*e05q4/Ld);

        A92(2, 1) = dt*(hom + Rs*sht*cht*e2q4*(1/Lq - 1/Ld) - hom*(Lq*1/2*(1 - e2q4*ch2t)/Ld + Ld*1/2*(1 + e2q4*ch2t)/Lq));
        A92(2, 2) = 1 + dt*(-Rs*(1/2*(1 - e2q4*ch2t)/Ld + 1/2*(1 + e2q4*ch2t)/Lq) + hom*sht*cht*e2q4*(Lq/Ld - Ld/Lq));
        A92(2, 3) = -dt*psi*cht*e05q4/Lq + dt*hia*(1 - Lq*1/2*(1 - e2q4*ch2t)/Ld - Ld*1/2*(1 + e2q4*ch2t)/Lq) + dt*hib*sht*cht*e2q4*(Lq/Ld - Ld/Lq);
        A92(2, 4) = dt*hia*(Rs*cht*e05q4*(1/Lq - 1/Ld) - hom*2*Lq*sht*e05q4/Ld) + dt*hib*(-Rs*2*sht*e05q4/Ld + hom*cht*e05q4*(Lq/Ld - Ld/Lq));
        A92(2, 5) = -dt*psi*hom/Lq + dt*hia*(Rs*sht*e05q4*(1/Lq - 1/Ld) -hom*2*Ld*cht*e05q4/Lq) + dt*hib*(-Rs*2*cht*e05q4/Lq + hom*sht*e05q4*(Lq/Ld - Ld/Lq));

        A92(3, 1) = dt*kpp/J*((Ld - Lq)*(-2*hia*sht*cht*e2q4 + hib*1/2*(1 + e2q4*ch2t) - hib*1/2*(1 - e2q4*ch2t)) - psi*sht*e05q4);
        A92(3, 2) = dt*kpp/J*((Ld - Lq)*(hia*1/2*(1 + e2q4*ch2t) - hia*1/2*(1 - e2q4*ch2t) + 2*hib*sht*cht*e2q4) + psi*cht*e05q4);
        A92(3, 3) = 1;
        A92(3, 4) = dt*kpp/J*((Ld - Lq)*(-(hia^2 + q1)*cht*e05q4 - hia*hib*2*sht*e05q4 + (hib^2 + q2)*cht*e05q4) - psi*hia);
        A92(3, 5) = dt*kpp/J*((Ld - Lq)*(-(hia^2 + q1)*sht*e05q4 + hia*hib*2*cht*e05q4 + (hib^2 + q2)*sht*e05q4) + psi*hib);

        A92(4,3) = dt*cht*e05q4;
        A92(4,5) = dt*hom;
        A92(5,3) = -dt*sht*e05q4;
        A92(5,4) = -dt*hom;
        
        D11 = zeros(5);
        D11(1,1) = 1/q1 + (dt^2*(hom^2 + q3))/q2 + (Rs^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2)/(Ld^2*q1) + (Rs^2*dt^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) - (2*Rs*(cht^2 + q5)*dt)/(Ld*q1) - (2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/q2 - (2*Rs*dt*(sht^2 + q4))/(Lq*q1) + (dt^2*kpp^2*psi^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*(cht^2 + q5)*dt^2*(hom^2 + q3))/(Lq*q2) - (2*Lq*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Ld*q2) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hom^2 + q3))/(Lq^2*q2) + (Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld^2*q2) + (Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Lq^2*q2) + (Lq^2*dt^2*(hom^2 + q3)*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) - (2*Rs*cht*dt^2*hom*sht)/(Ld*q2) + (2*Rs*cht*dt^2*hom*sht)/(Lq*q2) + (2*Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld*Lq*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld*Lq*q2) + (2*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Ld*q1) - (2*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Ld*q2) - (2*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Lq*q1) + (2*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Lq*q2) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hib^2 + q2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hib^2 + q2)*kpp^2)/(J^2*q3) + (Ld^2*dt^2*(hib^2 + q2)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (Lq^2*dt^2*(hib^2 + q2)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) + (2*Ld*cht*dt*hom*sht)/(Lq*q1) - (2*Lq*cht*dt*hom*sht)/(Ld*q1) + (2*Ld*dt^2*hib*kpp^2*psi*(sht^3 + 3*sht*q4))/(J^2*q3) - (2*Lq*dt^2*hib*kpp^2*psi*(sht^3 + 3*sht*q4))/(J^2*q3) + (4*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hib^2 + q2)*kpp^2)/(J^2*q3) - (2*Ld*Lq*dt^2*(hib^2 + q2)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) - (2*Ld*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (2*Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Ld^2*q1) - (2*Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Lq^2*q2) + (2*Lq*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (4*Ld^2*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (4*Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3) + (4*Lq^2*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (4*Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3) - (8*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Ld*Lq*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Ld*cht*dt^2*hia*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (2*Ld*(cht^2 + q5)*dt^2*hib*kpp^2*psi*sht)/(J^2*q3) - (4*Lq*cht*dt^2*hia*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (2*Lq*(cht^2 + q5)*dt^2*hib*kpp^2*psi*sht)/(J^2*q3) - (8*Ld*Lq*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (8*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3);
        D11(1,2) = (dt*hom)/q2 - (dt*hom)/q1 - (cht*dt^2*(hom^2 + q3)*(sht^3 + 3*sht*q4))/q1 + ((cht^3 + 3*cht*q5)*dt^2*(hom^2 + q3)*sht)/q1 + (cht*dt^2*(hom^2 + q3)*(sht^3 + 3*sht*q4))/q2 - ((cht^3 + 3*cht*q5)*dt^2*(hom^2 + q3)*sht)/q2 + (Rs*(cht^2 + q5)*dt^2*hom)/(Ld*q1) - (Rs*(cht^2 + q5)*dt^2*hom)/(Lq*q2) - (Rs*dt^2*hom*(sht^2 + q4))/(Ld*q2) + (Rs*dt^2*hom*(sht^2 + q4))/(Lq*q1) - (Rs*cht*dt*sht)/(Ld*q1) - (Rs*cht*dt*sht)/(Ld*q2) + (Rs*cht*dt*sht)/(Lq*q1) + (Rs*cht*dt*sht)/(Lq*q2) + (Rs^2*(cht^3 + 3*cht*q5)*dt^2*sht)/(Ld^2*q1) + (Rs^2*cht*dt^2*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (Rs^2*cht*dt^2*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Rs^2*(cht^3 + 3*cht*q5)*dt^2*sht)/(Lq^2*q2) + (Lq*(cht^2 + q5)*dt*hom)/(Ld*q1) - (Ld*(cht^2 + q5)*dt*hom)/(Lq*q2) + (Ld*dt*hom*(sht^2 + q4))/(Lq*q1) - (Lq*dt*hom*(sht^2 + q4))/(Ld*q2) - (cht*dt^2*kpp^2*psi^2*sht)/(J^2*q3) + (Rs^2*cht*dt^2*(sht^3 + 3*sht*q4))/(Ld*Lq*q1) - (Rs^2*(cht^3 + 3*cht*q5)*dt^2*sht)/(Ld*Lq*q1) - (Rs^2*cht*dt^2*(sht^3 + 3*sht*q4))/(Ld*Lq*q2) + (Rs^2*(cht^3 + 3*cht*q5)*dt^2*sht)/(Ld*Lq*q2) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hom^2 + q3)*sht)/(Ld^2*q1) + (Ld^2*cht*dt^2*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq^2*cht*dt^2*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hom^2 + q3)*sht)/(Lq^2*q2) - (Lq*Rs*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hom)/(Ld^2*q1) + (Ld*Rs*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hom)/(Lq^2*q2) - (Ld*Rs*dt^2*hom*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) + (Lq*Rs*dt^2*hom*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) - (Ld*cht*dt^2*(hom^2 + q3)*sht)/(Lq*q1) + (Lq*cht*dt^2*(hom^2 + q3)*sht)/(Ld*q1) - (Ld*cht*dt^2*(hom^2 + q3)*sht)/(Lq*q2) + (Lq*cht*dt^2*(hom^2 + q3)*sht)/(Ld*q2) - (2*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Ld*q1) + (2*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Ld*q2) - (2*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Lq*q1) + (2*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Lq*q2) + (2*Ld^2*cht*dt^2*(hia^2 + q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*kpp^2*sht)/(J^2*q3) - (2*Ld^2*cht*dt^2*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) + (2*Lq^2*cht*dt^2*(hia^2 + q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*kpp^2*sht)/(J^2*q3) - (2*Lq^2*cht*dt^2*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) + (Ld*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Ld^2*q1) - (Ld*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Lq^2*q2) - (Lq*Rs*(cht^2 + q5)*dt^2*hom*(sht^2 + q4))/(Ld^2*q2) + (Ld*(cht^3 + 3*cht*q5)*dt^2*hib*kpp^2*psi)/(J^2*q3) - (Lq*(cht^3 + 3*cht*q5)*dt^2*hib*kpp^2*psi)/(J^2*q3) + (Ld*dt^2*hia*kpp^2*psi*(sht^3 + 3*sht*q4))/(J^2*q3) - (Lq*dt^2*hia*kpp^2*psi*(sht^3 + 3*sht*q4))/(J^2*q3) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hia*hib*kpp^2)/(J^2*q3) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hia*hib*kpp^2)/(J^2*q3) + (Ld^2*dt^2*hia*hib*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (Lq^2*dt^2*hia*hib*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) - (4*Ld*Lq*cht*dt^2*(hia^2 + q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (4*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*kpp^2*sht)/(J^2*q3) + (4*Ld*Lq*cht*dt^2*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (4*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) - (6*Ld^2*(cht^2 + q5)*dt^2*hia*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (6*Lq^2*(cht^2 + q5)*dt^2*hia*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hia*hib*kpp^2)/(J^2*q3) - (2*Ld*Lq*dt^2*hia*hib*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) - (3*Ld*(cht^2 + q5)*dt^2*hia*kpp^2*psi*sht)/(J^2*q3) - (3*Ld*cht*dt^2*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (3*Lq*(cht^2 + q5)*dt^2*hia*kpp^2*psi*sht)/(J^2*q3) + (3*Lq*cht*dt^2*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (12*Ld*Lq*(cht^2 + q5)*dt^2*hia*hib*kpp^2*(sht^2 + q4))/(J^2*q3);
        D11(1,3) = (dt^2*hia*hom)/q2 - (dt*hib)/q1 + (dt*psi*sht)/(Lq*q1) - (cht*dt^2*hib*hom*(sht^3 + 3*sht*q4))/q1 + ((cht^3 + 3*cht*q5)*dt^2*hib*hom*sht)/q1 + (cht*dt^2*hib*hom*(sht^3 + 3*sht*q4))/q2 - ((cht^3 + 3*cht*q5)*dt^2*hib*hom*sht)/q2 + (Rs*(cht^2 + q5)*dt^2*hib)/(Ld*q1) + (Rs*dt^2*hib*(sht^2 + q4))/(Lq*q1) - (Rs*dt^2*psi*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (2*(cht^2 + q5)*dt^2*hia*hom*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*hia*hom*(sht^2 + q4))/q2 - (dt*kpp*psi*sht)/(J*q3) + (Lq*(cht^2 + q5)*dt*hib)/(Ld*q1) + (Ld*dt*hib*(sht^2 + q4))/(Lq*q1) - (cht*dt^2*hom*psi)/(Lq*q2) + (Ld*(cht^2 + q5)*dt*hib*kpp)/(J*q3) - (Lq*(cht^2 + q5)*dt*hib*kpp)/(J*q3) - (Ld*dt*hib*kpp*(sht^2 + q4))/(J*q3) + (Lq*dt*hib*kpp*(sht^2 + q4))/(J*q3) - (Rs*cht*dt^2*hia*sht)/(Ld*q2) + (Rs*cht*dt^2*hia*sht)/(Lq*q2) - (Lq*Rs*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hib)/(Ld^2*q1) - (Ld*Rs*dt^2*hib*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) - (2*Ld*(cht^2 + q5)*dt^2*hia*hom)/(Lq*q2) + (Ld*(cht^3 + 3*cht*q5)*dt^2*hom*psi)/(Lq^2*q2) + (Rs*cht*dt^2*hia*(sht^3 + 3*sht*q4))/(Ld*q1) - (Rs*cht*dt^2*hia*(sht^3 + 3*sht*q4))/(Ld*q2) - (Rs*(cht^3 + 3*cht*q5)*dt^2*hia*sht)/(Lq*q1) + (Rs*(cht^3 + 3*cht*q5)*dt^2*hia*sht)/(Lq*q2) - (2*Lq*dt^2*hia*hom*(sht^2 + q4))/(Ld*q2) - (Rs*(cht^2 + q5)*dt^2*psi*sht)/(Lq^2*q2) - (cht*dt^2*hom*psi*(sht^2 + q4))/(Ld*q1) + (cht*dt^2*hom*psi*(sht^2 + q4))/(Ld*q2) + (Ld*cht*dt*hia*sht)/(Lq*q1) - (Lq*cht*dt*hia*sht)/(Ld*q1) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hia*hom)/(Lq^2*q2) - (Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Ld*q1) + (Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Ld*q2) - (Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Lq*q1) + (Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Lq*q2) + (Lq^2*dt^2*hia*hom*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) + (Ld*cht*dt^2*hom*psi*(sht^2 + q4))/(Lq^2*q1) - (2*Ld*cht*dt*hia*kpp*sht)/(J*q3) + (2*Lq*cht*dt*hia*kpp*sht)/(J*q3) - (Ld*Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Lq^2*q2) - (Lq*Rs*(cht^2 + q5)*dt^2*hib*(sht^2 + q4))/(Ld^2*q2) - (Rs*(cht^2 + q5)*dt^2*psi*sht)/(Ld*Lq*q1) + (Rs*(cht^2 + q5)*dt^2*psi*sht)/(Ld*Lq*q2) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*hib*hom*sht)/(Ld^2*q1) + (Ld^2*cht*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq^2*cht*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*hib*hom*sht)/(Lq^2*q2) - (Ld*cht*dt^2*hib*hom*sht)/(Lq*q1) + (Lq*cht*dt^2*hib*hom*sht)/(Ld*q1) - (Ld*cht*dt^2*hib*hom*sht)/(Lq*q2) + (Lq*cht*dt^2*hib*hom*sht)/(Ld*q2) + (Lq^2*(cht^2 + q5)*dt^2*hia*hom*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*hia*hom*(sht^2 + q4))/(Lq^2*q1) - (Ld*Rs*cht*dt^2*hia*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*sht)/(Ld^2*q1) - (Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*sht)/(Lq^2*q2) + (Lq*Rs*cht*dt^2*hia*(sht^3 + 3*sht*q4))/(Ld^2*q2);
        D11(1,4) = (dt*hom*psi)/(Lq*q1) - ((cht^3 + 3*cht*q5)*dt^2*hib*(hom^2 + q3))/q2 - (Rs*cht*dt*hib)/(Ld*q1) + (Rs*cht*dt*hib)/(Lq*q1) - (2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/q1 - (2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/q2 + (cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/q2 - (2*Rs*dt*hia*sht)/(Lq*q1) + (Rs^2*(cht^3 + 3*cht*q5)*dt^2*hib)/(Ld^2*q1) + (2*Rs^2*dt^2*hia*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (dt^2*hia*kpp^2*psi^2*sht)/(J^2*q3) - (Rs^2*(cht^3 + 3*cht*q5)*dt^2*hib)/(Ld*Lq*q1) - (Rs*cht*dt^2*hia*hom)/(Ld*q2) + (Rs*cht*dt^2*hia*hom)/(Lq*q2) - (2*Rs*dt^2*hib*hom*sht)/(Ld*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*hib*(hom^2 + q3))/(Lq^2*q2) + (2*Lq^2*dt^2*hia*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (Ld*cht*dt^2*hib*(hom^2 + q3))/(Lq*q2) + (Lq*cht*dt^2*hib*(hom^2 + q3))/(Ld*q2) - (Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Lq*q1) + (Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Lq*q2) - (2*Lq*dt^2*hia*(hom^2 + q3)*sht)/(Ld*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) - (Rs*dt^2*hom*psi*(sht^2 + q4))/(Lq^2*q1) - (cht*dt^2*(hom^2 + q3)*psi*sht)/(Ld*q1) + (Ld*cht*dt*hia*hom)/(Lq*q1) - (Lq*cht*dt*hia*hom)/(Ld*q1) + (2*Ld*dt*hib*hom*sht)/(Lq*q1) + (Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld^2*q2) + (2*Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld^2*q2) - (Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Lq^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Lq^2*q2) + (3*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld*q1) - (Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld*q1) - (3*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld*q2) + (Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld*q2) - (3*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Lq*q1) + (3*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Lq*q2) + (Ld*cht*dt^2*(hom^2 + q3)*psi*sht)/(Lq^2*q1) - (Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) + (2*Ld^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) - (Ld^2*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Lq^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) - (Lq^2*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Ld^2*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Lq^2*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (Rs*(cht^2 + q5)*dt^2*hom*psi)/(Ld*Lq*q1) - (2*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) + (2*Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld*Lq*q1) + (Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld*Lq*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld*Lq*q2) - (2*Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld*Lq*q2) + (Lq^2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/(Lq^2*q1) + (2*Ld^2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) - (Lq^2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Ld^2*q1) - (Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Lq^2*q2) - (2*Ld*Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (4*Ld*Lq*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) + (2*Ld*Lq*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Ld*Lq*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (3*Ld*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Lq^2*q1) + (Ld*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Lq^2*q1) + (Lq*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld^2*q1) + (3*Lq*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld^2*q2) - (Ld*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Lq^2*q2) - (Lq*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld^2*q2) + (5*Ld^2*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Ld^2*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) + (5*Lq^2*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Lq^2*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) - (Ld*(cht^2 + q5)*dt^2*hia*hib*kpp^2*psi)/(J^2*q3) + (Lq*(cht^2 + q5)*dt^2*hia*hib*kpp^2*psi)/(J^2*q3) + (3*Ld*cht*dt^2*(hia^2 + q1)*kpp^2*psi*sht)/(J^2*q3) - (Ld*cht*dt^2*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) - (3*Lq*cht*dt^2*(hia^2 + q1)*kpp^2*psi*sht)/(J^2*q3) + (Lq*cht*dt^2*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) + (3*Ld*dt^2*hia*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (3*Lq*dt^2*hia*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (2*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) - (10*Ld*Lq*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) + (8*Ld*Lq*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3);
        D11(1,5) = (dt^2*hib*(hom^2 + q3)*(sht^3 + 3*sht*q4))/q2 - (dt^2*(hom^2 + q3)*psi)/(Lq*q2) - (2*Rs*cht*dt*hia)/(Ld*q1) - (2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/q1 + (2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/q2 - ((cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/q2 - (Rs*dt*hib*sht)/(Ld*q1) + (Rs*dt*hib*sht)/(Lq*q1) + (2*Rs^2*(cht^3 + 3*cht*q5)*dt^2*hia)/(Ld^2*q1) - (Rs^2*dt^2*hib*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (dt^2*(hom^2 + q3)*psi*(sht^2 + q4))/(Ld*q2) - (dt^2*hib*kpp^2*psi^2*sht)/(J^2*q3) - (2*Rs*cht*dt^2*hib*hom)/(Lq*q2) + (Rs^2*dt^2*hib*(sht^3 + 3*sht*q4))/(Ld*Lq*q1) - (Rs*dt^2*hia*hom*sht)/(Ld*q2) + (Rs*dt^2*hia*hom*sht)/(Lq*q2) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hom^2 + q3))/(Lq^2*q2) - (Lq^2*dt^2*hib*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (2*Ld*cht*dt^2*hia*(hom^2 + q3))/(Lq*q2) - (Ld*dt^2*hib*(hom^2 + q3)*sht)/(Lq*q2) + (Lq*dt^2*hib*(hom^2 + q3)*sht)/(Ld*q2) + (Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Ld*q1) - (Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Ld*q2) - (Ld^2*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (Lq^2*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Lq*cht*dt*hib*hom)/(Ld*q1) + (Ld*dt*hia*hom*sht)/(Lq*q1) - (Lq*dt*hia*hom*sht)/(Ld*q1) + (Ld*(cht^2 + q5)*dt^2*(hom^2 + q3)*psi)/(Lq^2*q2) + (Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld^2*q1) + (Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld^2*q2) + (Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Lq^2*q2) - (2*Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Lq^2*q2) - (3*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Ld*q1) + (3*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Ld*q2) - (3*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq*q1) - (Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq*q1) + (3*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq*q2) + (Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq*q2) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (2*Ld^2*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Ld^2*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (2*Lq^2*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (Ld^2*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (Lq^2*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Ld*Lq*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld*Lq*q1) - (Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld*Lq*q1) - (2*Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld*Lq*q2) + (2*Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld*Lq*q2) - (Rs*cht*dt^2*hom*psi*sht)/(Lq^2*q2) + (Ld*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) - (Lq*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) + (Lq^2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) - (2*Lq^2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/(Lq^2*q2) + (Ld*dt^2*(hia^2 + q1)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (2*Ld*dt^2*(hib^2 + q2)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (Lq*dt^2*(hia^2 + q1)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (2*Lq*dt^2*(hib^2 + q2)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (2*Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Ld^2*q1) + (2*Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Lq^2*q2) - (Ld*Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (Lq*Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (4*Ld*Lq*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) - (2*Ld*Lq*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (3*Lq*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Ld^2*q1) + (Ld*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Ld^2*q1) - (3*Ld*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq^2*q2) - (Ld*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq^2*q2) - (Lq*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Ld^2*q2) + (Rs*cht*dt^2*hom*psi*sht)/(Ld*Lq*q2) - (4*Ld^2*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (5*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (4*Lq^2*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (5*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (4*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (8*Ld*Lq*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (10*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (4*Ld*cht*dt^2*hia*hib*kpp^2*psi*sht)/(J^2*q3) + (4*Lq*cht*dt^2*hia*hib*kpp^2*psi*sht)/(J^2*q3);

        D11(2,1) = D11(1,2);
        D11(2,2) = 1/q2 + (dt^2*(hom^2 + q3))/q1 + (Rs^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2)/(Lq^2*q2) + (Rs^2*dt^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) - (2*Rs*(cht^2 + q5)*dt)/(Lq*q2) + (2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/q1 - (2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/q2 - (2*Rs*dt*(sht^2 + q4))/(Ld*q2) - (2*Lq*(cht^2 + q5)*dt^2*(hom^2 + q3))/(Ld*q1) - (2*Ld*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Lq*q1) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hom^2 + q3))/(Ld^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Lq^2*q1) + (Ld^2*dt^2*(hom^2 + q3)*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) + ((cht^2 + q5)*dt^2*kpp^2*psi^2)/(J^2*q3) + (2*Rs*cht*dt^2*hom*sht)/(Ld*q1) - (2*Rs*cht*dt^2*hom*sht)/(Lq*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld*Lq*q1) + (2*Rs^2*(cht^2 + q5)*dt^2*(sht^2 + q4))/(Ld*Lq*q2) + (2*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Ld*q1) - (2*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Ld*q2) - (2*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Lq*q1) + (2*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Lq*q2) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hia^2 + q1)*kpp^2)/(J^2*q3) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hia^2 + q1)*kpp^2)/(J^2*q3) + (Ld^2*dt^2*(hia^2 + q1)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (Lq^2*dt^2*(hia^2 + q1)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q2) - (2*Ld*cht*dt*hom*sht)/(Lq*q2) + (2*Lq*cht*dt*hom*sht)/(Ld*q2) + (2*Ld*(cht^3 + 3*cht*q5)*dt^2*hia*kpp^2*psi)/(J^2*q3) - (2*Lq*(cht^3 + 3*cht*q5)*dt^2*hia*kpp^2*psi)/(J^2*q3) - (2*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Ld^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hia^2 + q1)*kpp^2)/(J^2*q3) - (2*Ld*Lq*dt^2*(hia^2 + q1)*kpp^2*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(J^2*q3) + (2*Ld*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (2*Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Ld^2*q1) + (2*Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hom*sht)/(Lq^2*q2) - (2*Lq*Rs*cht*dt^2*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (4*Ld^2*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (4*Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3) - (4*Lq^2*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (4*Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3) + (4*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*(sht^2 + q4))/(J^2*q3) - (8*Ld*Lq*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*cht*dt^2*hia*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (4*Ld*(cht^2 + q5)*dt^2*hib*kpp^2*psi*sht)/(J^2*q3) + (2*Lq*cht*dt^2*hia*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (4*Lq*(cht^2 + q5)*dt^2*hib*kpp^2*psi*sht)/(J^2*q3) + (8*Ld*Lq*cht*dt^2*hia*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (8*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*hia*hib*kpp^2*sht)/(J^2*q3);
        D11(2,3) = (dt*hia)/q2 + (dt^2*hib*hom)/q1 - (cht*dt*psi)/(Lq*q2) - (cht*dt^2*hia*hom*(sht^3 + 3*sht*q4))/q1 + ((cht^3 + 3*cht*q5)*dt^2*hia*hom*sht)/q1 + (cht*dt^2*hia*hom*(sht^3 + 3*sht*q4))/q2 - ((cht^3 + 3*cht*q5)*dt^2*hia*hom*sht)/q2 - (Rs*(cht^2 + q5)*dt^2*hia)/(Lq*q2) + (Rs*(cht^3 + 3*cht*q5)*dt^2*psi)/(Lq^2*q2) - (Rs*dt^2*hia*(sht^2 + q4))/(Ld*q2) + (2*(cht^2 + q5)*dt^2*hib*hom*(sht^2 + q4))/q1 - (2*(cht^2 + q5)*dt^2*hib*hom*(sht^2 + q4))/q2 + (cht*dt*kpp*psi)/(J*q3) - (Ld*(cht^2 + q5)*dt*hia)/(Lq*q2) - (Lq*dt*hia*(sht^2 + q4))/(Ld*q2) - (dt^2*hom*psi*sht)/(Lq*q1) + (Ld*(cht^2 + q5)*dt*hia*kpp)/(J*q3) - (Lq*(cht^2 + q5)*dt*hia*kpp)/(J*q3) - (Ld*dt*hia*kpp*(sht^2 + q4))/(J*q3) + (Lq*dt*hia*kpp*(sht^2 + q4))/(J*q3) + (Rs*cht*dt^2*hib*sht)/(Ld*q1) - (Rs*cht*dt^2*hib*sht)/(Lq*q1) + (Ld*Rs*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hia)/(Lq^2*q2) + (Lq*Rs*dt^2*hia*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) - (2*Lq*(cht^2 + q5)*dt^2*hib*hom)/(Ld*q1) + (Rs*(cht^3 + 3*cht*q5)*dt^2*hib*sht)/(Ld*q1) - (Rs*(cht^3 + 3*cht*q5)*dt^2*hib*sht)/(Ld*q2) - (Rs*cht*dt^2*hib*(sht^3 + 3*sht*q4))/(Lq*q1) + (Rs*cht*dt^2*hib*(sht^3 + 3*sht*q4))/(Lq*q2) - (2*Ld*dt^2*hib*hom*(sht^2 + q4))/(Lq*q1) + (Rs*cht*dt^2*psi*(sht^2 + q4))/(Lq^2*q1) + (Ld*dt^2*hom*psi*(sht^3 + 3*sht*q4))/(Lq^2*q1) + ((cht^2 + q5)*dt^2*hom*psi*sht)/(Ld*q1) - ((cht^2 + q5)*dt^2*hom*psi*sht)/(Ld*q2) - (Ld*cht*dt*hib*sht)/(Lq*q2) + (Lq*cht*dt*hib*sht)/(Ld*q2) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*hib*hom)/(Ld^2*q1) - (Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Ld*q1) + (Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Ld*q2) - (Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Lq*q1) + (Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Lq*q2) + (Ld^2*dt^2*hib*hom*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) + (Ld*(cht^2 + q5)*dt^2*hom*psi*sht)/(Lq^2*q2) + (2*Ld*cht*dt*hib*kpp*sht)/(J*q3) - (2*Lq*cht*dt*hib*kpp*sht)/(J*q3) + (Ld*Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*(cht^2 + q5)*dt^2*hia*(sht^2 + q4))/(Ld^2*q1) - (Rs*cht*dt^2*psi*(sht^2 + q4))/(Ld*Lq*q1) + (Rs*cht*dt^2*psi*(sht^2 + q4))/(Ld*Lq*q2) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*hom*sht)/(Ld^2*q1) + (Ld^2*cht*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq^2*cht*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*hom*sht)/(Lq^2*q2) - (Ld*cht*dt^2*hia*hom*sht)/(Lq*q1) + (Lq*cht*dt^2*hia*hom*sht)/(Ld*q1) - (Ld*cht*dt^2*hia*hom*sht)/(Lq*q2) + (Lq*cht*dt^2*hia*hom*sht)/(Ld*q2) + (Lq^2*(cht^2 + q5)*dt^2*hib*hom*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*hib*hom*(sht^2 + q4))/(Lq^2*q2) + (Ld*Rs*cht*dt^2*hib*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*sht)/(Ld^2*q1) + (Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*sht)/(Lq^2*q2) - (Lq*Rs*cht*dt^2*hib*(sht^3 + 3*sht*q4))/(Ld^2*q2);
        D11(2,4) = ((cht^3 + 3*cht*q5)*dt^2*hia*(hom^2 + q3))/q1 - (dt^2*(hom^2 + q3)*psi)/(Lq*q1) - (Rs*cht*dt*hia)/(Ld*q2) + (Rs*cht*dt*hia)/(Lq*q2) - (cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/q1 + (2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/q2 - (2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/q2 - (2*Rs*dt*hib*sht)/(Ld*q2) - (Rs^2*(cht^3 + 3*cht*q5)*dt^2*hia)/(Lq^2*q2) + (2*Rs^2*dt^2*hib*(sht^3 + 3*sht*q4))/(Ld^2*q2) + ((cht^2 + q5)*dt^2*(hom^2 + q3)*psi)/(Ld*q1) - (cht*dt^2*hia*kpp^2*psi^2)/(J^2*q3) + (Rs^2*(cht^3 + 3*cht*q5)*dt^2*hia)/(Ld*Lq*q2) + (Rs*cht*dt^2*hib*hom)/(Ld*q1) - (Rs*cht*dt^2*hib*hom)/(Lq*q1) + (2*Rs*dt^2*hia*hom*sht)/(Lq*q1) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hom^2 + q3))/(Ld^2*q1) + (2*Ld^2*dt^2*hib*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Ld*cht*dt^2*hia*(hom^2 + q3))/(Lq*q1) + (Lq*cht*dt^2*hia*(hom^2 + q3))/(Ld*q1) + (Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Ld*q1) - (Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Ld*q2) - (2*Ld*dt^2*hib*(hom^2 + q3)*sht)/(Lq*q1) - (Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2)/(J^2*q3) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2)/(J^2*q3) - (Ld*cht*dt*hib*hom)/(Lq*q2) + (Lq*cht*dt*hib*hom)/(Ld*q2) - (2*Lq*dt*hia*hom*sht)/(Ld*q2) + (Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld^2*q1) + (Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld^2*q2) - (2*Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Lq^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Lq^2*q1) + (Ld*dt^2*(hom^2 + q3)*psi*(sht^2 + q4))/(Lq^2*q1) - (3*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Ld*q1) + (3*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Ld*q2) - (Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq*q1) - (3*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq*q1) + (Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq*q2) + (3*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq*q2) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (Ld^2*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Ld^2*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (Lq^2*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Lq^2*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (2*Ld^2*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Lq^2*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (2*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2)/(J^2*q3) + (2*Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld*Lq*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld*Lq*q1) - (Rs^2*cht*dt^2*hia*(sht^2 + q4))/(Ld*Lq*q2) + (2*Rs^2*(cht^2 + q5)*dt^2*hib*sht)/(Ld*Lq*q2) + (Rs*cht*dt^2*hom*psi*sht)/(Lq^2*q1) - (2*Ld*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*psi)/(J^2*q3) + (Ld*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) + (2*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*kpp^2*psi)/(J^2*q3) - (Lq*(cht^2 + q5)*dt^2*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) + (Ld^2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) - (2*Lq^2*cht*dt^2*hia*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Lq^2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*hib*(hom^2 + q3)*sht)/(Lq^2*q2) + (Ld*dt^2*(hia^2 + q1)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (Lq*dt^2*(hia^2 + q1)*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Ld^2*q1) + (Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hib*hom)/(Lq^2*q2) - (2*Ld*Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hia*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (2*Ld*Lq*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Ld*Lq*(cht^2 + q5)*dt^2*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) - (4*Ld*Lq*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (Ld*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq^2*q1) + (Lq*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Ld^2*q1) + (3*Ld*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Lq^2*q1) - (Ld*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Lq^2*q2) - (Lq*Rs*(cht^2 + q5)*dt^2*hia*hom*sht)/(Ld^2*q2) - (3*Lq*Rs*cht*dt^2*hib*hom*(sht^2 + q4))/(Ld^2*q2) - (Rs*cht*dt^2*hom*psi*sht)/(Ld*Lq*q1) - (5*Ld^2*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (5*Lq^2*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (2*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*hia*(hib^2 + q2)*kpp^2)/(J^2*q3) + (10*Ld*Lq*cht*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (8*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*hib*kpp^2*sht)/(J^2*q3) - (4*Ld*cht*dt^2*hia*hib*kpp^2*psi*sht)/(J^2*q3) + (4*Lq*cht*dt^2*hia*hib*kpp^2*psi*sht)/(J^2*q3);
        D11(2,5) = ((cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/q1 - (dt^2*hia*(hom^2 + q3)*(sht^3 + 3*sht*q4))/q1 - (2*Rs*cht*dt*hib)/(Lq*q2) - (dt*hom*psi)/(Lq*q2) + (2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/q1 - (2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/q2 - (2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/q2 - (Rs*dt*hia*sht)/(Ld*q2) + (Rs*dt*hia*sht)/(Lq*q2) + (2*Rs^2*(cht^3 + 3*cht*q5)*dt^2*hib)/(Lq^2*q2) + (Rs^2*dt^2*hia*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (cht*dt^2*hib*kpp^2*psi^2)/(J^2*q3) + (2*Rs*cht*dt^2*hia*hom)/(Ld*q1) - (Rs^2*dt^2*hia*(sht^3 + 3*sht*q4))/(Ld*Lq*q2) + (Rs*dt^2*hib*hom*sht)/(Ld*q1) - (Rs*dt^2*hib*hom*sht)/(Lq*q1) + (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*hib*(hom^2 + q3))/(Ld^2*q1) + (Ld^2*dt^2*hia*(hom^2 + q3)*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (2*Lq*cht*dt^2*hib*(hom^2 + q3))/(Ld*q1) + (Rs*(cht^2 + q5)*dt^2*hom*psi)/(Lq^2*q2) - (Ld*dt^2*hia*(hom^2 + q3)*sht)/(Lq*q1) + (Lq*dt^2*hia*(hom^2 + q3)*sht)/(Ld*q1) - (Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Lq*q1) + (Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Lq*q2) + (Ld^2*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (Lq^2*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (cht*dt^2*(hom^2 + q3)*psi*sht)/(Ld*q2) - (2*Ld*cht*dt*hia*hom)/(Lq*q2) - (Ld*dt*hib*hom*sht)/(Lq*q2) + (Lq*dt*hib*hom*sht)/(Ld*q2) + (2*Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld^2*q1) + (Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld^2*q1) + (Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Lq^2*q1) - (Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Lq^2*q2) - (Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld*q1) + (3*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld*q1) + (Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld*q2) - (3*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld*q2) - (3*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Lq*q1) + (3*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Lq*q2) + (Ld*cht*dt^2*(hom^2 + q3)*psi*sht)/(Lq^2*q2) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) + (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) - (Ld^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) + (2*Ld^2*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (Lq^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) + (2*Lq^2*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (Ld^2*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (Lq^2*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (Rs*dt^2*hom*psi*(sht^2 + q4))/(Ld*Lq*q2) - (2*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) - (2*Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld*Lq*q1) - (2*Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld*Lq*q1) + (Rs^2*(cht^2 + q5)*dt^2*hia*sht)/(Ld*Lq*q2) + (2*Rs^2*cht*dt^2*hib*(sht^2 + q4))/(Ld*Lq*q2) - (Lq^2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/(Ld^2*q1) + (2*Ld^2*(cht^2 + q5)*dt^2*hia*(hom^2 + q3)*sht)/(Lq^2*q2) + (Lq^2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*cht*dt^2*hib*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q2) - (2*Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Ld^2*q1) + (2*Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hom)/(Lq^2*q2) + (Ld*Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq*Rs*dt^2*hib*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (2*Ld*Lq*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*kpp^2*sht)/(J^2*q3) - (4*Ld*Lq*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Ld*Lq*dt^2*hia*(hib^2 + q2)*kpp^2*(sht^3 + 3*sht*q4))/(J^2*q3) + (Ld*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld^2*q1) - (3*Lq*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Ld^2*q1) - (Ld*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Lq^2*q2) - (Lq*Rs*cht*dt^2*hia*hom*(sht^2 + q4))/(Ld^2*q2) + (3*Ld*Rs*(cht^2 + q5)*dt^2*hib*hom*sht)/(Lq^2*q2) - (4*Ld^2*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) + (5*Ld^2*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) - (4*Lq^2*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) + (5*Lq^2*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) + (3*Ld*(cht^2 + q5)*dt^2*hia*hib*kpp^2*psi)/(J^2*q3) - (3*Lq*(cht^2 + q5)*dt^2*hia*hib*kpp^2*psi)/(J^2*q3) - (Ld*cht*dt^2*(hia^2 + q1)*kpp^2*psi*sht)/(J^2*q3) + (3*Ld*cht*dt^2*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) + (Lq*cht*dt^2*(hia^2 + q1)*kpp^2*psi*sht)/(J^2*q3) - (3*Lq*cht*dt^2*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) - (Ld*dt^2*hia*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) + (Lq*dt^2*hia*hib*kpp^2*psi*(sht^2 + q4))/(J^2*q3) - (4*Ld*Lq*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hib*kpp^2)/(J^2*q3) + (8*Ld*Lq*cht*dt^2*(hia^2 + q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (10*Ld*Lq*(cht^2 + q5)*dt^2*hia*(hib^2 + q2)*kpp^2*sht)/(J^2*q3);

        D11(3,1) = D11(1,3);
        D11(3,2) = D11(2,3);
        D11(3,3) = 1/q3 + ((cht^2 + q5)*dt^2)/q4 + (dt^2*(hib^2 + q2))/q1 + (dt^2*(hia^2 + q1))/q2 + (dt^2*(sht^2 + q4))/q5 + ((cht^2 + q5)*dt^2*psi^2)/(Lq^2*q2) + (dt^2*psi^2*(sht^2 + q4))/(Lq^2*q1) - (2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(sht^2 + q4))/q1 + (2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(sht^2 + q4))/q2 - (2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(sht^2 + q4))/q2 - (2*Lq*(cht^2 + q5)*dt^2*(hib^2 + q2))/(Ld*q1) - (2*Ld*(cht^2 + q5)*dt^2*(hia^2 + q1))/(Lq*q2) - (2*Ld*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq*q1) - (2*Lq*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld*q2) + (Lq^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hib^2 + q2))/(Ld^2*q1) + (Ld^2*(cht^4 + 6*cht^2*q5 + 3*q5^2)*dt^2*(hia^2 + q1))/(Lq^2*q2) - (2*cht*dt^2*hia*psi)/(Lq*q2) + (Ld^2*dt^2*(hib^2 + q2)*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Lq^2*q1) + (Lq^2*dt^2*(hia^2 + q1)*(sht^4 + 6*sht^2*q4 + 3*q4^2))/(Ld^2*q2) - (2*dt^2*hib*psi*sht)/(Lq*q1) - (2*cht*dt^2*hia*hib*(sht^3 + 3*sht*q4))/q1 + (2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*sht)/q1 + (2*cht*dt^2*hia*hib*(sht^3 + 3*sht*q4))/q2 - (2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*sht)/q2 + (2*Ld*(cht^3 + 3*cht*q5)*dt^2*hia*psi)/(Lq^2*q2) + (2*Ld*dt^2*hib*psi*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Lq^2*q1) + (Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq^2*q2) - (2*cht*dt^2*hia*psi*(sht^2 + q4))/(Ld*q1) + (2*(cht^2 + q5)*dt^2*hib*psi*sht)/(Ld*q1) + (2*cht*dt^2*hia*psi*(sht^2 + q4))/(Ld*q2) - (2*(cht^2 + q5)*dt^2*hib*psi*sht)/(Ld*q2) - (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*sht)/(Ld^2*q1) + (2*Ld^2*cht*dt^2*hia*hib*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (2*Lq^2*cht*dt^2*hia*hib*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*sht)/(Lq^2*q2) - (2*Ld*cht*dt^2*hia*hib*sht)/(Lq*q1) + (2*Lq*cht*dt^2*hia*hib*sht)/(Ld*q1) - (2*Ld*cht*dt^2*hia*hib*sht)/(Lq*q2) + (2*Lq*cht*dt^2*hia*hib*sht)/(Ld*q2) + (2*Ld*cht*dt^2*hia*psi*(sht^2 + q4))/(Lq^2*q1) + (2*Ld*(cht^2 + q5)*dt^2*hib*psi*sht)/(Lq^2*q2);
        D11(3,4) = (cht*dt)/q4 + (dt^2*hom*sht)/q5 + (Rs*cht*dt^2*(hib^2 + q2))/(Ld*q1) - (Rs*cht*dt^2*(hia^2 + q1))/(Ld*q2) - (Rs*cht*dt^2*(hib^2 + q2))/(Lq*q1) + (Rs*cht*dt^2*(hia^2 + q1))/(Lq*q2) + (dt^2*hom*psi^2*sht)/(Lq^2*q1) - (2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom*sht)/q1 + (2*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom*sht)/q1 + (2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom*sht)/q2 - (2*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom*sht)/q2 + (Rs*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2))/(Ld*q1) + (Rs*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1))/(Lq*q2) - (dt*hia*kpp*psi)/(J*q3) - (dt^2*hib*hom*psi)/(Lq*q1) + ((cht^3 + 3*cht*q5)*dt^2*hia*hib*hom)/q1 - ((cht^3 + 3*cht*q5)*dt^2*hia*hib*hom)/q2 - (Ld*cht*dt*(hia^2 + q1)*kpp)/(J*q3) + (Ld*cht*dt*(hib^2 + q2)*kpp)/(J*q3) + (Lq*cht*dt*(hia^2 + q1)*kpp)/(J*q3) - (Lq*cht*dt*(hib^2 + q2)*kpp)/(J*q3) - (2*Rs*dt^2*hia*hib*sht)/(Ld*q2) + (2*Rs*dt^2*hia*hib*sht)/(Lq*q1) + (2*Ld^2*dt^2*(hib^2 + q2)*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (2*Lq^2*dt^2*(hia^2 + q1)*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (3*cht*dt^2*hia*hib*hom*(sht^2 + q4))/q1 + (3*cht*dt^2*hia*hib*hom*(sht^2 + q4))/q2 - (Rs*(cht^2 + q5)*dt^2*hia*psi)/(Lq^2*q2) - (2*Ld*dt^2*(hib^2 + q2)*hom*sht)/(Lq*q1) - (2*Lq*dt^2*(hia^2 + q1)*hom*sht)/(Ld*q2) - (2*Rs*dt^2*hia*psi*(sht^2 + q4))/(Lq^2*q1) + ((cht^2 + q5)*dt^2*hib*hom*psi)/(Ld*q1) - ((cht^2 + q5)*dt^2*hib*hom*psi)/(Ld*q2) - (Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2))/(Ld^2*q1) - (Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1))/(Lq^2*q2) + (2*Rs*cht*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld*q1) - (Rs*cht*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld*q2) - (Rs*cht*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq*q1) + (2*Rs*cht*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq*q2) + (3*Ld*dt^2*hib*hom*psi*(sht^2 + q4))/(Lq^2*q1) + (Rs*(cht^2 + q5)*dt^2*hia*psi)/(Ld*Lq*q2) - (2*Ld*dt*hia*hib*kpp*sht)/(J*q3) + (2*Lq*dt*hia*hib*kpp*sht)/(J*q3) - (2*Ld*Rs*cht*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Lq^2*q1) + (Ld*Rs*cht*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*cht*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld^2*q2) - (2*Lq*Rs*cht*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Ld^2*q2) - (Lq^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*hom)/(Ld^2*q1) + (Ld^2*(cht^3 + 3*cht*q5)*dt^2*hia*hib*hom)/(Lq^2*q2) - (Ld*cht*dt^2*hia*hib*hom)/(Lq*q1) + (Lq*cht*dt^2*hia*hib*hom)/(Ld*q1) - (Ld*cht*dt^2*hia*hib*hom)/(Lq*q2) + (Lq*cht*dt^2*hia*hib*hom)/(Ld*q2) + (Rs*cht*dt^2*hib*psi*sht)/(Lq^2*q1) + (Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom*sht)/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom*sht)/(Lq^2*q1) + (Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom*sht)/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom*sht)/(Lq^2*q2) - (2*cht*dt^2*hia*hom*psi*sht)/(Ld*q1) + (2*cht*dt^2*hia*hom*psi*sht)/(Ld*q2) - (2*Ld*Rs*dt^2*hia*hib*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hia*hib*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (Ld*(cht^2 + q5)*dt^2*hib*hom*psi)/(Lq^2*q2) - (3*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Ld*q1) + (Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Ld*q2) - (Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Lq*q1) + (3*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Lq*q2) + (2*Ld*cht*dt^2*hia*hom*psi*sht)/(Lq^2*q1) + (Ld*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Lq^2*q1) + (Lq*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Ld^2*q1) - (Ld*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Lq^2*q2) - (Lq*Rs*(cht^2 + q5)*dt^2*hia*hib*sht)/(Ld^2*q2) - (Rs*cht*dt^2*hib*psi*sht)/(Ld*Lq*q1) + (2*Rs*cht*dt^2*hib*psi*sht)/(Ld*Lq*q2) + (3*Ld^2*cht*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq^2*q1) - (3*Lq^2*cht*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld^2*q2);
        D11(3,5) = (cht*dt^2*hom)/q4 - (dt*sht)/q5 - (dt^2*hia*hib*hom*(sht^3 + 3*sht*q4))/q1 + (dt^2*hia*hib*hom*(sht^3 + 3*sht*q4))/q2 + (Rs*dt^2*(hib^2 + q2)*sht)/(Ld*q1) - (Rs*dt^2*(hia^2 + q1)*sht)/(Ld*q2) - (Rs*dt^2*(hib^2 + q2)*sht)/(Lq*q1) + (Rs*dt^2*(hia^2 + q1)*sht)/(Lq*q2) + (cht*dt^2*hom*psi^2)/(Lq^2*q2) - (2*cht*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/q1 + (2*cht*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/q1 + (2*cht*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/q2 - (2*cht*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/q2 + (dt*hib*kpp*psi)/(J*q3) - (Rs*dt^2*(hia^2 + q1)*(sht^3 + 3*sht*q4))/(Ld*q2) - (Rs*dt^2*(hib^2 + q2)*(sht^3 + 3*sht*q4))/(Lq*q1) - (dt^2*hia*hom*psi)/(Lq*q2) + (2*Rs*cht*dt^2*hia*hib)/(Ld*q1) - (2*Rs*cht*dt^2*hia*hib)/(Lq*q2) - (Ld*dt*(hia^2 + q1)*kpp*sht)/(J*q3) + (Ld*dt*(hib^2 + q2)*kpp*sht)/(J*q3) + (Lq*dt*(hia^2 + q1)*kpp*sht)/(J*q3) - (Lq*dt*(hib^2 + q2)*kpp*sht)/(J*q3) + (2*Lq^2*(cht^3 + 3*cht*q5)*dt^2*(hib^2 + q2)*hom)/(Ld^2*q1) + (2*Ld^2*(cht^3 + 3*cht*q5)*dt^2*(hia^2 + q1)*hom)/(Lq^2*q2) + (3*(cht^2 + q5)*dt^2*hia*hib*hom*sht)/q1 - (3*(cht^2 + q5)*dt^2*hia*hib*hom*sht)/q2 - (2*Lq*cht*dt^2*(hib^2 + q2)*hom)/(Ld*q1) - (2*Ld*cht*dt^2*(hia^2 + q1)*hom)/(Lq*q2) + (2*Rs*(cht^2 + q5)*dt^2*hib*psi)/(Lq^2*q2) + (Rs*dt^2*hib*psi*(sht^2 + q4))/(Lq^2*q1) - (dt^2*hia*hom*psi*(sht^2 + q4))/(Ld*q1) + (dt^2*hia*hom*psi*(sht^2 + q4))/(Ld*q2) + (Ld*Rs*dt^2*(hib^2 + q2)*(sht^3 + 3*sht*q4))/(Lq^2*q1) + (Lq*Rs*dt^2*(hia^2 + q1)*(sht^3 + 3*sht*q4))/(Ld^2*q2) + (Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*sht)/(Ld*q1) - (2*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*sht)/(Ld*q2) - (2*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*sht)/(Lq*q1) + (Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*sht)/(Lq*q2) + (Ld*dt^2*hia*hom*psi*(sht^2 + q4))/(Lq^2*q1) + (2*Ld*cht*dt*hia*hib*kpp)/(J*q3) - (2*Lq*cht*dt*hia*hib*kpp)/(J*q3) + (2*Lq*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*sht)/(Ld^2*q1) - (Lq*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*sht)/(Ld^2*q1) - (Ld*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*sht)/(Lq^2*q2) + (2*Ld*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*sht)/(Lq^2*q2) - (Rs*dt^2*hib*psi*(sht^2 + q4))/(Ld*Lq*q1) + (Ld^2*dt^2*hia*hib*hom*(sht^3 + 3*sht*q4))/(Lq^2*q1) - (Lq^2*dt^2*hia*hib*hom*(sht^3 + 3*sht*q4))/(Ld^2*q2) - (Ld*dt^2*hia*hib*hom*sht)/(Lq*q1) + (Lq*dt^2*hia*hib*hom*sht)/(Ld*q1) - (Ld*dt^2*hia*hib*hom*sht)/(Lq*q2) + (Lq*dt^2*hia*hib*hom*sht)/(Ld*q2) - (Rs*cht*dt^2*hia*psi*sht)/(Lq^2*q2) + (Lq^2*cht*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*cht*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Lq^2*q1) + (Lq^2*cht*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*cht*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Lq^2*q2) + (2*cht*dt^2*hib*hom*psi*sht)/(Ld*q1) - (2*cht*dt^2*hib*hom*psi*sht)/(Ld*q2) - (2*Lq*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hib)/(Ld^2*q1) + (2*Ld*Rs*(cht^3 + 3*cht*q5)*dt^2*hia*hib)/(Lq^2*q2) + (3*Ld*(cht^2 + q5)*dt^2*hia*hom*psi)/(Lq^2*q2) - (Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Ld*q1) + (3*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Ld*q2) - (3*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Lq*q1) + (Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Lq*q2) + (2*Ld*cht*dt^2*hib*hom*psi*sht)/(Lq^2*q2) + (Ld*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Lq^2*q1) + (Lq*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Ld^2*q1) - (Ld*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Lq^2*q2) - (Lq*Rs*cht*dt^2*hia*hib*(sht^2 + q4))/(Ld^2*q2) - (2*Rs*cht*dt^2*hia*psi*sht)/(Ld*Lq*q1) + (Rs*cht*dt^2*hia*psi*sht)/(Ld*Lq*q2) - (3*Lq^2*(cht^2 + q5)*dt^2*hia*hib*hom*sht)/(Ld^2*q1) + (3*Ld^2*(cht^2 + q5)*dt^2*hia*hib*hom*sht)/(Lq^2*q2);

        D11(4,1) = D11(1,4);
        D11(4,2) = D11(2,4);
        D11(4,3) = D11(3,4);
        D11(4,4) = 1/q4 + (dt^2*(hom^2 + q3))/q5 + (dt^2*(hom^2 + q3)*psi^2)/(Lq^2*q1) - (2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hom^2 + q3))/q1 - (2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(hom^2 + q3))/q2 + (dt^2*(hia^2 + q1)*kpp^2*psi^2)/(J^2*q3) + (Rs^2*(cht^2 + q5)*dt^2*(hib^2 + q2))/(Ld^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*(hia^2 + q1))/(Ld^2*q2) + (Rs^2*(cht^2 + q5)*dt^2*(hib^2 + q2))/(Lq^2*q1) + (Rs^2*(cht^2 + q5)*dt^2*(hia^2 + q1))/(Lq^2*q2) + (4*Rs^2*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Ld^2*q2) + (4*Rs^2*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Lq^2*q1) - (4*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/q1 + (4*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/q2 - (2*Rs^2*(cht^2 + q5)*dt^2*(hib^2 + q2))/(Ld*Lq*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*(hia^2 + q1))/(Ld*Lq*q2) + (Ld^2*(cht^2 + q5)*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2)/(J^2*q3) + (Ld^2*(cht^2 + q5)*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2)/(J^2*q3) + (Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hom^2 + q3))/(Ld^2*q1) + (Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hom^2 + q3))/(Lq^2*q1) + (Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(hom^2 + q3))/(Ld^2*q2) + (Ld^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(hom^2 + q3))/(Lq^2*q2) - (2*cht*dt^2*hia*(hom^2 + q3)*psi)/(Ld*q1) + (4*Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) + (4*Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (4*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Ld*q1) - (4*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Ld*q2) - (4*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Lq*q1) + (4*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Lq*q2) + (4*Ld*dt^2*hib*(hom^2 + q3)*psi*sht)/(Lq^2*q1) + (2*Ld*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*psi)/(J^2*q3) - (2*Lq*cht*dt^2*(hia^3 + 3*hia*q1)*kpp^2*psi)/(J^2*q3) - (2*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) - (2*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) + (4*Ld^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Lq^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*(cht^2 + q5)*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2)/(J^2*q3) - (2*Ld*Lq*(cht^2 + q5)*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2)/(J^2*q3) + (2*Rs*cht*dt^2*hib*hom*psi)/(Lq^2*q1) - (4*Rs*dt^2*hia*hom*psi*sht)/(Lq^2*q1) - (2*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Ld*q1) + (2*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Ld*q2) - (2*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Lq*q1) + (2*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Lq*q2) + (2*Ld*cht*dt^2*hia*(hom^2 + q3)*psi)/(Lq^2*q1) + (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld^2*q2) - (4*Rs^2*cht*dt^2*hia*hib*sht)/(Lq^2*q1) - (4*Ld^2*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (4*Ld^2*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3) - (4*Lq^2*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (4*Lq^2*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3) + (2*Ld*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Lq^2*q1) + (2*Lq*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Ld^2*q1) - (2*Ld*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Lq^2*q2) - (2*Lq*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Ld^2*q2) - (2*Rs*cht*dt^2*hib*hom*psi)/(Ld*Lq*q1) - (4*Ld*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Lq^2*q1) + (4*Ld*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Lq^2*q1) + (4*Lq*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Ld^2*q2) - (4*Lq*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Ld^2*q2) - (8*Ld*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq^2*q1) + (8*Lq*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld^2*q2) + (4*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) - (8*Ld*Lq*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld*Lq*q1) - (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld*Lq*q2) - (2*Ld*cht*dt^2*hia*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) + (2*Lq*cht*dt^2*hia*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) + (4*Ld^2*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/(Lq^2*q1) - (4*Lq^2*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/(Ld^2*q2) + (4*Ld*dt^2*(hia^2 + q1)*hib*kpp^2*psi*sht)/(J^2*q3) - (4*Lq*dt^2*(hia^2 + q1)*hib*kpp^2*psi*sht)/(J^2*q3) + (8*Ld*Lq*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) - (8*Ld*Lq*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3);
        D11(4,5) = (dt*hom)/q4 - (dt*hom)/q5 + (2*(cht^2 + q5)*dt^2*hia*hib*(hom^2 + q3))/q1 - (2*(cht^2 + q5)*dt^2*hia*hib*(hom^2 + q3))/q2 - (2*cht*dt^2*(hia^2 + q1)*(hom^2 + q3)*sht)/q1 + (4*cht*dt^2*(hib^2 + q2)*(hom^2 + q3)*sht)/q1 + (4*cht*dt^2*(hia^2 + q1)*(hom^2 + q3)*sht)/q2 - (2*cht*dt^2*(hib^2 + q2)*(hom^2 + q3)*sht)/q2 - (2*dt^2*hia*hib*(hom^2 + q3)*(sht^2 + q4))/q1 + (2*dt^2*hia*hib*(hom^2 + q3)*(sht^2 + q4))/q2 - (dt^2*hia*hib*kpp^2*psi^2)/(J^2*q3) + (2*cht*dt^2*hib*(hom^2 + q3)*psi)/(Ld*q1) - (cht*dt^2*hib*(hom^2 + q3)*psi)/(Ld*q2) - (dt^2*hia*(hom^2 + q3)*psi*sht)/(Ld*q1) + (2*dt^2*hia*(hom^2 + q3)*psi*sht)/(Ld*q2) + (2*Rs^2*(cht^2 + q5)*dt^2*hia*hib)/(Ld^2*q1) - (2*Rs^2*(cht^2 + q5)*dt^2*hia*hib)/(Lq^2*q2) + (2*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom)/(Ld*q1) - (2*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom)/(Ld*q2) - (2*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom)/(Lq*q1) + (2*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom)/(Lq*q2) + (Rs^2*cht*dt^2*(hib^2 + q2)*sht)/(Ld^2*q1) + (Rs^2*cht*dt^2*(hia^2 + q1)*sht)/(Ld^2*q2) + (Rs^2*cht*dt^2*(hib^2 + q2)*sht)/(Lq^2*q1) + (Rs^2*cht*dt^2*(hia^2 + q1)*sht)/(Lq^2*q2) + (2*Rs^2*dt^2*hia*hib*(sht^2 + q4))/(Ld^2*q2) - (2*Rs^2*dt^2*hia*hib*(sht^2 + q4))/(Lq^2*q1) + (2*Rs*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Ld*q1) - (2*Rs*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Ld*q2) - (2*Rs*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Lq*q1) + (2*Rs*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Lq*q2) + (Ld*dt^2*hia*(hom^2 + q3)*psi*sht)/(Lq^2*q1) + (2*Ld^2*(cht^2 + q5)*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) - (2*Ld^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2)/(J^2*q3) + (2*Lq^2*(cht^2 + q5)*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) - (2*Lq^2*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2)/(J^2*q3) - (2*Ld^2*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Ld^2*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Lq^2*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Lq^2*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) + (2*Lq*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom)/(Ld^2*q1) - (2*Lq*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom)/(Ld^2*q1) - (2*Ld*Rs*(cht^2 + q5)*dt^2*(hia^2 + q1)*hom)/(Lq^2*q2) + (2*Ld*Rs*(cht^2 + q5)*dt^2*(hib^2 + q2)*hom)/(Lq^2*q2) - (2*Ld*Rs*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Lq^2*q1) + (2*Ld*Rs*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Lq^2*q1) + (2*Lq*Rs*dt^2*(hia^2 + q1)*hom*(sht^2 + q4))/(Ld^2*q2) - (2*Lq*Rs*dt^2*(hib^2 + q2)*hom*(sht^2 + q4))/(Ld^2*q2) + (Ld*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*psi)/(J^2*q3) - (Lq*cht*dt^2*(hib^3 + 3*hib*q2)*kpp^2*psi)/(J^2*q3) + (Ld*dt^2*(hia^3 + 3*hia*q1)*kpp^2*psi*sht)/(J^2*q3) - (Lq*dt^2*(hia^3 + 3*hia*q1)*kpp^2*psi*sht)/(J^2*q3) - (2*Rs^2*(cht^2 + q5)*dt^2*hia*hib)/(Ld*Lq*q1) + (2*Rs^2*(cht^2 + q5)*dt^2*hia*hib)/(Ld*Lq*q2) + (4*Rs^2*cht*dt^2*(hia^2 + q1)*sht)/(Ld*Lq*q1) - (2*Rs^2*cht*dt^2*(hib^2 + q2)*sht)/(Ld*Lq*q1) - (2*Rs^2*cht*dt^2*(hia^2 + q1)*sht)/(Ld*Lq*q2) + (4*Rs^2*cht*dt^2*(hib^2 + q2)*sht)/(Ld*Lq*q2) - (Rs*cht*dt^2*hia*hom*psi)/(Lq^2*q2) + (2*Rs^2*dt^2*hia*hib*(sht^2 + q4))/(Ld*Lq*q1) - (2*Rs^2*dt^2*hia*hib*(sht^2 + q4))/(Ld*Lq*q2) + (Rs*dt^2*hib*hom*psi*sht)/(Lq^2*q1) - (2*Lq^2*(cht^2 + q5)*dt^2*hia*hib*(hom^2 + q3))/(Ld^2*q1) + (2*Ld^2*(cht^2 + q5)*dt^2*hia*hib*(hom^2 + q3))/(Lq^2*q2) + (Ld^2*cht*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*sht)/(J^2*q3) + (Ld^2*cht*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*sht)/(J^2*q3) + (Lq^2*cht*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*sht)/(J^2*q3) + (Lq^2*cht*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*sht)/(J^2*q3) + (Lq^2*cht*dt^2*(hia^2 + q1)*(hom^2 + q3)*sht)/(Ld^2*q1) + (Ld^2*cht*dt^2*(hia^2 + q1)*(hom^2 + q3)*sht)/(Lq^2*q1) + (Lq^2*cht*dt^2*(hib^2 + q2)*(hom^2 + q3)*sht)/(Ld^2*q2) + (Ld^2*cht*dt^2*(hib^2 + q2)*(hom^2 + q3)*sht)/(Lq^2*q2) + (2*Ld^2*dt^2*hia*hib*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) - (2*Lq^2*dt^2*hia*hib*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Ld*cht*dt^2*hib*(hom^2 + q3)*psi)/(Lq^2*q2) + (4*Ld*Lq*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Ld*Lq*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*(sht^2 + q4))/(J^2*q3) - (6*Rs*cht*dt^2*hia*hib*hom*sht)/(Ld*q1) + (6*Rs*cht*dt^2*hia*hib*hom*sht)/(Ld*q2) - (6*Rs*cht*dt^2*hia*hib*hom*sht)/(Lq*q1) + (6*Rs*cht*dt^2*hia*hib*hom*sht)/(Lq*q2) - (2*Rs*cht*dt^2*hia*hom*psi)/(Ld*Lq*q1) + (Rs*cht*dt^2*hia*hom*psi)/(Ld*Lq*q2) - (Rs*dt^2*hib*hom*psi*sht)/(Ld*Lq*q1) + (2*Rs*dt^2*hib*hom*psi*sht)/(Ld*Lq*q2) - (6*Ld^2*cht*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) - (6*Lq^2*cht*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*sht)/(J^2*q3) - (2*Ld*Lq*cht*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*sht)/(J^2*q3) - (2*Ld*Lq*cht*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*sht)/(J^2*q3) - (3*Ld*cht*dt^2*(hia^2 + q1)*hib*kpp^2*psi)/(J^2*q3) + (3*Lq*cht*dt^2*(hia^2 + q1)*hib*kpp^2*psi)/(J^2*q3) - (3*Ld*dt^2*hia*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) + (3*Lq*dt^2*hia*(hib^2 + q2)*kpp^2*psi*sht)/(J^2*q3) - (4*Ld*Lq*(cht^2 + q5)*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2)/(J^2*q3) + (4*Ld*Lq*(cht^2 + q5)*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2)/(J^2*q3) + (2*Ld*Rs*cht*dt^2*hia*hib*hom*sht)/(Lq^2*q1) + (2*Lq*Rs*cht*dt^2*hia*hib*hom*sht)/(Ld^2*q1) - (2*Ld*Rs*cht*dt^2*hia*hib*hom*sht)/(Lq^2*q2) - (2*Lq*Rs*cht*dt^2*hia*hib*hom*sht)/(Ld^2*q2) + (12*Ld*Lq*cht*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*sht)/(J^2*q3);

        D11(5,1) = D11(1,5);
        D11(5,2) = D11(2,5);
        D11(5,3) = D11(3,5);
        D11(5,4) = D11(4,5);
        D11(5,5) = 1/q5 + (dt^2*(hom^2 + q3))/q4 + (dt^2*(hom^2 + q3)*psi^2)/(Lq^2*q2) - (2*dt^2*(hia^2 + q1)*(hom^2 + q3)*(sht^2 + q4))/q1 - (2*dt^2*(hib^2 + q2)*(hom^2 + q3)*(sht^2 + q4))/q2 + (dt^2*(hib^2 + q2)*kpp^2*psi^2)/(J^2*q3) + (4*Rs^2*(cht^2 + q5)*dt^2*(hia^2 + q1))/(Ld^2*q1) + (4*Rs^2*(cht^2 + q5)*dt^2*(hib^2 + q2))/(Lq^2*q2) + (Rs^2*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Ld^2*q1) + (Rs^2*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld^2*q2) + (Rs^2*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Lq^2*q1) + (Rs^2*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Lq^2*q2) + (4*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/q1 - (4*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/q2 - (2*Rs^2*dt^2*(hib^2 + q2)*(sht^2 + q4))/(Ld*Lq*q1) - (2*Rs^2*dt^2*(hia^2 + q1)*(sht^2 + q4))/(Ld*Lq*q2) + (4*Lq^2*(cht^2 + q5)*dt^2*(hib^2 + q2)*(hom^2 + q3))/(Ld^2*q1) + (4*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hom^2 + q3))/(Lq^2*q2) + (Ld^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Ld^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Lq^2*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Lq^2*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (Lq^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q1) + (Ld^2*dt^2*(hia^2 + q1)*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q1) + (Lq^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*(sht^2 + q4))/(Ld^2*q2) + (Ld^2*dt^2*(hib^2 + q2)*(hom^2 + q3)*(sht^2 + q4))/(Lq^2*q2) - (2*dt^2*hib*(hom^2 + q3)*psi*sht)/(Ld*q2) + (4*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Ld*q1) - (4*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Ld*q2) - (4*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Lq*q1) + (4*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Lq*q2) - (2*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld*q1) + (2*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld*q2) - (2*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq*q1) + (2*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq*q2) + (2*Ld*dt^2*hib*(hom^2 + q3)*psi*sht)/(Lq^2*q2) + (2*Ld*dt^2*(hib^3 + 3*hib*q2)*kpp^2*psi*sht)/(J^2*q3) - (2*Lq*dt^2*(hib^3 + 3*hib*q2)*kpp^2*psi*sht)/(J^2*q3) + (4*Ld^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) + (4*Lq^2*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) - (2*Ld^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Lq^2*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*dt^2*(hia^4 + 6*hia^2*q1 + 3*q1^2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (2*Ld*Lq*dt^2*(hib^4 + 6*hib^2*q2 + 3*q2^2)*kpp^2*(sht^2 + q4))/(J^2*q3) + (4*Rs*cht*dt^2*hib*hom*psi)/(Lq^2*q2) - (2*Rs*dt^2*hia*hom*psi*sht)/(Lq^2*q2) + (4*Ld*cht*dt^2*hia*(hom^2 + q3)*psi)/(Lq^2*q2) + (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld^2*q1) - (4*Rs^2*cht*dt^2*hia*hib*sht)/(Lq^2*q2) + (4*Ld^2*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) - (4*Ld^2*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3) + (4*Lq^2*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) - (4*Lq^2*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3) - (8*Lq*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Ld^2*q1) + (8*Ld*Rs*(cht^2 + q5)*dt^2*hia*hib*hom)/(Lq^2*q2) + (4*Lq*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Ld^2*q1) - (4*Lq*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Ld^2*q1) - (4*Ld*Rs*cht*dt^2*(hia^2 + q1)*hom*sht)/(Lq^2*q2) + (4*Ld*Rs*cht*dt^2*(hib^2 + q2)*hom*sht)/(Lq^2*q2) + (2*Ld*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq^2*q1) + (2*Lq*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld^2*q1) - (2*Ld*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Lq^2*q2) - (2*Lq*Rs*dt^2*hia*hib*hom*(sht^2 + q4))/(Ld^2*q2) - (8*Ld*Lq*(cht^2 + q5)*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2)/(J^2*q3) + (2*Rs*dt^2*hia*hom*psi*sht)/(Ld*Lq*q2) + (4*Ld*Lq*dt^2*(hia^2 + q1)*(hib^2 + q2)*kpp^2*(sht^2 + q4))/(J^2*q3) - (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld*Lq*q1) + (4*Rs^2*cht*dt^2*hia*hib*sht)/(Ld*Lq*q2) + (4*Ld*cht*dt^2*hia*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) - (4*Lq*cht*dt^2*hia*(hib^2 + q2)*kpp^2*psi)/(J^2*q3) - (4*Lq^2*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/(Ld^2*q1) + (4*Ld^2*cht*dt^2*hia*hib*(hom^2 + q3)*sht)/(Lq^2*q2) - (2*Ld*dt^2*(hia^2 + q1)*hib*kpp^2*psi*sht)/(J^2*q3) + (2*Lq*dt^2*(hia^2 + q1)*hib*kpp^2*psi*sht)/(J^2*q3) - (8*Ld*Lq*cht*dt^2*hia*(hib^3 + 3*hib*q2)*kpp^2*sht)/(J^2*q3) + (8*Ld*Lq*cht*dt^2*(hia^3 + 3*hia*q1)*hib*kpp^2*sht)/(J^2*q3);
        
        D12 = -A92'*iQ5;
        D21 = D12';
        D22 = iQ5 + C5'*iR*C5;

        Jj12 = D22 - D21/(Jj12 + D11)*D12;
        iJn12(:,:,t) = inv(Jj12);
    end
    
    %control & simulation
    if(control == 1) %ome = ref_ome, the = integral(ome), ial=ibe=0
        x_sys(1, t+1) = 0;
        x_sys(2, t+1) = 0;
        x_sys(3, t+1) = ref_ome(t);
        x_sys(4, t+1) = the + dt*ome;
    else
        if(control == 6) %rnd. err. ref_ome
           ref_ome(t) = ref_ome(t) + amp*randn(); 
        end
        
        %PI (only PI for control == 2)        
        sum_iq = sum_iq + ref_ome(t) - ome;
        ref_iq = kon_pi*(ref_ome(t) - ome) + kon_ii*sum_iq;
        sum_ud = sum_ud - id;
        u_dq(1, t) = kon_pu*(-id) + kon_iu*sum_ud;
        sum_uq = sum_uq + ref_iq - iq;
        u_dq(2, t) = kon_pu*(ref_iq - iq) + kon_iu*sum_uq;
        u_dq(1, t) = u_dq(1, t) - Ls*ome*ref_iq;
        u_dq(2, t) = u_dq(2, t) + psipm*ome;        
               
        if(control == 3) %inj. sin -> dq
            u_dq(1,t) = u_dq(1,t) + amp*sin(injom*dt*t);
            u_dq(2,t) = u_dq(2,t) + amp*cos(injom*dt*t);
        elseif(control == 4) %inj. rect. -> dq
            u_dq(1,t) = u_dq(1,t) + amp*sign(sin(injom*dt*t));
            u_dq(2,t) = u_dq(2,t) + amp*sign(cos(injom*dt*t));
        elseif(control == 5) %inj. const. -> d
%             u_dq(1,t) = 0.1*Ld/dt - (1.0*Ld/dt - Rs)*id - Lq*ome*iq;
            u_dq(1,t) = amp;            
        elseif(control == 9) %bic. sign. ome           
            u_dq(1,t) = u_dq(1,t) - amp*sign(ome);
            u_dq(2,t) = u_dq(2,t) + amp*sign(ome);
        end
       
        ual = u_dq(1,t)*cos(the) - u_dq(2,t)*sin(the);
        ube = u_dq(1,t)*sin(the) + u_dq(2,t)*cos(the);
        
        if(control == 7) %inj. sin -> al-be
            ual = ual + amp*cos(injom*dt*t);
            ube = ube + amp*sin(injom*dt*t);
        elseif(control == 8) %inj. rect. -> al-be
            ual = ual + amp*sign(cos(injom*dt*t));
            ube = ube + amp*sign(sin(injom*dt*t));        
        elseif((control == 10)&&(rand() > (1/5))) %bic rnd. 5
            duab = sign(rand(2,1)-0.5)*amp;
            ual = ual + duab(1);
            ube = ube + duab(2);
        end
      
        ud = ual*cos(the) + ube*sin(the);
        uq = ube*cos(the) - ual*sin(the);
       
        %simulation model Ldq
        idpl = (1.0 - Rs*dt/Ld)*id + Lq*dt/Ld*ome*iq + dt/Ld*ud;
        iqpl = (1.0 - Rs*dt/Lq)*iq - psipm*dt/Lq*ome - Ld*dt/Lq*ome*id + dt/Lq*uq;

        x_sys(1, t+1) = idpl*cos(the) - iqpl*sin(the);
        x_sys(2, t+1) = idpl*sin(the) + iqpl*cos(the);
        x_sys(3, t+1) = (1.0-B*dt/J)*ome + kp*pp*pp*dt/J*((Ld-Lq)*id*iq + psipm*iq);
        x_sys(4, t+1) = the + dt*ome;
    end
        
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   plot

%axis
xax = 1:T-1;
timex = (xax)*dt;

if(plotsys == 1)
    subplot(2, 2, 1);
    plot(timex, x_sys(1, xax));
    subplot(2, 2, 2);
    plot(timex, x_sys(2, xax));
    subplot(2, 2, 3);
    plot(timex, x_sys(3, xax), timex, ref_ome(xax));
    subplot(2, 2, 4);
    plot(timex, atan2(sin(x_sys(4, xax)),cos(x_sys(4, xax))));
    figure;
end

if(model1 == 1)
    hold on;
    plot(timex, squeeze(iJn1(4,4,xax)), '-b');
end
if(model2 == 1)
    hold on;
    plot(timex, squeeze(iJn2(4,4,xax)), '-r');
end
if(model3 == 1)
    hold on;
    plot(timex, squeeze(iJn3(4,4,xax)), '-g',timex, squeeze(iJn3(5,5,xax)), '-g');
end
if(model4 == 1)
    hold on;
    plot(timex, squeeze(iJn4(4,4,xax)), '--b');
end
if(model5 == 1)
    hold on;
    plot(timex, squeeze(iJn5(4,4,xax)), '--r');
end
if(model6 == 1)
    hold on;
    plot(timex, squeeze(iJn6(4,4,xax)), '--g',timex, squeeze(iJn6(5,5,xax)), '--g');
end
if(model7 == 1)
    hold on;
    plot(timex, squeeze(iJn7(4,4,xax)), '-c');
end
if(model8 == 1)
    hold on;
    plot(timex, squeeze(iJn8(4,4,xax)), '-m');
end
if(model9 == 1)
    hold on;
    plot(timex, squeeze(iJn9(4,4,xax)), '-y',timex, squeeze(iJn9(5,5,xax)), '-y');
end
if(model10 == 1)
    hold on;
    plot(timex, squeeze(iJn10(4,4,xax)), '--c');
end
if(model11 == 1)
    hold on;
    plot(timex, squeeze(iJn11(4,4,xax)), '--m');
end
if(model12 == 1)
    hold on;
    plot(timex, squeeze(iJn12(4,4,xax)), '--y',timex, squeeze(iJn12(5,5,xax)), '--y');
end