#pragma once
#include "BaseTrafficAgentCt.h"

class TrafficAgentLQObserver : public BaseTrafficAgentCt {
public:

	void adapt(const vec &glob_dt) {
		BaseTrafficAgentCt::adapt(glob_dt);
		B = zeros( queues.length(), 1);	
		// jeden clen matice B
		for ( int i=0; i<queues.length(); i ++ ) {
			B(i,0) = - s_flow(i) * lanehs(i)->green_time_ratio;
		}
	}

	void broadcast( Setting &set ) {
		if ( nOfBroadcast == 0 ) {
			stringstream what;
			for ( int i = 0; i < queueData.length(); i ++ )
				sendQueueData( set, queueData(i) );


			

			// send alphas
			string dummyDet = "DUMMY_DET";
			for ( int i = 0; i < lanehs.length(); i++ ) {		
				for ( int j = 0; j < lanehs(i)->rv_outputs.length(); j ++ ) {
					if ( dummyDet.compare(lanehs(i)->rv_outputs.name(j)) != 0 ) {	
						//what.str("");						
						//what << "coef" << lanehs(i)->rv_outputs.name(j);
						//double val = s_flow(i) * lanehs(i)->green_time_ratio * lanehs(i)->getLane().alpha(j);
						//sendToAll<double>(set, what.str(), val);
					}
				}				
			}
		}
		//BaseTrafficAgentCt::broadcast(set);
		nOfBroadcast ++;

		// send B matrix
	}
};
UIREGISTER(TrafficAgentLQObserver);