// Bayesian Filtering for PMSM using Marginalized Particle Filter 

#include "parametry_motoru.h"

#define N 20

#define Lsd Ls*0.9
#define Lsq Ls
#define _dt 0.000125
#define _ad (1.-Rs*_dt/Lsd)
#define _aq (1.-Rs*_dt/Lsq)
#define _b  Fmag/Lsq*_dt
#define _cd  _dt/Lsd
#define _cq  _dt/Lsq

double randn();
double randu();

void mpf_bayes ( const double &isa, const double &isb , const double &usa, const double &usb );
void mpf_init(double qom0, double qth0, double r0);
void mpf_mean(double *Ecosth, double *Esinth, double *Eome);
void mpf_th(double th1[N]);

double kalman_om ( const double &isa, const double &isb , const double &usa, const double &usb, const double &th );