/*!
  \file
  \brief Support for testing descendants of pdf.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef pdf_HARNESS_H
#define pdf_HARNESS_H

#include "bdmroot.h"
#include "itpp_ext.h"
#include "shared_ptr.h"
#include "base/bdmbase.h"
#include "base/user_info.h"

namespace bdm {

class pdf_harness : public root {
private:
    shared_ptr<pdf> hpdf;
    vec cond;
    vec mean;
    vec variance;
    int nsamples;
    mat R;
    double tolerance;

public:
    static void test_config ( const char *config_file_name );

    pdf_harness() : nsamples ( 1000 ), tolerance ( 0.1 ) { }

    virtual void test ( const char *config_name, int idx );

    void from_setting ( const Setting &set );

protected:
    pdf *get_pdf() {
        return hpdf.get();
    }

private:
    void check_mean();

    // assumes R is valid
    void check_covariance();
};
UIREGISTER ( pdf_harness );

}

#endif
