#include "general_suite.h"

namespace UnitTest {

Array<const char *> selected_tests;

bool is_selected_test ( const UnitTest::Test *test ) {
    bdm_assert_debug ( test, "NULL test" );

    if ( !selected_tests.length() ) {
        return true;
    }

    for ( int i = 0; i < selected_tests.length(); ++i ) {
        const char *n = test->m_details.testName;
        bdm_assert_debug ( n, "NULL test name" );
        const char *sname = selected_tests ( i );
        bdm_assert_debug ( sname, "NULL selected test name" );
        if ( !strcmp ( n, sname ) ) {
            return true;
        }
    }

    return false;
}

void print_test_list() {
    UnitTest::Test* curTest = UnitTest::Test::GetTestList().GetHead();

    while ( curTest != 0 ) {
        const char *n = curTest->m_details.testName;
        printf ( "%s\n", n );
        curTest = curTest->next;
    }
}

void pick_selected_tests ( int argc, char const *argv[] ) {
    selected_tests.set_length ( argc - 1 );
    const char **param = argv + 1;
    int i = 0;
    while ( *param ) {
        selected_tests ( i ) = *param;
        ++i;
        ++param;
    }
}

int run_selected_tests() {
    itpp::RNG_randomize();

    UnitTest::TestReporterStdout reporter;
    UnitTest::TestRunner runner ( reporter );
    return runner.RunTestsIf ( UnitTest::Test::GetTestList(),
                               0,
                               is_selected_test,
                               0 );
}

}