#include <itpp/itbase.h>
#include "libBM.h"
#include "../itpp_ext.h"

using namespace itpp;

using std::cout;

void RV::init ( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times ) {
	//
	int i;
	len = in_ids.length();
	//PRUDENT_MODE
	// All vetors should be of same length
	if ( ( len != in_ids.length() ) || \
	        ( len != in_names.length() ) || \
	        ( len != in_sizes.length() ) || \
	        ( len != in_times.length() ) ) {
		it_error ( "RV::RV inconsistent length of input vectors." );
	}

	ids = in_ids;
	names = in_names;
	sizes = in_sizes;
	times = in_times;
	tsize = 0;
	for ( i = 0;i < len;i++ ) {tsize += sizes ( i );}
};

RV::RV ( ivec in_ids, Array<std::string> in_names, ivec in_sizes, ivec in_times ) {
	init ( in_ids, in_names, in_sizes, in_times );
}

RV::RV() : tsize ( 0 ), len ( 0 ) {};

bool RV::add ( const RV &rv2 ) {
	// TODO
	ivec ind = rv2.findself ( *this ); //should be -1 all the time
	ivec index = itpp::find(ind==-1); 
	
	if ( index.length() < rv2.len ) { //conflict
		ids = concat ( ids, rv2.ids(index) );
		sizes = concat ( sizes, rv2.sizes(index) );
		times = concat ( times, rv2.times(index) );
		names = concat ( names, rv2.names(to_Arr(index)) );
	}
	else {
		ids = concat ( ids, rv2.ids );
		sizes = concat ( sizes, rv2.sizes );
		times = concat ( times, rv2.times );
		names = concat ( names, rv2.names );
	}
	tsize = sum(sizes);
	len = ids.length();
	return (index.length()<rv2.len);

//	return *this;
};

RV::RV ( ivec in_ids ) {

	len = in_ids.length();
	Array<std::string> A ( len );
	std::string rvstr = "rv";

	for ( int i = 0; i < len;i++ ) {
		A ( i ) = rvstr + to_str ( i );
	}

	init ( in_ids, A, ones_i ( len ), zeros_i ( len ) );
}

RV RV::subselect ( ivec ind ) const {
	return RV ( ids ( ind ), names ( to_Arr ( ind ) ), sizes ( ind ), times ( ind ) );
}

void RV::t ( int delta ) { times += delta;}

RV RV::operator() ( ivec ind ) const {
	return RV ( ids ( ind ), names ( to_Arr ( ind ) ), sizes ( ind ), times ( ind ) );
}

bool RV::equal ( const RV &rv2 ) const {
	return ( ids == rv2.ids ) && ( times == rv2.times ) && ( sizes == rv2.sizes );
}

mat epdf::sampleN ( int N ) const {
	mat X = zeros ( rv.count(), N );
	for ( int i = 0;i < N;i++ ) X.set_col ( i, this->sample() );
	return X;
};


std::ostream &operator<< ( std::ostream &os, const RV &rv ) {

	for ( int i = 0; i < rv.len ;i++ ) {
		os << rv.ids ( i ) << "(" << rv.sizes ( i ) << ")" <<  // id(size)=
		"=" << rv.names ( i )  << "_{"  << rv.times ( i ) << "}; "; //name_{time}
	}
	return os;
}

str RV::tostr() const {
	ivec idlist ( tsize );
	ivec tmlist ( tsize );
	int i;
	int pos = 0;
	for ( i = 0;i < len;i++ ) {
		idlist.set_subvector ( pos, pos + sizes ( i ) - 1, ids ( i ) );
		tmlist.set_subvector ( pos, pos + sizes ( i ) - 1, times ( i ) );
		pos += sizes ( i );
	}
	return str ( idlist, tmlist );
}

ivec RV::dataind ( RV rv2 ) const {
	str str2 = rv2.tostr();
	ivec res ( 0 );
	ivec part;
	int i;
	for ( i = 0;i < len;i++ ) {
		part = itpp::find ( ( str2.ids == ids ( i ) ) & ( str2.times == times ( i ) ) );
		res = concat ( res, part );
	}
	return res;
}

RV RV::subt ( const RV rv2 ) const {
	ivec res = this->findself ( rv2 ); // nonzeros
	ivec valid = itpp::find ( res == -1 ); //-1 => value not found => it remains
	return ( *this ) ( valid ); //keep those that were not found in rv2
}

ivec RV::findself ( const RV &rv2 ) const {
	int i, j;
	ivec tmp = -ones_i ( len );
	for ( i = 0;i < len;i++ ) {
		for ( j = 0;j < rv2.length();j++ ) {
			if ( ( ids ( i ) == rv2.ids ( j ) ) & ( times ( i ) == rv2.times ( j ) ) ) {
				tmp ( i ) = j;
				break;
			}
		}
	}
	return tmp;
}

RV concat ( const RV &rv1, const RV &rv2 ) {
	RV pom = rv1;
	pom.add ( rv2 );
	return pom;
}
