function [x,y]=pmsm_sim(input)
% Realistic simulator of PMSM with power electronics.
% For implementation reasons, functionality of the simulator is split
% according to the number of arguments as follows:
%
% Usage:
%   DefaultParameters = pmsm_sim;         % Initialize (compulsory)
%   NewParam = pmsm_sim(NewParameters);   % Change parameters
%   [x,y] = pmsm_sim(omega_ref,Mz);       % Internally controlled sim. step
%   [x,y] = pmsm_sim(usa,usb,Mz);         % Externally controlled sim. step
% 
% Parameters = [Rs, Ls, Fmag, Bf, p, kp, J, Uc, DT, dt]
%     Rs..J  -- PSMSM parameters
%     Uc -- DC link voltage
%     DT -- Dead Time
%     dt -- internal simulation step
%
% x = [isa,isb,omega,theta,Torque,Fsd,isd,isq,Mz];
% y = [usa_req, usb_req, isa, isb, usa_av, usb_av];
%     us[a,b]_req  -- requested voltage (before PWM)
%     us[a,b]_av   -- avereged true voltage (after PWM)
%

