#include <mex/mex_parser.h>
#include <mex/mex_pdf.h>

class mexMerger: public MergerBase {
protected:
	mxArray *data;
    shared_ptr<epdf> merg;
public:
    mexMerger() {};
    void from_setting(const Setting &S)  {
        Setting &So=S["object"];
        data = (mxArray*)long(So);
		
		// copy sources
		mxArray *sA;
		mexCallMATLAB(1, &sA, 1, &data,  "get_sources");
		
		UImxArray src(sA);
		UI::get(sources, src);
    }
    
    void set_sources(const Array<shared_ptr<epdf> > &Src){
		sources=Src;
		
		mxArray *in[2];
		in[0] = data;
		UImxArray S;
		UI::save(Src, S);
		in[1] = UImxArray::create_mxArray(S);
		
		mxArray *tmp;
		mexCallMATLAB(1, &tmp, 2, in, "set_sources");
		data = tmp;
	}
    void validate() {
        mxArray *tmp;
        mexCallMATLAB(1, &tmp, 1, &data,  "validate");
        // new object is in tmp
        data = tmp;

		mxArray *tmp2;
		mexCallMATLAB(1, &tmp2, 1,(mxArray **) &data,  "get_merger");
		UImxArray mg(tmp2);
		merg=UI::build<epdf>(mg);
		
		MergerBase::validate();		
    }
    void merge() {
        mxArray *tmp;
        mexCallMATLAB(1, &tmp, 0, &tmp, "merge");
        data = tmp;
    }
    const epdf& merger() {
        mxArray *tmp;
        mexCallMATLAB(1, &tmp, 1,(mxArray **) &data,  "get_merger");
		UImxArray mg(tmp);
        merg=UI::build<epdf>(mg);
        return *(merg.get());
    }
};
UIREGISTER(mexMerger);