#include "estim/arx.h"
#include <vector>
#include <iostream>
#include <fstream>
using namespace bdm;

// estimation of AR(0) model
int main(){
	//data
	vector<vector<vector<string>>> string_lists;
	string_lists.push_back(vector<vector<string>>());
	string_lists.push_back(vector<vector<string>>());
	string_lists.push_back(vector<vector<string>>());

	char* file_strings[3] = {"c:\\ar_normal.txt", "c:\\ar_student.txt", "c:\\ar_cauchy.txt"};
	

	for(int i = 0;i<3;i++)
	{	
		ifstream myfile(file_strings[i]);
		if (myfile.is_open())
		{
			while ( myfile.good() )
			{
				string line;
				getline(myfile,line);
				
				vector<string> parsed_line;
				while(line.find(',') != string::npos)
				{
					int loc = line.find(',');
					parsed_line.push_back(line.substr(0,loc));
					line.erase(0,loc+1);					
				}				

				string_lists[i].push_back(parsed_line);
			}
			myfile.close();
		}
	}

    //prior
    mat V0 = 0.0001 * eye ( 3 );
    //V0 ( 0, 0 ) = 0.1; //

	for(int j = 0;j<string_lists.size();j++)
	{ 
		
		for(int i = 0;i<string_lists[j].size();i++)
		{
			ARX Ar;
			Ar.set_statistics ( 1, V0 ); //nu is default (set to have finite moments)
			Ar.set_constant ( false );
			Ar.validate();
			// forgetting is default: 1.0
			
			vector<vec> conditions;
			for(int k = 1;k<string_lists[j][i].size();k++)
			{
				vec condition;								
				condition.ins(0,string_lists[j][i][k]);				
				conditions.push_back(condition);				

				if(conditions.size()>1)
				{		
					conditions[k-2].ins(0,string_lists[j][i][k]);
					
				}

				if(conditions.size()>2)
				{
					conditions[k-3].ins(0,string_lists[j][i][k]);					

					//cout << conditions[k-3] << endl;// << conditions[k-3].left(1) << conditions[k-3].right(2);

					Ar.bayes(conditions[k-3].left(1),conditions[k-3].right(2));				
				}
			}

			ofstream myfile;
			myfile.open("c:\\classic_ar1.txt",ios::app);
			myfile << Ar.posterior().mean()[0] << ";";
			myfile.close();

			myfile.open("c:\\classic_ar2.txt",ios::app);
			myfile << Ar.posterior().mean()[1] << ";";
			myfile.close();


			
		}

		ofstream myfile;
		myfile.open("c:\\classic_ar1.txt",ios::app);
		myfile << endl;
		myfile.close();

		myfile.open("c:\\classic_ar2.txt",ios::app);
		myfile << endl;
		myfile.close();
	}
}

