function [x_s, y_s] = evolSys(x, u, nQ, nR, noise, simulator)
    if ((simulator == 1)||(simulator == 10))%simulator
        ua = 3*u(1);
        ub = 3*u(2);
        %kompenzace ubytku
        if(simulator == 10)
            ua = ua + comps(x(1));
            ub = ub + comps(x(2));           
        end
        
        [tx, ty] = pmsm_sim(ua, ub, 0);
        
        x_s = tx(1:4); %isa, isb, omega, theta        
        y_s = ty(3:4); %isa, isb        
        
    elseif (simulator == 0)%matlab - stejne indukcnosti
        dt = 0.000125; 
        a = 0.9898;
        b = 0.0072;
        c = 0.0361;
        d = 1.0;
        e = 0.0149;

        x_s(1) = a*x(1) + b*x(3)*sin(x(4)) + c*u(1) + noise*sqrt(nQ(1,1))*randn();
        x_s(2) = a*x(2) - b*x(3)*cos(x(4)) + c*u(2) + noise*sqrt(nQ(2,2))*randn();
        x_s(3) = d*x(3) + e*(x(2)*cos(x(4)) - x(1)*sin(x(4))) + noise*sqrt(nQ(3,3))*randn();
        x_s(4) = x(4) + dt*x(3) + noise*sqrt(nQ(4,4))*randn();

        y_s(1) = x_s(1) + noise*sqrt(nR(1,1))*randn();
        y_s(2) = x_s(2) + noise*sqrt(nR(2,2))*randn();
        
    else %matlab - ruzne indukcnosti
        Rs = 0.28;
        Ls = 0.003465;
        psipm = 0.1989;
        B = 0;    
        kp = 1.5;
        pp = 4.0;
        J = 0.04;
        dt = 0.000125;
        Lq = 1.0*Ls;
        Ld = 0.9*Ls; 
        
        id = x(1)*cos(x(4)) + x(2)*sin(x(4));
        iq = x(2)*cos(x(4)) - x(1)*sin(x(4));
        om = x(3);
        th = x(4);
        ud = u(1)*cos(x(4)) + u(2)*sin(x(4));
        uq = u(2)*cos(x(4)) - u(1)*sin(x(4));
                
        idp = (1 - Rs*dt/Ld)*id + Lq*dt/Ld*om*iq + dt/Ld*ud;
        iqp = (1 - Rs*dt/Lq)*iq - psipm*dt/Lq*om - Ld*dt/Lq*om*id + dt/Lq*uq;
        omp = (1 - B*dt/J)*om + kp*pp*pp*dt/J*((Ld-Lq)*id*iq + psipm*iq);
        thp = th + dt*om;
        
        x_s(1) = idp*cos(thp) - iqp*sin(thp) + noise*sqrt(nQ(1,1))*randn();
        x_s(2) = iqp*cos(thp) + idp*sin(thp) + noise*sqrt(nQ(2,2))*randn();
        x_s(3) = omp + noise*sqrt(nQ(3,3))*randn();
        x_s(4) = thp + noise*sqrt(nQ(4,4))*randn();        

        y_s(1) = x_s(1) + noise*sqrt(nR(1,1))*randn();
        y_s(2) = x_s(2) + noise*sqrt(nR(2,2))*randn();
        
    end
end 