#include "math.h"
#include "fixed.h"

typedef short int int16 ;
typedef int int32 ;

/* sin (theta), theta=-32768..32768 -> -pi,pi*/
int16 qsin(int16 theta){
	int16 t_sin;
	int32 tmp;
	tmp = prevod(sin(3.141593*(theta)/32768.),15);
	if (tmp>32767) t_sin =32767; else t_sin=tmp;
	return t_sin;
}
int16 qcos(int16 theta){
	int16 t_cos;
	int32 tmp;
	tmp = prevod(cos(3.141593*(theta)/32768.),15);
	if (tmp>32767) t_cos =32767; else t_cos=tmp;
	return t_cos;
}
int16 qsqrt(int16 x){
	int16 tmp;
	tmp = prevod(sqrt((double)x/32768.),15);
}
int16 qlog(int16 x){
	if (x<=0) 
		return -32768;
	else
		return prevod(log(x/32768.)/11,15); // log (1/32768) = -10.39. log(x) is scaled to -11:0
}