function pMix = facchng(pMix, com, Fac)
% replace predictor factor in a given component
% pMix = facchng(pMix, com, Fac)
%
% pMix : mixture predictor
% com  : component (number)
% Fac  : ARX LS factor
%
% Design : P. Nedoma
% Updated: March 2002, July 2004
% Project: ProDaCTools

ychn = Fac.ychn;

facs = pMix.coms(com,:);               % factors in component

% find channel corresponding to Fac
for fac = facs
  if pMix.Facs{fac}.ychn == ychn, break; end
end

% replace factor in component
% build states of Fac (pEth)
STR  = pMix.states.strc;            % big structure
str1 = 1000*STR(1,:) + STR(2,:);    % encode STR to be vector
str  = Fac.str;
str  = 1000*str(1,:) + str(2,:);    % encode factor structure
len  = length(str);
pstr = zeros(1, len);
instr = [];
for i=1:len
    j = find(str(i)==str1);
    if isempty(j),
       error('target structure does not contain a source element');
    end
    instr(i) = j;
end

%Fac.states.reserved = 'reserved';
Fac.states.pEth = instr;
pMix.Facs{fac}  = Fac;
