#ifndef UI_H
#define UI_H

#include <sstream>
#include <iostream>
#include <stdio.h>
#include <string>
#include <typeinfo>
#include <map>
#include <utility>
#include <vector>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <iostream>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/framework/LocalFileInputSource.hpp>
#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>

#ifdef XERCES_CPP_NAMESPACE_USE
XERCES_CPP_NAMESPACE_USE
#endif

using std::string;
using namespace std;

/*!
@brief Xerces interface class

This class is used to interact with the Xerces library.
*/
class XercesConnector
{
public:
	//! DOMImplementation is a base class for the all DOM oparations
	DOMImplementation *pImplementation;
	//! This DOMWriter is used to export internal data into xml files
	DOMWriter *pSerializer;

private:
	//!default constructor
	XercesConnector();
	//!destructor
	~XercesConnector();
	//!forbidden copy constructor
	XercesConnector( XercesConnector& ref );
public:

	DOMDocument* Parse( const LocalFileInputSource & inputSource )
	{
		//! This DOMWriter is used to import external data from xml files
		XercesDOMParser parser;

		parser.setValidationScheme(XercesDOMParser::Val_Auto);
		parser.setDoNamespaces(false);
		parser.setDoSchema(false);

		parser.parse( inputSource );
		if( parser.getErrorCount() )
			return NULL;
		
		return parser.adoptDocument();	
	}


	//! function transcodes Xerces' XMLCh-based strings into C++ strings
	string XMLCh2str( const XMLCh* const  XMLCh_str );

	class Comparator
	{
	public:
		//! operator compares two XMLCh strings and wheather the first is alphabethically higher
		bool operator()( const XMLCh* const a , const XMLCh* const b) const;
	};

	//! The only global instance of the XercesConnector class
	// potrebujeme inicializaci hned v okamziku zavolani!!
	static XercesConnector& instance()
	{
		static XercesConnector gxc;
		return gxc;
	};
};

class BindingFrame
{
protected:
	BindingFrame()
	{
		// trik, chci jen to, aby se ZAVCAS inicializoval!!
		// tj pred vsema UI apod.. hlavne pred praci s XMLStringem
		XercesConnector::instance();
	}

public:
	
	// nacpe na prislusne pointery, kdyztak da NULL
	virtual void AssemblyBindedData( DOMElement &element ) = 0;

	// uvolneni pameti po slozeni objektu, tj. lze jedine po AssemblyBD
	virtual void ReleaseUsedMemory()
	{
	}

	// vrati bool, pokud se povedlo rozebrat a naplnit element
	// nebude tu nahodou jeste ten help - string??
	virtual bool DisassemblyBindedData( DOMElement &element ) = 0;		
};
/*
class BindedAttribute : public BindingFrame
{
private:		
	const XMLCh* const transcodedAttributeName;

public:
	BindedAttribute( string attributeName )
		: transcodedAttributeName( XMLString::transcode attributeName.c_str() ) )
	{
	}

	~BindedAttribute()
	{			
		XMLString::release( (XMLCh**)&transcodedAttributeName );
	}

	// TAM JSOU TY HODNOTY
	string str;

	// nacpe na prislusne pointery, kdyztak da NULL
	void AssemblyBindedData( DOMElement &element )
	{
		const XMLCh* const transcoded_str = element.getAttribute( transcodedAttributeName );
		str = string( XMLString::transcode( transcoded_str ) );
	}

	bool DisassemblyBindedData( DOMElement &element )
	{
		const XMLCh* transcoded_str = XMLString::transcode(str.c_str());
		element.setAttribute( transcodedAttributeName, transcoded_str );
		XMLString::release( (XMLCh**) &transcoded_str );
	}
};

/*!
@brief UserInfo class is for internal purposes only. Use CompoundUserInfo<T> instead.

The raison d'etre of this class is to allow pointers to (the main part of) 
CompoundUserInfo<T> objects even for different generic types.
*/

class UserInfo : public BindingFrame
{
private:
	//! Type definition of mapping which transforms type names to the related user infors
	typedef map< const string, UserInfo*> MappedString2UI;
	
	//! Mapped 
	static MappedString2UI& userFriendlyNames2UI()
	{
		static MappedString2UI var;
		return var;
	}

	//! Mapped 
	static MappedString2UI& namesByRTTI2UI()
	{
		static MappedString2UI var;
		return var;
	}

	const string userFriendlyTypeName;
public:
	const string typeNameByRTTI;

	//! The only constructor which fills both the transcodedTypeName and the help attribute
	UserInfo( const string& userFriendlyTypeName, const string& typeNameByRTTI )
		: userFriendlyTypeName ( userFriendlyTypeName ),
		typeNameByRTTI( typeNameByRTTI )
	{	
		userFriendlyNames2UI().insert( make_pair( userFriendlyTypeName, this ) );
		namesByRTTI2UI().insert( make_pair( typeNameByRTTI, this ) );
	}

	~UserInfo()
	{		
	}

public:
	
	virtual void BuildInternal(void* &pInstance) = 0;
	
	virtual void AbsorbInternal(void* &pInstance) = 0;

	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	// NULL if error..
	template<class T>
	static void Assembly( T* &pInstance, DOMElement &element, const string tagName )
	{	
		pInstance = NULL;

		XMLCh* transcodedTagName = XMLString::transcode( tagName.c_str() );		
		XMLString::upperCase( transcodedTagName );


		DOMNodeList* const nodeList = element.getElementsByTagName( transcodedTagName );
		XMLString::release( (XMLCh**)&transcodedTagName );

		if( nodeList == NULL || nodeList->getLength() != 1 )
			return;

		// TAKZE MAME V RUCE ELEMENT SE JMENEM "tagName"
		DOMElement* selectedElement = (DOMElement*) nodeList->item(0);

		// COZ O TO, UDELAL BYCH TO STATICKOU KONSTANTOU, ALE JAK JI PAK SMAZU??
		XMLCh* transcodedTypeAttributeName = XMLString::transcode("type");
		const XMLCh* const transcodedType = selectedElement->getAttribute( transcodedTypeAttributeName );
		XMLString::release( (XMLCh**)&transcodedTypeAttributeName );

		if( !XMLString::stringLen( transcodedType ) )
			return;

		// TED MAME V RUCE JMENO TYPU Z ATRIBUTU TYPE
		string userFriendlyTypeName = XercesConnector::instance().XMLCh2str( transcodedType );
	
		MappedString2UI::const_iterator iter = userFriendlyNames2UI().find( userFriendlyTypeName );
		if( iter == userFriendlyNames2UI().end())
			return;

		// A TED PRISLUSNE UI
		UserInfo *relatedUI = iter->second;
		relatedUI->AssemblyBindedData( *selectedElement );		
		relatedUI->BuildInternal( (void*&)pInstance );
		relatedUI->ReleaseUsedMemory();

		if( pInstance == NULL )
			return;

		try
		{
			// typova kontrola "do it yourself":)
			string resultingTypeNameByRTTI = typeid( *pInstance ).name();
			if( resultingTypeNameByRTTI != relatedUI->typeNameByRTTI )
			{
				cout << "FATAL ERROR!!" << endl;
				pInstance = NULL;
			}			
		}
		catch(...)
		{
			// delete? ale jak na to? asi tezko
			pInstance = NULL;
		}		
		return;
	}	

	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	// NULL if error..
	template<class T>
	static bool Disassembly( T* pInstance, DOMElement &element, const string tagName, const string help)
	{	
		if( pInstance == NULL)
			return false;

		XMLCh* transcodedTagName = XMLString::transcode( tagName.c_str() );		
		XMLString::upperCase( transcodedTagName );

		// ADD NEW ELEMENT
		DOMDocument* pDoc = element.getOwnerDocument();
		DOMElement* selectedElement = pDoc->createElement( transcodedTagName );		
		element.appendChild( selectedElement );
		XMLString::release( (XMLCh**)&transcodedTagName );

			
		// hledame vhodne UI - co ty mapy jeste nejako zapouzdrit?!?! 
		MappedString2UI::const_iterator iter = namesByRTTI2UI().find( typeid(*pInstance).name() );
		if( iter == namesByRTTI2UI().end())
			return false;
		UserInfo *relatedUI = iter->second;

		// PRIDAM ATRIBUT TYPE - UDELAT NA TO METODU!! NEBO JESTE LEPE SPECIALNI BINDOVACI OBJEKT..
		// opet obousmernej, jen na stringy.. pouziju i u valuedUI..
		const XMLCh* transcodedTypeAttributeName = XMLString::transcode("type");
		const XMLCh* transcodedUserFriendlyTypeName = XMLString::transcode(relatedUI->userFriendlyTypeName.c_str());
		selectedElement->setAttribute( transcodedTypeAttributeName, transcodedUserFriendlyTypeName );
		XMLString::release( (XMLCh**)&transcodedTypeAttributeName );
		XMLString::release( (XMLCh**)&transcodedUserFriendlyTypeName );

		if( help.length() )
		{
			// PRIDAM ATRIBUT TYPE
			const XMLCh* transcodedHelpAttributeName = XMLString::transcode("help");
			const XMLCh* transcodedHelpString = XMLString::transcode( help.c_str() );
			selectedElement->setAttribute( transcodedHelpAttributeName, transcodedHelpString );
			XMLString::release( (XMLCh**)&transcodedHelpAttributeName );
			XMLString::release( (XMLCh**)&transcodedHelpString );
		}


		// A TED PRISLUSNE UI
		// NASMERUJE UKAZATELE BindingFrames.. nejak lip pojmenovat
		// sloz z pointeru, rozloz na pointery.. 
		relatedUI->AbsorbInternal( (void*&)pInstance );
		// rozebere soucastky
		return relatedUI->DisassemblyBindedData( *selectedElement );		
	}	

	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	// NULL if error..
	template<class T>
	static bool Disassembly( T* pInstance, DOMElement &element, const string tagName )
	{
		return Disassembly( pInstance, element, tagName, "" );
	}
};


template<typename T> class TypedUserInfo : public UserInfo
{
protected:

	//! The only constructor which fills 
	TypedUserInfo<T>( const string &userFriendlyTypeName) 
		: UserInfo( userFriendlyTypeName, typeid(T).name() ) 
	{	
	};

	//! Destructor
	~TypedUserInfo<T>()
	{
	}

public:
	// FRIEND radeji
	void BuildInternal(void* &pInstance)
	{
		T* &pTypedInstance = (T*&) pInstance;
		Build( pTypedInstance );
	}

	virtual void Build(T* &pTypedInstance) = 0;

	// FRIEND radeji
	void AbsorbInternal(void* &pInstance)
	{
		T* &pTypedInstance = (T*&) pInstance;
		Absorb( pTypedInstance );
	}

	virtual void Absorb(T* &pTypedInstance) = 0;

	static const TypedUserInfo<T> &instance;
};



/*!
@brief The main user info template class

You should derive this class whenever you need new CompoundUserInfo.
*/
template<typename T> class CompoundUserInfo : public TypedUserInfo<T>
{
private:
	//! Mapped elements, i.e., descendant html tags
	vector<BindingFrame* const> bindedElements;

protected:
	template<typename U> class BindedType: public BindingFrame
	{
	private:
		const TypedUserInfo<U> &factory;
		string name;
		string help;

	public:
		U* pInstance;

		BindedType<U>( CompoundUserInfo<T> *parent, string name, string help ) 
			: name( name), help(help)
			factory( TypedUserInfo<U>::instance )		
		{
			parent->bindedElements.push_back( this );
			pInstance = NULL;
		}

		BindedType<U>( CompoundUserInfo<T> *parent, string name ) 
			: name( name), help(""),
			factory( TypedUserInfo<U>::instance )		
		{
			parent->bindedElements.push_back( this );
			pInstance = NULL;
		}

		void AssemblyBindedData( DOMElement &element )
		{
			factory.Assembly( pInstance, element, name );
		}

		void ReleaseUsedMemory()
		{
			if( pInstance != NULL )
				delete pInstance;
		}

		bool DisassemblyBindedData( DOMElement &element )
		{
			return factory.Disassembly( pInstance, element, name, help );
		}
	};

	CompoundUserInfo<T>( string userFriendlyTypeName )
		: TypedUserInfo<T>( userFriendlyTypeName )
	{
	}


public:

	void AssemblyBindedData( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->AssemblyBindedData( element );
	}

	void ReleaseUsedMemory()
	{			
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->ReleaseUsedMemory();
	}

	bool DisassemblyBindedData( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			if( !bindedElements[ind]->DisassemblyBindedData( element ) )
				return false;
		return true;
	}
};


template<typename T> class ValuedUserInfo : public TypedUserInfo<T>
{

private:
	const XMLCh* const transcodedValueName;

public:
	// Value nemusi byt pointer, na rozdil od ostatnich binding framu..
	string value;

	ValuedUserInfo<T>( string userFriendlyTypeName )
		: TypedUserInfo<T>( userFriendlyTypeName ),
		  transcodedValueName( XMLString::transcode( "value" ))
	{
	}

	~ValuedUserInfo<T>()
	{
		XMLString::release( (XMLCh**)&transcodedValueName );
	}

	void AssemblyBindedData( DOMElement &element )
	{		
		const XMLCh* const transcodedValue = element.getAttribute( transcodedValueName );
		value = XercesConnector::instance().XMLCh2str( transcodedValue );
	}

	bool DisassemblyBindedData( DOMElement &element )
	{
		if( value.length() )
		{
			const XMLCh* transcodedValueString = XMLString::transcode( value.c_str() );
			element.setAttribute( transcodedValueName, transcodedValueString );
			XMLString::release( (XMLCh**)&transcodedValueString );
		}
		return true;
	}
};


class RootElement 
{
// umi se pretypovat na DOMElement &element	
// a to vzdy, save a load se muze udelat az pak!!

private:
	DOMElement * pRoot;
	DOMDocument* pDoc;

	const XMLCh* const transcodedFileName ;

public:

	RootElement( char* fileName )
		: transcodedFileName( XMLString::transcode( fileName ) )
	{		
		pDoc = XercesConnector::instance().pImplementation->createDocument( 
			XMLString::transcode( "M3K USER INFO" ), 
			XMLString::transcode( "ROOT" ), NULL );
		pRoot = pDoc->getDocumentElement();
	}

	~RootElement()
	{
		XMLString::release( (XMLCh**)&transcodedFileName );
		if( pDoc ) 
			delete pDoc;		
	}

	//! loads root element from a file
	bool Load( void ) 
	{
		const LocalFileInputSource inputSource( transcodedFileName );		
		DOMDocument * newDoc = XercesConnector::instance().Parse( inputSource );
		if( newDoc == NULL )					
			return false;

		if( pDoc ) 
			delete pDoc;		

		pDoc = newDoc;			
		pRoot = pDoc->getDocumentElement();
		return true;		
	}


	//! Save UserInfo to the file (typically with an XML extension)
	void Save ( void )
	{
		LocalFileFormatTarget outputTarget( transcodedFileName );	
		XercesConnector::instance().pSerializer->writeNode( &outputTarget, *pDoc);
	}	

	operator DOMElement&()
	{
		return *pRoot;
	}
};


#endif // #ifndef UI_H