#include "userinfo.h"

class IntUI: public ValuedUserInfo<int>
{
public:
	IntUI():ValuedUserInfo<int>("int")
	{
	}

	void Build(int* &pInstance)
	{
		pInstance = new int( atoi( value.c_str()) );
	}

	void Absorb(int* &pInstance)
	{
		char buff[30];
		sprintf(buff, "%d", *pInstance );
		value = buff;
	}
};

const TypedUserInfo<int>& IntUI::instance = IntUI();


class StringUI: public ValuedUserInfo<string>
{
public:
	StringUI():ValuedUserInfo<string>("string")
	{
	}

	void Build(string* &pInstance)
	{
		pInstance  = new string( value );
	}

	void Absorb(string* &pInstance)
	{
		value = *pInstance;
	}
};

const TypedUserInfo<string>& StringUI::instance = StringUI( );

class Car
{
public:
	int age;
	string brand;

	Car( int age, string brand)
		: age( age), brand( brand)
	{
	}
};

class CarUI: public CompoundUserInfo<Car>
{
public:
	BindedType<int> age;
	BindedType<string> brand;

	CarUI()
		:CompoundUserInfo<Car>("car"),
		age( this, "age" ),
		brand( this, "brand")
	{
	}

	void Build(Car* &pInstance)
	{
		if( age.pInstance == NULL ) age.pInstance = new int (0);
		if( brand.pInstance == NULL ) brand.pInstance = new string("noname");
		pInstance  = new Car( *age.pInstance, *brand.pInstance );
	}

	void Absorb(Car* &pInstance)
	{
		age.pInstance = &pInstance->age;
		brand.pInstance = &pInstance->brand;
	}
};

const TypedUserInfo<Car>& CarUI::instance = CarUI( );


int main()
{
	/////////////////////////////////// SAVING ///////////////////////////
	Car newCar( 20, "audina" );

	RootElement root("car.xml");
	// NESLO BY TAM MISTO POINTERU PRIMO REFERENCI,
	// NEBO TAK NECO?!?! ASI JO..!
	if( !UserInfo::Disassembly( &newCar,root,"kara") )
	{
		cout << "there was some error!" << endl;
		getchar();
		return 0;			
	}

	root.Save();
	cout << "the new car was saved correctly!" << endl;				
	getchar();

	//////////////////////////////////// LOADING ////////////////////////////////


	Car *loadedCar;
	root.Load();
	UserInfo::Assembly(loadedCar,root,"kara");
	
	if( loadedCar )
		cout << "loaded car: age=" << loadedCar->age << ", brand=" << loadedCar->brand << endl;
	else
		cout << "there was some error during car loading!" << endl;
		
	getchar(); 
	return 0;
}
