#ifndef UI_H
#define UI_H

#include <sstream>
#include <iostream>
#include <stdio.h>
#include <string>
#include <typeinfo>
#include <map>
#include <utility>
#include <vector>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <iostream>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/framework/LocalFileInputSource.hpp>
#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>

#ifdef XERCES_CPP_NAMESPACE_USE
XERCES_CPP_NAMESPACE_USE
#endif

using std::string;
using namespace std;

/*!
@brief Xerces interface class

This class is used to interact with the Xerces library.
*/
/// TODO slo by i bez vnorene tridy?
class AssertXercesIsAlive
{
private:
	class XercesConnector
	{
	private:
		//!default constructor
		XercesConnector()
		{
			// initialize the XML library
			XMLPlatformUtils::Initialize();
		}

		~XercesConnector()
		{
			// terminate the XML library
			XMLPlatformUtils::Terminate();
		}

	public:
		//! The only global instance of the XercesConnector class
		// potrebujeme inicializaci hned v okamziku zavolani!!
		static void StayAlive()
		{
			static XercesConnector xc;		
		};
	};


public:
	AssertXercesIsAlive()
	{
		XercesConnector::StayAlive();
	}
};


class BindingFrame
{
private:
	// okomentovat, ze musi byt prvni
	AssertXercesIsAlive dummy;
protected:
	BindingFrame();

	//! function transcodes Xerces' XMLCh-based strings into C++ strings
	string XMLCh2str( const XMLCh* const  XMLCh_str );

public:	
	// nacpe na prislusne pointery, kdyztak da NULL
	virtual void AssemblyFromXML( DOMElement &element ) = 0;

	// uvolneni pameti po slozeni objektu, tj. lze jedine po AssemblyBD
	virtual void ReleaseMemory() {}

	// vrati bool, pokud se povedlo rozebrat a naplnit element
	// nebude tu nahodou jeste ten help - string??
	virtual bool DisassamblyToXML( DOMElement &element ) = 0;		
};

class Attribute 
{		
private:
	// okomentovat, ze musi byt prvni
	AssertXercesIsAlive dummy;

	const XMLCh* const transcodedAttributeName;

public:
	Attribute( string attributeName );

	~Attribute();

	// nacpe na prislusne pointery, kdyztak da NULL
	string& Get( DOMElement &element ) const;

	void Set( DOMElement &element, const string &str ) const;	

	static const Attribute help;

	static const Attribute type;

	static const Attribute value;
};



/*!
@brief UserInfo class is for internal purposes only. Use CompoundUserInfo<T> instead.

The raison d'etre of this class is to allow pointers to (the main part of) 
CompoundUserInfo<T> objects even for different generic types.
*/
class UserInfo : protected BindingFrame
{
private:
	typedef UserInfo* const pUserInfo;

	// immediately initialized map..!!
	class StringToUIMap
	{
	private:
		//! Type definition of mapping which transforms type names to the related user infors
		typedef map< const string, pUserInfo > MappedString2UI;

		static MappedString2UI& privateMap();

	public:
		static void Add( string key, pUserInfo pInstance );

		static pUserInfo Retrieve( string key );
	};
				
	virtual void* AssemblyTypelessInstance() = 0;
	
	virtual bool DisassemblyTypelessInstance(void* pInstance) = 0;

	const string userFriendlyTypeName;

	const string typeNameByRTTI;

protected:

	//! The only constructor which fills both the transcodedTypeName and the help attribute
	UserInfo( const string& userFriendlyTypeName, const string& typeNameByRTTI )
		: userFriendlyTypeName ( userFriendlyTypeName ), typeNameByRTTI( typeNameByRTTI )
	{	
		StringToUIMap::Add( userFriendlyTypeName, this );
		// we do not care which name it is, therfore we have common map,
		// and it is no use to pass the same string again
		if( userFriendlyTypeName != typeNameByRTTI )
			StringToUIMap::Add( typeNameByRTTI, this );
	}

public:	
	//! returns object of templated type filled with data stored in this CompoundUserInfo instance
	// NULL if error.. TODO nekam dat error message..!
	template<class T>
	static T* Assembly( DOMElement &element, const string tagName )
	{	
		XMLCh* transcodedTagName = XMLString::transcode( tagName.c_str() );		
		XMLString::upperCase( transcodedTagName );


		DOMNodeList* const nodeList = element.getElementsByTagName( transcodedTagName );
		XMLString::release( (XMLCh**)&transcodedTagName );
		if( !nodeList || nodeList->getLength() == 0 )
		{
			cerr << "There is not any tag named """ << tagName << """ in the passed DOM element of a XML docmument!";
			return NULL;
		}

		if( nodeList->getLength() > 1 )
		{
			cerr << "There is to many elements named """ << tagName << """ in the passed DOM element of a XML docmument. But the tag name has to be unique!";
			return NULL;
		}

		// TAKZE MAME V RUCE ELEMENT SE JMENEM "tagName"
		DOMElement* pTheOnlyElement = (DOMElement*) nodeList->item(0);

		// TED MAME V RUCE JMENO TYPU Z ATRIBUTU TYPE
		string userFriendlyTypeName = Attribute::type.Get( *pTheOnlyElement );
	
		// A TED PRISLUSNE UI
		pUserInfo pRelatedUI = StringToUIMap::Retrieve( userFriendlyTypeName );
		if( !pRelatedUI )
		{
			cerr << "There is not any UserInfo related to type named """ << userFriendlyTypeName << """, instance assembling terminated!";
			return NULL;
		}

		pRelatedUI->AssemblyFromXML( *pTheOnlyElement );		
		void* pTypelessInstance = pRelatedUI->AssemblyTypelessInstance();
		pRelatedUI->ReleaseMemory();

		if( pTypelessInstance == NULL )
		{
			// TODO lepe specifikovat
			cerr << "Unknown error, instance assembling terminated!";
			return NULL;
		}

		T* pInstance = NULL;
		try
		{
			// typova kontrola "do it yourself":)
			pInstance = (T*) pTypelessInstance;
			string resultingTypeNameByRTTI = typeid( *pInstance ).name();
			if( resultingTypeNameByRTTI != pRelatedUI->typeNameByRTTI )
			{
				cerr << "Fatal error, UserInfo related to type """ << userFriendlyTypeName << """ have just returned instance of a different type!";
				return NULL; // TODO hlaska OK??
			}
		}
		catch(...)
		{
			pInstance = NULL; // TODO chybovou hlasku
		}		

		return pInstance;
	}	

	template<class T>
	static bool Disassembly( T& instance, DOMElement &element, const string tagName, const string help)
	{	
		pUserInfo pRelatedUI = StringToUIMap::Retrieve( typeid(instance).name() );
		if( !pRelatedUI )
			return false;

		// add a new element named according the passed tagName
		XMLCh* transcodedTagName = XMLString::transcode( tagName.c_str() );		
		XMLString::upperCase( transcodedTagName );
		DOMDocument* pDoc = element.getOwnerDocument();
		DOMElement* pCreatedElement = pDoc->createElement( transcodedTagName );		
		element.appendChild( pCreatedElement );
		XMLString::release( (XMLCh**)&transcodedTagName );
			
		// add attributes "type" and "help"
		Attribute::type.Set( *pCreatedElement, pRelatedUI->userFriendlyTypeName );		
		Attribute::help.Set( *pCreatedElement, help );

		// NASMERUJE UKAZATELE BindingFrames.. rozloz na pointery.. 
		bool result =  pRelatedUI->DisassemblyTypelessInstance( (void*) &instance );
		if( result )
			result = pRelatedUI->DisassamblyToXML( *pCreatedElement );		
		return result;
	}	

	template<class T>
	static bool Disassembly( T &instance, DOMElement &element, const string tagName )
	{
		return Disassembly( instance, element, tagName, "" );
	}
};

template<typename T> class TypedUserInfo : public UserInfo
{
private:

	bool DisassemblyTypelessInstance(void* pInstance)
	{
		try
		{
			return DisassemblyInstance( *(T*) pInstance );
		}
		catch (...)
		{
			return false;
		}
	}

	void* AssemblyTypelessInstance()
	{
		return (void*) AssemblyInstance( );
	}

	virtual T* AssemblyInstance() = 0;

	virtual bool DisassemblyInstance(T& instance) = 0;

protected:

	//! The only constructor which fills 
	TypedUserInfo<T>( const string &userFriendlyTypeName) 
		: UserInfo( userFriendlyTypeName, typeid(T).name() ) 
	{	
	};

	//! Destructor
	~TypedUserInfo<T>()
	{
	}

public:
	static const TypedUserInfo<T>& instance;

};


/*!
@brief The main user info template class

You should derive this class whenever you need new CompoundUserInfo.
*/
template<typename T> class CompoundUserInfo : public TypedUserInfo<T>
{
private:
	//! Mapped elements, i.e., descendant html tags
	vector<BindingFrame*> bindedElements;

protected:
	template<typename U> class BindedElement: public BindingFrame
	{
	private:
		string name;
		string help;				
		bool release;

		U* pValue;

		const U defaultValue;
		
	public:
		U value;

		BindedElement<U>( CompoundUserInfo<T> *parent, string name, U defaultValue, string help ) 
			: name( name), help(help), defaultValue( defaultValue )
		{
			parent->bindedElements.push_back( this );
			pValue = NULL;
			value = defaultValue;
		}

		BindedElement<U>( CompoundUserInfo<T> *parent, string name, U defaultValue ) 
			: name( name), help(""), defaultValue( defaultValue ), value( defaultValue)
		{
			parent->bindedElements.push_back( this );
			pValue = NULL;
			value = defaultValue;
		}

		~BindedElement<U>()
		{
		}

		void AssemblyFromXML( DOMElement &element )
		{
			pValue = UserInfo::Assembly<U>( element, name );
			if( pValue ) value = *pValue;			
		}

		void ReleaseMemory()
		{
			if( pValue != NULL )
				delete pValue;
		}

		bool DisassamblyToXML( DOMElement &element )
		{
			return UserInfo::Disassembly( value, element, name, help );
		}
	};

	CompoundUserInfo<T>( string userFriendlyTypeName )
		: TypedUserInfo<T>( userFriendlyTypeName )
	{
	}

public:

	void AssemblyFromXML( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->AssemblyFromXML( element );
	}

	void ReleaseMemory()
	{			
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			bindedElements[ind]->ReleaseMemory();
	}

	bool DisassamblyToXML( DOMElement &element )
	{
		for( unsigned int ind = 0; ind < bindedElements.size(); ind++ )
			if( !bindedElements[ind]->DisassamblyToXML( element ) )
				return false;
		return true;
	}
};


template<typename T> class ValuedUserInfo : public TypedUserInfo<T>
{
protected:
	ValuedUserInfo<T>( string userFriendlyTypeName )
		: TypedUserInfo<T>( userFriendlyTypeName )
	{
	}

	~ValuedUserInfo<T>()
	{
	}

public:
	// zde nemusi byt pointer
	string value;

	void AssemblyFromXML( DOMElement &element )
	{		
		value = Attribute::value.Get( element );
	}

	bool DisassamblyToXML( DOMElement &element )
	{
		Attribute::value.Set( element, value );
		return true;
	}
};


// umi se pretypovat na DOMElement &element	
// a to vzdy, save a load se muze udelat az pak!!
class RootElement 
{

private:
	// TODO musi byt prvni!! zkusit schvalne prehodit,
	// za jmeno, a zarucit, ze Xerces jeste nebezi.. hraje to fakt roli??
	const AssertXercesIsAlive dummy;

	DOMDocument* pDoc;

	const XMLCh* const transcodedFileName;

	//! DOMImplementation is a base class for the all DOM oparations
	DOMImplementation *pImplementation;

	//! This DOMWriter is used to export internal data into xml files
	DOMWriter *pSerializer;

public:
	RootElement( char* fileName );

	~RootElement();

	void Clean();

	//! loads root element from a file
	bool Load( void ) ;

	//! Save UserInfo to the file (typically with an XML extension)
	void Save ( void );

	operator DOMElement&();
};


#endif // #ifndef UI_H