#include "userinfo.h"

//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// BASIC VALUED USER INFOS ///////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

class BoolUI: public ValuedUserInfo<bool>
{
private:

	bool* AssemblyInstance()
	{		
		if( value == "true" )
			return new bool( true );
		else
			return new bool( false );
	}

	bool DisassemblyInstance(bool &instance)
	{
		if( instance )
			value = "true";
		else
			value = "false";
		return true; 
	}

public:

	BoolUI()
		: ValuedUserInfo<bool>("bool")
	{
	}
};

template<> const TypedUserInfo<bool>& TypedUserInfo<bool>::instance = BoolUI();


class IntUI: public ValuedUserInfo<int>
{
private:

	int* AssemblyInstance()
	{
		return new int( atoi( value.c_str()) );
	}

	bool DisassemblyInstance(int &instance)
	{
		char buff[30];
		sprintf(buff, "%d", instance );
		value = buff;
		return true; 
	}

public:
	IntUI():ValuedUserInfo<int>("int")
	{
	}
};

template<> const TypedUserInfo<int>& TypedUserInfo<int>::instance = IntUI();


class DoubleUI: public ValuedUserInfo<double>
{
private:

	double* AssemblyInstance()
	{
		return new double( atof( value.c_str()) );
	}

	bool DisassemblyInstance(double &instance)
	{
		char buff[30];
		sprintf(buff, "%f", instance );
		value = buff;
		return true; 
	}

public:
	DoubleUI():ValuedUserInfo<double>("double")
	{
	}
};

template<> const TypedUserInfo<double>& TypedUserInfo<double>::instance = DoubleUI();

class StringUI: public ValuedUserInfo<string>
{
private:
	string* AssemblyInstance()
	{
		return new string( value );
	}

	bool DisassemblyInstance(string &instance)
	{
		value = instance;
		return true;
	}

public:
	StringUI():ValuedUserInfo<string>("string")
	{
	}
};

template<> const TypedUserInfo<string>& TypedUserInfo<string>::instance = StringUI();

//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// EXAMPLE CLASSES DEFINITION ////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
class Transport
{
public:
	const int year;
	const string manufacturer;

	Transport( int year, string manufacturer )
		: year( year ), manufacturer( manufacturer )
	{
	}

	virtual public void ToString() = 0;
};

class Car : public Transport
{
public:
	const int kilometers;

	Car( int year, string manufacturer, int kilometers )
		: Transport( year, manufacturer ), kilometers( kilometers )
	{
	}

	void ToString()
	{
		cout << "a car made in " << year << " by " << manufacturer << ", having " << kilometers << " kilometers on the clock." << endl;
	}
};

class Bike : public Transport
{
public:
	const bool electricLights;

	Bike( int age, string manufacturer, bool electricLights )
		: Transport( age, manufacturer ), electricLights( electricLights )
	{
	}

	void ToString()
	{
		cout << "a bike made in " << year << " by " << manufacturer;
		if( electricLights ) cout << " with electric lights included";						
		cout << endl;		
	}
};

//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// AND RELATED USER INFOS ////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////


class CarUI: public CompoundUserInfo<Car>
{
private:
	BindedElement<int> year; 
	BindedElement<int> kilometers; 
	BindedElement<string> manufacturer; 
public:
	CarUI()
		:CompoundUserInfo<Car>("car"),
		year( this, "year", 0 ),
		kilometers( this, "kilometers", 0 ),
		manufacturer( this, "manufacturer", "unknown")
	{
	}
private:

	Car* AssemblyInstance()
	{
		// assembly new instance
		return new Car( year.value, manufacturer.value, kilometers.value );
	}

	bool DisassemblyInstance(Car& instance)
	{
		year.value = instance.year;
		manufacturer.value = instance.manufacturer;
		kilometers.value = instance.kilometers;
		return true;
	}
};

template<> const TypedUserInfo<Car>& TypedUserInfo<Car>::instance = CarUI( );


class BikeUI: public CompoundUserInfo<Bike>
{
private:
	BindedElement<int> year; 
	BindedElement<bool> lights; 
	BindedElement<string> manufacturer; 
public:
	BikeUI()
		:CompoundUserInfo<Bike>("bike"),
		year( this, "year", 0 ),
		lights( this, "electric_lights", false ), // jen jedno slovo!
		manufacturer( this, "manufacturer", "unknown")
	{
	}
private:

	Bike* AssemblyInstance()
	{
		// assembly new instance
		return new Bike( year.value, manufacturer.value, lights.value );
	}

	bool DisassemblyInstance(Bike& instance)
	{
		year.value = instance.year;
		manufacturer.value = instance.manufacturer;
		lights.value = instance.electricLights;
		return true;
	}
};

template<> const TypedUserInfo<Bike>& TypedUserInfo<Bike>::instance = BikeUI( );


int main()
{
	Car audi( 1998, "audi", 25000);
	Car liaz( 1992, "liaz", 1555000);
	Bike author( 1996, "author", true );

	/////////////////////////////////// SAVING ///////////////////////////

	RootElement root("transport.xml");

	if( !UserInfo::Disassembly( audi, root, "pepikovo") 
		|| !UserInfo::Disassembly( liaz, root, "jardovo") 
		|| !UserInfo::Disassembly( author, root, "ondrejovo")  )
	{
		cout << "there was some error!" << endl;
		getchar();
		return 0;			
	}

	root.Save();
	cout << "all the transport means were saved correctly" << endl;				
	getchar();

	//////////////////////////////////// LOADING ////////////////////////////////

	string whichone = "pepikovo";
//	whichone = "jardovo";
	whichone = "ondrejovo";

	root.Load();
	Transport *loaded = UserInfo::Assembly<Transport>( root,whichone);
	
	if( loaded )
		loaded->ToString();
	else
		cout << "there was some error during loading!" << endl;
		
	getchar(); 
	return 0;
}
