/*!
  \file
  \brief Bayesian Filtering using stochastic sampling (Particle Filters)
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef PF_H
#define PF_H

#include <itpp/itbase.h>
#include "../stat/libBM.h"
#include "../math/libDC.h"

using namespace itpp;

enum RESAMPLING_METHOD { MULTINOMIAL = 0, STRATIFIED = 1, SYSTEMATIC = 3 };

/*!
* \brief A Particle Filter prototype

Bayesian Filtering equations hold.
*/
class PF : public BM { 
protected:
	int n; //number of particles
	vec w; //particle weights
	Uniform_RNG URNG; //used for resampling
	
public:
	//! Returns indexes of particles that should be resampled. The ordering MUST guarantee inplace replacement. (Important for MPF.)
	ivec resample(RESAMPLING_METHOD method = SYSTEMATIC);
	PF (vec w);
	//TODO remove or implement bayes()!
	void bayes(const vec &dt, bool evell){};
};

/*!
* \brief Trivial particle filter with proposal density that is not conditioned on the data.


*/

class TrivialPF : public PF {
	Array<vec> ptcls;
	
	bool is_proposal;
	mpdf *prop;
	mpdf *par;
	mpdf *obs;
	
	public:
	TrivialPF(mpdf &par, mpdf &obs, mpdf &prop, int n0);
	TrivialPF(mpdf &par, mpdf &obs, int n0);
	void bayes(const vec &dt, bool evalll);
};

class MPF : public TrivialPF {
	Array<BM> Bms;
	public:
	MPF(BM &B, mpdf &prop, mpdf &obs, mpdf &par);
	void bayes(vec &dt);	
};

#endif // KF_H


