//
// C++ Implementation: itpp_ext
//
// Description:
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "userinfo.h"

BindingFrame::BindingFrame()
	: dummy()
{
}

string BindingFrame::XMLCh2str( const XMLCh* const  XMLCh_str )
{
	char *local = XMLString::transcode( XMLCh_str );
	string res = local;		
	XMLString::release( &local );
	return res;
}


Attribute::Attribute( string attributeName )
	: dummy(),	
	transcodedAttributeName( XMLString::transcode( attributeName.c_str() ) )
{
}

Attribute::~Attribute()
{			
	XMLString::release( (XMLCh**)&transcodedAttributeName );
}

string& Attribute::Get( DOMElement &element ) const
{
	const XMLCh* const transcoded_str = element.getAttribute( transcodedAttributeName );
	return *new string( XMLString::transcode( transcoded_str ) );
}

void Attribute::Set( DOMElement &element, const string &str ) const
{
	if( !str.length() ) return;	
	const XMLCh* transcoded_str = XMLString::transcode(str.c_str());
	element.setAttribute( transcodedAttributeName, transcoded_str );
	XMLString::release( (XMLCh**) &transcoded_str );
}

const Attribute Attribute::help( "help" );
 
const Attribute Attribute::type( "type" );

const Attribute Attribute::value( "value" );


UserInfo::StringToUIMap::MappedString2UI& UserInfo::StringToUIMap::privateMap()
{
	static MappedString2UI var;
	return var;
}

void UserInfo::StringToUIMap::Add( string key, pUserInfo pInstance )
{
	privateMap().insert( make_pair( key, pInstance ) );
}

UserInfo::pUserInfo UserInfo::StringToUIMap::Retrieve( string key )
{
	MappedString2UI::const_iterator iter = privateMap().find( key );
	if( iter == privateMap().end()) return NULL;
	else return iter->second;
}	

RootElement::RootElement(const char* fileName )
	: dummy(),
	transcodedFileName( XMLString::transcode( fileName ) )
{		
	// get a serializer, an instance of DOMWriter (the "LS" stands for load-save).
	pImplementation = DOMImplementationRegistry::getDOMImplementation( XMLString::transcode( "LS" ));

	pSerializer = ( (DOMImplementationLS*)pImplementation )->createDOMWriter();
	// set user specified end of line sequence and output encoding
	pSerializer->setNewLine( XMLString::transcode( "\n" ) );
	// optionally, set the format-pretty-print feature
	if (pSerializer->canSetFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true))
		pSerializer->setFeature(XMLUni::fgDOMWRTFormatPrettyPrint, true);

	pDoc = NULL;
	Clean();
}

RootElement::~RootElement()
{
	XMLString::release( (XMLCh**)&transcodedFileName );
	pSerializer->release();
	pDoc->release();

	AssertXercesIsAlive dummy; // TODO je zde treba?
}

void RootElement::Clean()
{
	if( pDoc ) pDoc->release();
	pDoc = pImplementation->createDocument( 
		XMLString::transcode( "M3K USER INFO" ), 
		XMLString::transcode( "ROOT" ), NULL );
}

//! loads root element from a file
bool RootElement::Load( void ) 
{
	const LocalFileInputSource inputSource( transcodedFileName );		

	//! This DOMWriter is used to import external data from xml files
	XercesDOMParser parser;

	parser.setValidationScheme(XercesDOMParser::Val_Auto);
	parser.setDoNamespaces(false);
	parser.setDoSchema(false);

	parser.parse( inputSource );
	if( parser.getErrorCount() )
		return false;

	DOMDocument * newDoc = parser.adoptDocument();	
	if( newDoc == NULL )					
		return false;

	if( pDoc ) 
		pDoc->release();

	pDoc = newDoc;			
	return true;		
}


//! Save UserInfo to the file (typically with an XML extension)
void RootElement::Save ( void )
{
	LocalFileFormatTarget outputTarget( transcodedFileName );	
	pSerializer->writeNode( &outputTarget, *pDoc);
}	

RootElement::operator DOMElement& ()
{
	return *(pDoc->getDocumentElement());
}


template<> const TypedUserInfo<bool>& TypedUserInfo<bool>::instance = BoolUI();
template<> const TypedUserInfo<int>& TypedUserInfo<int>::instance = IntUI();
template<> const TypedUserInfo<double>& TypedUserInfo<double>::instance = DoubleUI();
template<> const TypedUserInfo<string>& TypedUserInfo<string>::instance = StringUI();
