/*!
  \file
  \brief Mergers for combination of pdfs
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef MER_H
#define MER_H

#include <itpp/itbase.h>
#include "libBM.h"
#include "libEF.h"
#include "emix.h"

using namespace itpp;
using std::string;

/*!
@brief Function for general combination of pdfs 

Parent of simple arithmentic or geometric combinations
*/

class merger {
protected:	
	mat Smp;
	mprod joint;
public:
//!Default constructor
	merger (const Array<mpdf*> &in_sources) : joint(in_sources) {
		RV rvc=joint._rvc();
	}

//	project 
	//! for future use
	virtual ~merger() {};
};


#endif // MER_H
