/*!
  \file
  \brief Mergers for combination of pdfs
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef MER_H
#define MER_H

#include <itpp/itbase.h>
#include "libBM.h"
#include "libEF.h"
#include "emix.h"

using namespace itpp;
using std::string;

/*!
@brief Function for general combination of pdfs 

Parent of simple arithmentic or geometric combinations
*/

class merger : public mprod{
protected:	
	//! Additional pdf on the part in condition (if undefined);
	enorm<fsqmat> condpdf;
	//! Find potential overlaps in rv
	Array<ivec> overlaps;
public:
//!Default constructor
	merger (const Array<mpdf*> &in_sources) : mprod(in_sources,true), condpdf(rvc), overlaps(rv.count()) {
		if (rvc.count()>0) {
			vec mu = zeros(rvc.count());
			mat R = 100*eye(rvc.count());
			condpdf.set_parameters(mu,R);
		}
		for (int i=0;i<rv.count();i++){ // cycle over rv
			ivec tmp(0);
			for (int j=0;j<n;j++){//cycle over rvinds
				ivec id=itpp::find(rvinds(j)==i);
				tmp=concat(tmp,id); // add i to tmp if found
			}
			overlaps(i)=tmp;
		}
	}
	//! sample from merged density
	//! weight w is a 
	vec sample(double &w, vec smp0=zeros ( rv.count()+rvc.count())){
		// result
		vec smp=smp0;
		vec cond=sample(condpdf); // Just like in samplecond, here it is not given!
		// temporary
		mat smpi=zeros(rv.count()+rvc.count(), n);
		vec condi;
		vec ll(n);
		
		// Consider arithmetic mean as a proposal density
		ll(i) = 0;
		for ( int i = ( n - 1 );i >= 0;i-- ) {
			if ( rvcinds ( i ).length() > 0 ) {
				condi = zeros ( rvcinrv.length() + rvcinds.length() );
				// copy data in condition
				set_subvector ( condi,rvcinds ( i ), cond );
				// copy data in already generated sample
				set_subvector ( condi,rvcinrv ( i ), smp );

				mpdfs ( i )->condition ( condi );
			}
			smpi.set_col(i, epdfs ( i )->sample());
			// add ith likelihood contribution
			ll+=epdfs(i)->evalpdflog(smpi);
		}
		// Now lets analyze samples smpi
		for (int i=0;i<rv.count();i++){
			// number of components
			int noc = overlaps(i).length();
			if (noc<2) { // only one sample in this dimension, take it
				smp(i) = smpi(i,overlaps(i)(0));
			}
			else {
				//pick dimension
				double unis = UniRNG.sample();
				dim = 0;
				while(unis<(dim+1)/noc) {dim++;} // 
				//in dim we now have randomly picked dimension
				smp(i) = smpi(i,overlaps(i)(dim));
			}
		}
		
		// now we have sample how to evaluate weight?
		return smp;
		
		// copied from mprod.sample
	};
//	project 
	//! for future use
	virtual ~merger() {};
};


#endif // MER_H
