#include <itpp/itbase.h>
#include <math/chmat.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {
	// Kalman filter
	mat A0 = randu(3,3);
	mat A = A0*A0.T();
	
	//Test constructor
	chmat Ch(A);
   cout << "Testing constructors:" << endl
       << "A = " << A << endl
       << "Ch.to_mat() = " << Ch.to_mat() << endl << endl;
       
   //Test inversion
	chmat iCh(3);
	Ch.inv(iCh);
   cout << "inv(A) = " << inv(A) <<endl
   	<< "inv(Ch).to_mat() = " << iCh.to_mat() <<endl <<endl;
   	
   //Test logdet
   cout << "logdet(A) = " << log(det(A)) << endl
			<< "logdet(Ch) = " << Ch.logdet() << endl <<endl;
				
   //Test add
   chmat Ch2(Ch);
   Ch2.add(Ch);
   cout << "A+A = " << A+A << endl
			<<	"Ch2.add(Ch) = " << Ch2.to_mat() << endl <<endl;
				
	vec v=randu(3);
   //Test qform
   cout << "vAv' = " << v*(A*v) << endl
			<<	"qform(Ch,v) = " << Ch.qform(v) << endl <<endl;
	
   //Test invqform
   cout << "v inv(A)v' = " << v*(inv(A)*v) << endl
			<<	"invqform(Ch,v) = " << Ch.invqform(v) << endl <<endl;
				
   //Test opupdate
   Ch2=Ch;
   Ch2.opupdt(v,1.0);
   cout << "A+vv' = " << A+outer_product(v,v) << endl
			<<	"opupdt(Ch,v) = " << Ch2.to_mat() << endl <<endl;
				
}
