#include <estim/arx.h>
#include <stat/libEF.h>
using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {
	// Setup model
	vec th("0.8 -0.3 0.4 0.01");
	int ord=th.length();
	double sqr=0.1;
	
	//Test constructor
	mat V0 = 0.00001*eye(ord+1); V0(0.0)*= 10; //
	double nu0 = ord+1;
	
	RV thr("{theta_and_r }",vec_1(ord+1));
	ARX Ar(thr, V0, nu0);
	const epdf& Ar_ep = Ar._epdf();
				
	//Test estimation
	int ndat = 10000;
	int t,j;
	vec Yt(ndat);
	vec LL(ndat);
	Yt.set_subvector(0,randn(ord)); //initial values
	vec rgr(ord);
	
	cout << Ar_ep.mean()<<endl;
	for (t=ord; t<ndat; t++) {
		for(j=0;j<(ord);j++){rgr(j)=Yt(t-j-1);}
		Yt(t) = th*rgr + sqr * NorRNG();
		
		vec Psi = concat(Yt(t), rgr);
		Ar.bayes(Psi);
		LL(t) = Ar._ll();
	}
	cout << Ar_ep.mean()<<endl;
	
	// Test brute-froce structure estimation
	cout << Ar.structure_est(egiw(thr,V0,nu0)) <<endl;
}
