#include "emix.h"

using namespace itpp;

void emix::set_parameters ( const vec &w0, const Array<epdf*> &Coms0 ) {
	w = w0/sum(w0);
	int i;
	for ( i=0;i<w.length();i++ ) {
		it_assert_debug ( rv.equal ( Coms0 ( i )->_rv() ),"RVs do not match!" );
	}
	Coms = Coms0;
}

vec emix::sample() const {
	//Sample which component
	vec cumDist = cumsum ( w );
	double u0 = UniRNG.sample();

	int i=0;
	while ( ( cumDist ( i ) <u0 ) && ( i< ( w.length()-1 ) ) ) {i++;}

	return Coms ( i )->sample();
}

// mprod::mprod ( Array<mpdf*> mFacs, bool overlap) : mpdf ( RV(), RV() ), n ( mFacs.length() ), epdfs ( n ), mpdfs ( mFacs ), rvinds ( n ), rvcinrv ( n ), rvcinds ( n ) {
// 		int i;
// 		bool rvaddok;
// 		// Create rv
// 		for ( i = 0;i < n;i++ ) {
// 			rvaddok=rv.add ( mpdfs ( i )->_rv() ); //add rv to common rvs.
// 			// If rvaddok==false, mpdfs overlap => assert error.
// 			it_assert_debug(rvaddok||overlap,"mprod::mprod() input mpdfs overlap in rv!");
// 			epdfs ( i ) = & ( mpdfs ( i )->_epdf() ); // add pointer to epdf
// 		};
// 		// Create rvc
// 		for ( i = 0;i < n;i++ ) {
// 			rvc.add ( mpdfs ( i )->_rvc().subt ( rv ) ); //add rv to common rvs.
// 		};
// 		
// //		independent = true;
// 		//test rvc of mpdfs and fill rvinds
// 		for ( i = 0;i < n;i++ ) {
// 			// find ith rv in common rv
// 			rvsinrv ( i ) = mpdfs ( i )->_rv().dataind ( rv );
// 			// find ith rvc in common rv
// 			rvcinrv ( i ) = mpdfs ( i )->_rvc().dataind ( rv );
// 			// find ith rvc in common rv
// 			rvcinds ( i ) = mpdfs ( i )->_rvc().dataind ( rvc );
// 			//
// /*			if ( rvcinrv ( i ).length() >0 ) {independent = false;}
// 			if ( rvcinds ( i ).length() >0 ) {independent = false;}*/
// 		}
// 	};
