#include <itpp/itbase.h>
#include "merger.h"
#include "arx.h"

vec merger::lognorm_merge ( mat &lW ) {
	int nu=lW.rows();
	vec mu = sum ( lW ) /nu; //mean of logs
	vec lam = sum ( pow ( lW,2 ) )-nu*pow ( mu,2 );
	double coef=0.0;
	switch ( nu ) {
		case 2:
			coef=sqrt ( beta*2 ) * ( 1-0.5*sqrt ( ( 4*beta-3 ) /beta ) );
			return exp ( coef*sqrt ( lam ) + mu );
			break;
		case 3://Ration of Bessel
			break;
		case 4:
			break;
	}
	return vec(0);
}

void merger::merge ( const epdf* g0 ) {
	mat Smp ( rv.count(),Ns );
	mat lW=zeros ( n,Ns );

	vec lw_src ( Ns );
	vec lw_mix ( Ns );
	vec vec0 ( 0 );

	//Make sure g0 is compatible
	it_assert_debug ( rv.equal(g0->_rv()),"Incompatible g0" );

	// Initial component in the mixture model from g0
	mat V0=1e-8*eye ( rv.count() +1 );
	ARX A0 ( rv, V0, 3.0 ); //initial guess of Mix: zero mean, large variance

	//generate samples from the proposal g0
	for ( int i =0; i<Ns; i++ ) {Smp.set_col ( i,g0->sample() );}

	//Initialize Mixture model
	Mix.init ( &A0, Smp, Nc );

	bool converged=false;
	while ( !converged ) {
		Mix.bayesB ( Smp );
		//Generate weight for each particle
		for ( int i=0;i<n;i++ ) {
			//Split according to dependency in rvs
			//======== Same RVs ===========
			if ( rvsinrv ( i ).length() ==rv.count() ) {
				// no need for conditioning or marginalization
				lw_src=mpdfs ( i )->_epdf().evalpdflog_m ( Smp );
				lw_mix=Mix.logpred_m ( Smp );
			}
			lW.set_row ( i, lw_src-lw_mix );
		}
		converged = true;
	}

}

