#include <itpp/itbase.h>
#include <stat/libEF.h>
#include <estim/merger.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RV x ( "{x }","1" );

	enorm<fsqmat> f1 ( x );
	enorm<fsqmat> f2 ( x );

	f1.set_parameters ( "-5",mat ( "2" ) );
	f2.set_parameters ( "5",mat ( "10" ) );

	Array<mpdf* > A ( 2 );
	A ( 0 ) =&mepdf(f1);
	A ( 1 ) =&mepdf(f2);

	int Npoints=100;
	mat x_grid ( 1,Npoints );
	x_grid.set_row ( 0,linspace ( -10.0, 10.0 ) );

	vec l_f1=f1.evalpdflog_m ( x_grid );

	vec l_f2=f2.evalpdflog_m ( x_grid );
	mat lW(2,Npoints);
	lW.set_row(0, l_f1);
	lW.set_row(1, l_f2 );

	merger M ( A );
	cout << M.lognorm_merge(lW)<<endl;
//  	eEmp res=M.merge(100);


}

