/*!
  \file
  \brief Mergers for combination of pdfs
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef MER_H
#define MER_H

#include <itpp/itbase.h>
#include "mixef.h"

using namespace itpp;
using std::string;

/*!
@brief Function for general combination of pdfs

Mixtures of Gaussian densities are used internally. Switching to other densities should be trivial.
*/

class merger : public compositepdf, public epdf {
protected:
	//!Internal mixture of EF models
	MixEF Mix;
	//!Number of samples used in approximation
	int Ns;
	//!Number of components in a mixture
	int Nc;
	//!Prior on the log-normal merging model
	double beta;
public:
//!Default constructor
	merger ( const Array<mpdf*> &S ) :
			compositepdf ( S ), epdf ( getrv ( false ) ),
			Mix ( Array<BMEF*> ( 0 ),vec ( 0 ) )
	{ beta=2.0; Ns=100; Nc=10;}
	//! Set internal parameters used in approximation
	void set_parameters ( double beta0, int Ns0, int Nc0 ) {	beta=beta0;Ns=Ns0;Nc=Nc0;}
	//!Initialize the proposal density. This function must be called before merge()!
	void init() {
		Array<vec> Smps ( n );
		//Gibbs sampling
		for ( int i=0;i<n;i++ ) {Smps ( i ) =zeros ( 0 );}
	}
	//!Create a mixture density using known proposal
	void merge ( const epdf* g0 );
	//!Create a mixture density, make sure to call init() before the first call
	void merge () {merge ( & ( Mix._epdf() ) );};

	//! Merge log-likelihood values
	vec lognorm_merge ( mat &lW );
	//! sample from merged density
	//! weight w is a
	vec sample ( )const { return Mix._epdf().sample();}
	double evalpdflog ( const vec &dt ) const{ return Mix._epdf().evalpdflog ( dt );}
	vec mean()const {return Mix._epdf().mean();}
	//! for future use
	virtual ~merger() {};
};



#endif // MER_H
