#include <itpp/itbase.h>
#include <stat/libEF.h>
#include <estim/merger.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RV x ( "{x }","1" );

	RV z(x);
	
	enorm<fsqmat> f1 ( x );
	enorm<fsqmat> f2 ( x );

	f1.set_parameters ( "-5",mat ( "2" ) );
	f2.set_parameters ( "5",mat ( "10" ) );

	Array<mpdf* > A ( 2 );
	mepdf A1(f1);
	mepdf A2(f2);
	A ( 0 ) =&A1;
	A ( 1 ) =&A2;
	
	int Npoints=100;
	mat x_grid ( 1,Npoints );
	x_grid.set_row ( 0,linspace ( -10.0, 10.0 ) );

	vec l_f1=f1.evalpdflog_m ( x_grid );

	vec l_f2=f2.evalpdflog_m ( x_grid );
	mat lW(2,Npoints);
	lW.set_row(0, l_f1);
	lW.set_row(1, l_f2 );

	merger M ( A );
	enorm<fsqmat> g0(x);
	g0.set_parameters(vec("0.0"),mat("100.0"));
	
	M.set_parameters(1.2,1000,3);
	M.merge(&g0);
	
	vec m2 = M.lognorm_merge(lW);
	vec mm2 = M.evalpdflog_m(x_grid);
	
/*	M.set_parameters(1.0,10,3);
	vec m1 = M.lognorm_merge(lW);
	M.merge(&g0);
	vec mm1 = M.evalpdflog_m(x_grid);
	
	M.set_parameters(3.0,10,3);
	vec m3 = M.lognorm_merge(lW);
	M.merge(&g0);
	vec mm3 = M.evalpdflog_m(x_grid);
	
	M.set_parameters(300.0,10,3);
	vec m300 = M.lognorm_merge(lW);
	M.merge(&g0);
	vec mm300 = M.evalpdflog_m(x_grid);*/
		
	it_file it("merger_test.it");
	it << Name("lf1") << l_f1;
	it << Name("lf2") << l_f2;
/*	it << Name("m1") << m1;
	it << Name("mm1") << mm1;*/
	it << Name("m2") << m2;
	it << Name("mm2") << mm2;
/*	it << Name("m3") << m3;
	it << Name("mm3") << mm3;
	it << Name("m300") << m300;
	it << Name("mm300") << mm300;*/
}
