#################
# Locate Xsd from code synthesis include paths and binary
# Xsd can be found at http://codesynthesis.com/products/xsd/
# Slightly modified version of the module written by Frederic Heem, frederic.heem _at_ telsey.it

# This module defines
# XSD_INCLUDE_DIR, where to find elements.hxx, etc.
# XSD_EXECUTABLE, where is the xsd compiler
# XSD_FOUND, If false, don't try to use xsd

FIND_PATH(XSD_INCLUDE_DIR xsd/cxx/parser/elements.hxx
  "${XSD_DIR}\\libxsd"
  /usr/local/include
  /usr/include
)

FIND_PROGRAM(XSD_EXECUTABLE 
  NAMES 
    xsd
  PATHS
  "${XSD_DIR}\\bin"
    /usr/local/bin
    /usr/bin
)

# if the include and the program are found then we have it
IF(XSD_INCLUDE_DIR AND XSD_EXECUTABLE)
    SET( XSD_FOUND "YES" )
ELSE(XSD_INCLUDE_DIR AND XSD_EXECUTABLE)
  SET(XSD_FOUND "NO")
ENDIF(XSD_INCLUDE_DIR AND XSD_EXECUTABLE)


IF (XSD_FOUND)
   IF (NOT XSD_FIND_QUIETLY)
       MESSAGE(STATUS "Found XSD include directory: ${XSD_INCLUDE_DIR}")
   ENDIF (NOT XSD_FIND_QUIETLY)
ELSE (XSD_FOUND)
   IF (XSD_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find XSD include directory")
   ENDIF (XSD_FIND_REQUIRED)
ENDIF (XSD_FOUND)


MARK_AS_ADVANCED(
  XSD_INCLUDE_DIR
  XSD_EXECUTABLE
) 

