/*!
  \file
  \brief Common DataSources.
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef DS_H
#define DS_H

#include <itpp/itbase.h>
//#include <std>

using namespace itpp;

/*!
* \brief Class representing off-line data stored in memory

The data are stored in an internal matrix \c Data . Each column of Data corresponds to one discrete time observation $t$. Access to this matrix is via indexes \c rowid and \c delays.

The data can be loaded from a file.
*/
class MemDS : public DS {
mat Data;
int time;
ivec rowid;
ivec delays;

public:
	void getdata(vec &dt);
	void getdata(vec &dt, ivec &indeces);
	void linkrvs(RV &drv, RV &urv);
	void write(vec &ut){it_error("MemDS::write is not supported");}
	void write(vec &ut,ivec &indexes){it_error("MemDS::write is not supported");}
}



#endif // DS_H
