#include <itpp/itbase.h>
#include "libDS.h"

using namespace itpp;

void MemDS::getdata(vec &dt){
	it_assert_debug(dt.length()==rowid.length(), "MemDS:getdata incompatible dt");
	for(i=0;i<rowid.length();i++){
		dt(i) = Data(rowid(i),time-delays(i));
	}
}

void MemDS::getdata(vec &dt,ivec &indeces){
	int j;
	it_assert_debug(dt.length()==indeces.length(), "MemDS:getdata incompatible dt");
	for(i=0;i<indeces.length();i++){
		j = indeces (i);
		dt(i) = Data(rowid(j),time-delays(j));
	}
}

void MemDS::step() {
	if (time<Data.cols()) {time++;}
}

void MemDS::linkrvs(RV &drv, RV &urv) {
	it_assert_debug(drv.count()==rowid.length(),"MemDS::linkrvs incompatible drv");
	it_assert_debug(urv.count()==0,"MemDS does not support urv.");
	
	Drv = drv;
	Urv = urv;
}

MemDS::MemDS(vec &Dat, ivec &rowid, ivec &delays){
	it_assert_debug(max(rowid)<=Dat.rows,"MemDS rowid is too high for given Dat.")
	it_assert_debug(max(delays)<Dat.cols,"MemDS delays are too high.")
	
	time = max(delayes); 
	Data = Dat;
}