#include <itpp/itbase.h>
#include <stat/libEF.h>
#include <estim/merger.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RNG_randomize();
	
	RV x ( "{x }","1" );
	RV y ( "{y }","1" );

	RV xy=x; xy.add(y);
	
	enorm<fsqmat> f1 ( xy );
	enorm<fsqmat> f2 ( x );
		
 	f1.set_parameters ( "0 0",mat ( "0.5 0; 0 0.5" ) );
 	f2.set_parameters ( "3",mat ( "0.5" ) );
	
	Array<mpdf* > A ( 2 );
	mepdf A1(f1);
	mepdf A2(f2);
	A ( 0 ) =&A1;
	A ( 1 ) =&A2;
	
	int Npoints=100;
	mat x_grid(1,Npoints);
	x_grid.set_row(0,linspace ( -2.0, 4.0, Npoints ));
	mat y_grid(1,Npoints);
	y_grid.set_row(0,linspace ( -2.0, 4.0, Npoints ));
	
	mat Grid (2,Npoints*Npoints);
	Grid.set_submatrix ( 0,0, kron(x_grid,ones(1,Npoints)) );
	Grid.set_submatrix ( 1,0, kron(ones(1,Npoints), y_grid) );
	
	merger M ( A );
	enorm<fsqmat> g0(xy);
	g0.set_parameters(vec("1 1"),mat("1 0; 0 1"));
	
	M.set_parameters(1.2,200,2);
	M.merge(&g0);
	
	MixEF &MM = M._Mix();
	epdf* MP = MM.predictor(xy);
	
	vec Res1 = M.evalpdflog_m(Grid);
	mat Res2 = ((emix*)MP)->evalpdflog_M(Grid);
	
	it_file it("merger_iter_test.it");
	it << Name("Npoints") << Npoints;
	it << Name("Grid") << Grid;
	it << Name("Res1") << Res1;
	it << Name("Res2") << Res2;
}
