#include "../../bdm/estim/arx.h"

using namespace itpp;

int main() {
	it_file itf("DD");
	// Convert input variables to IT++ format
	mat Data;
	itf >> Name("DD") >> Data;

	// ------------------ Start of routine ---------------------------
	int ndat=Data.cols();
	int npsi=Data.rows();
	RV thr ( "1","{ theta_r }",vec_1 ( npsi ),vec_1 ( 0 ) );

	mat V0=1e-8*eye ( npsi ); //V0 ( 0,0 ) *=1.0;
	double nu0=3;
	ARX Ar ( thr,V0,nu0 );
	// estimate
	for (int i=0;i<ndat;i++ ) {Ar.bayes ( Data.get_col ( i ) );	}

	vec th = Ar._epdf().mean();

	// ------------------ End of routine -----------------------------

	cout << th <<endl;

		double ll=Ar._ll();
	cout << ll <<endl;
	
		ivec str = Ar.structure_est ( egiw ( thr,V0,nu0 ) );
	cout <<	str <<endl;
}
